/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl;

import com.devexperts.qd.QDLog;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QDLogImpl
extends QDLog {
    private final PrintStream out;
    private final PrintStream err;
    private int last_minute;
    private String last_minute_str;

    public QDLogImpl(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public QDLogImpl(PrintStream out) {
        this.out = out;
        this.err = out;
    }

    @Override
    public void debug(Object msg) {
        this.log(this.out, 'D', msg);
    }

    @Override
    public void info(Object msg) {
        this.log(this.out, 'I', msg);
    }

    @Override
    public void error(Object msg, Throwable t) {
        this.log(this.err, 'E', msg);
        if (t != null) {
            t.printStackTrace(this.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(PrintStream out, char level, Object msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(level);
        sb.append(' ');
        this.appendTime(sb);
        sb.append(" ");
        String s = String.valueOf(msg);
        if (s.startsWith("\b")) {
            sb.append(s.substring(1));
        } else {
            sb.append(this.compactName(Thread.currentThread().getName()));
            sb.append(" - ");
            sb.append(s);
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            int start = 0;
            for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != '\n') continue;
                int end = i > 0 && sb.charAt(i - 1) == '\r' ? i - 1 : i;
                out.println(sb.substring(start, end));
                start = i + 1;
            }
            out.println(sb.substring(start));
        }
    }

    private String compactName(String name) {
        StringBuffer sb = new StringBuffer();
        boolean skiplower = false;
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                sb.append(c);
                skiplower = true;
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                if (skiplower) continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
            skiplower = false;
        }
        return sb.toString();
    }

    private void appendTime(StringBuffer sb) {
        long this_time = System.currentTimeMillis();
        int this_minute = (int)(this_time / 60000L);
        if (this_minute != this.last_minute) {
            this.last_minute = this_minute;
            this.last_minute_str = new SimpleDateFormat("yyyyMMdd HHmm").format(new Date(this_time));
        }
        sb.append(this.last_minute_str);
        int secms = (int)(this_time % 60000L);
        sb.append((char)(48 + secms / 10000));
        sb.append((char)(48 + secms / 1000 % 10));
        sb.append('.');
        sb.append((char)(48 + secms / 100 % 10));
        sb.append((char)(48 + secms / 10 % 10));
        sb.append((char)(48 + secms % 10));
    }
}

