/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDErrorHandler;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.QDTicker;
import com.devexperts.qd.impl.AbstractCollector;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.LegacyAdapter;

public class HistoryViaTicker
extends AbstractCollector
implements QDHistory {
    protected final QDTicker ticker;

    public HistoryViaTicker(QDTicker ticker, QDCollector.Builder<?> builder) {
        super(builder);
        this.ticker = ticker;
    }

    @Override
    public DataScheme getScheme() {
        return this.ticker.getScheme();
    }

    @Override
    public QDAgent buildAgent(QDAgent.Builder builder) {
        return this.ticker.buildAgent(builder);
    }

    @Override
    public QDDistributor buildDistributor(QDDistributor.Builder builder) {
        return this.ticker.buildDistributor(builder);
    }

    @Override
    public boolean isStoreEverything() {
        return this.ticker.isStoreEverything();
    }

    @Override
    public void setStoreEverything(boolean store_everything) {
        this.ticker.setStoreEverything(store_everything);
    }

    @Override
    public long getMinAvailableTime(DataRecord record, int cipher, String symbol) {
        if (!record.hasTime()) {
            throw new IllegalArgumentException("Record does not contain time.");
        }
        return (long)this.ticker.getInt(record.getIntField(0), cipher, symbol) << 32 | (long)this.ticker.getInt(record.getIntField(1), cipher, symbol) & 0xFFFFFFFFL;
    }

    @Override
    public long getMaxAvailableTime(DataRecord record, int cipher, String symbol) {
        return this.getMinAvailableTime(record, cipher, symbol);
    }

    @Override
    public int getAvailableCount(DataRecord record, int cipher, String symbol, long startTime, long endTime) {
        long time = this.getMinAvailableTime(record, cipher, symbol);
        if (time == 0L && !this.ticker.isAvailable(record, cipher, symbol)) {
            return 0;
        }
        if (time < Math.min(startTime, endTime) || time > Math.max(startTime, endTime)) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean examineData(DataRecord record, int cipher, String symbol, long startTime, long endTime, RecordSink sink) {
        if (!sink.hasCapacity()) {
            return true;
        }
        RecordCursor.Owner owner = RecordCursor.allocateOwner();
        this.ticker.getData(owner, record, cipher, symbol);
        sink.append(owner.cursor());
        sink.flush();
        return false;
    }

    @Override
    public boolean examineData(DataRecord record, int cipher, String symbol, long startTime, long endTime, DataVisitor visitor) {
        return this.examineData(record, cipher, symbol, startTime, endTime, LegacyAdapter.of(visitor));
    }

    @Override
    public QDStats getStats() {
        return this.ticker.getStats();
    }

    @Override
    public boolean isSubscribed(DataRecord record, int cipher, String symbol, long time) {
        return this.ticker.isSubscribed(record, cipher, symbol, time);
    }

    @Override
    public boolean examineSubscription(RecordSink sink) {
        return this.ticker.examineSubscription(sink);
    }

    @Override
    public int getSubscriptionSize() {
        return this.ticker.getSubscriptionSize();
    }

    @Override
    public boolean examineData(RecordSink sink) {
        return this.ticker.examineData(sink);
    }

    @Override
    public boolean examineDataBySubscription(RecordSink sink, RecordSource sub) {
        return this.ticker.examineDataBySubscription(sink, sub);
    }

    @Override
    public void setErrorHandler(QDErrorHandler errorHandler) {
        this.ticker.setErrorHandler(errorHandler);
    }

    @Override
    public String getSymbol(char[] chars, int offset, int length) {
        return this.ticker.getSymbol(chars, offset, length);
    }

    @Override
    public void close() {
        this.ticker.close();
    }
}

