/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl;

import com.devexperts.qd.DataIterator;
import com.devexperts.qd.QDLog;

class Deprecation {
    private static volatile boolean legacyDataIteratorWarningShown;

    private Deprecation() {
    }

    public static void legacyDataIteratorWarning(DataIterator iterator) {
        if (legacyDataIteratorWarningShown) {
            return;
        }
        Deprecation.legacyDataIteratorWarningSync(iterator);
    }

    private static synchronized void legacyDataIteratorWarningSync(DataIterator iterator) {
        if (legacyDataIteratorWarningShown) {
            return;
        }
        legacyDataIteratorWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of custom DataIterator implementation class " + iterator.getClass().getName() + " from " + Deprecation.getSource() + ". Do not implement DataIterator interface. It is slow. Use RecordBuffer instead.");
    }

    private static String getSource() {
        StackTraceElement[] trace;
        for (StackTraceElement ste : trace = new Exception().getStackTrace()) {
            if (ste.getClassName().startsWith("com.devexperts.qd.impl.")) continue;
            return ste.getClassName() + "." + ste.getMethodName();
        }
        return "<unknown>";
    }
}

