/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl;

import com.devexperts.qd.DataIterator;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.SubscriptionProvider;
import com.devexperts.qd.impl.Deprecation;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSource;

public abstract class AbstractDistributor
implements QDDistributor {
    @Override
    public final SubscriptionProvider getAddedSubscriptionProvider() {
        return this.getAddedRecordProvider();
    }

    @Override
    public final SubscriptionProvider getRemovedSubscriptionProvider() {
        return this.getRemovedRecordProvider();
    }

    @Override
    public final void processData(DataIterator it) {
        boolean done;
        if (it instanceof RecordSource) {
            this.process((RecordSource)it);
            return;
        }
        Deprecation.legacyDataIteratorWarning(it);
        boolean withTimeSequence = this.getAddedRecordProvider().getMode().hasEventTimeSequence();
        RecordMode bufMode = withTimeSequence ? RecordMode.TIMESTAMPED_DATA : RecordMode.DATA;
        RecordBuffer buf = RecordBuffer.getInstance(bufMode);
        buf.setCapacityLimited(true);
        do {
            done = false;
            do {
                DataRecord record;
                if ((record = it.nextRecord()) == null) {
                    done = true;
                    break;
                }
                int cipher = it.getCipher();
                String symbol = it.getSymbol();
                buf.add(record, cipher, symbol).copyFrom(it);
            } while (buf.hasCapacity());
            this.process(buf);
            buf.clear();
        } while (!done);
        buf.release();
    }
}

