/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.HistorySubscriptionFilter;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.stats.QDStats;

public abstract class AbstractCollectorBuilder<T extends QDCollector>
implements QDCollector.Builder<T> {
    private final QDContract contract;
    private DataScheme scheme;
    private QDStats stats;
    private HistorySubscriptionFilter historyFilter;
    private boolean withEventTimeSequence;

    protected AbstractCollectorBuilder(QDContract contract) {
        this.contract = contract;
    }

    @Override
    public abstract T build();

    @Override
    public QDCollector.Builder<T> copyFrom(QDCollector.Builder<?> other) {
        this.scheme = other.getScheme();
        this.stats = other.getStats();
        this.historyFilter = other.getHistoryFilter();
        this.withEventTimeSequence = other.hasEventTimeSequence();
        return this;
    }

    @Override
    public final QDContract getContract() {
        return this.contract;
    }

    @Override
    public final QDCollector.Builder<T> withScheme(DataScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @Override
    public final DataScheme getScheme() {
        if (this.scheme == null) {
            return QDFactory.getDefaultScheme();
        }
        return this.scheme;
    }

    @Override
    public final QDCollector.Builder<T> withStats(QDStats stats) {
        this.stats = stats;
        return this;
    }

    @Override
    public final QDStats getStats() {
        if (this.stats == null) {
            this.stats = QDFactory.createStats(this.contract.getStatsType(), this.getScheme());
        }
        return this.stats;
    }

    @Override
    public final QDCollector.Builder<T> withHistoryFilter(HistorySubscriptionFilter historyFilter) {
        this.historyFilter = historyFilter;
        return this;
    }

    @Override
    public final HistorySubscriptionFilter getHistoryFilter() {
        return this.historyFilter;
    }

    @Override
    public QDCollector.Builder<T> withEventTimeSequence(boolean value) {
        this.withEventTimeSequence = value;
        return this;
    }

    @Override
    public boolean hasEventTimeSequence() {
        return this.withEventTimeSequence;
    }
}

