/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl;

import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.impl.AbstractAgentBuilder;
import com.devexperts.qd.impl.AbstractBuilder;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.util.LegacyAdapter;
import java.util.concurrent.Executor;

public abstract class AbstractCollector
implements QDCollector {
    protected final QDContract contract;
    private final QDAgent.Builder agentBuilder;
    private final DistributorBuilder distributorBuilder = new DistributorBuilder();
    private final boolean withEventTimeSequence;

    protected AbstractCollector(QDCollector.Builder<?> builder) {
        this.contract = builder.getContract();
        this.withEventTimeSequence = builder.hasEventTimeSequence();
        this.agentBuilder = new AgentBuilder().withEventTimeSequence(this.withEventTimeSequence);
    }

    @Override
    public final QDContract getContract() {
        return this.contract;
    }

    @Override
    public final QDAgent.Builder agentBuilder() {
        return this.agentBuilder;
    }

    @Override
    public final QDAgent createAgent(SubscriptionFilter filter) {
        return this.agentBuilder.withFilter(QDFilter.fromFilter(filter, this.getScheme())).build();
    }

    @Override
    public final QDAgent createAgent(SubscriptionFilter filter, String keyProperties) {
        return this.agentBuilder.withFilter(QDFilter.fromFilter(filter, this.getScheme())).withKeyProperties(keyProperties).build();
    }

    @Override
    public final QDDistributor.Builder distributorBuilder() {
        return this.distributorBuilder;
    }

    @Override
    public final QDDistributor createDistributor(SubscriptionFilter filter) {
        return ((QDDistributor.Builder)this.distributorBuilder.withFilter(QDFilter.fromFilter(filter, this.getScheme()))).build();
    }

    @Override
    public final QDDistributor createDistributor(SubscriptionFilter filter, String keyProperties) {
        return ((QDDistributor.Builder)this.distributorBuilder.withFilter(QDFilter.fromFilter(filter, this.getScheme()))).withKeyProperties(keyProperties).build();
    }

    @Override
    public String getSymbol(char[] chars, int offset, int length) {
        return null;
    }

    @Override
    public final boolean examineData(DataVisitor visitor) {
        return this.examineData(LegacyAdapter.of(visitor));
    }

    @Override
    public final boolean examineSubscription(SubscriptionVisitor visitor) {
        return this.examineSubscription(LegacyAdapter.of(visitor));
    }

    @Override
    public boolean examineData(RecordSink sink) {
        return false;
    }

    @Override
    public boolean examineDataBySubscription(RecordSink sink, RecordSource sub) {
        return false;
    }

    @Override
    public void remove(RecordSource source) {
    }

    @Override
    public boolean hasEventTimeSequence() {
        return this.withEventTimeSequence;
    }

    @Override
    public boolean isStoreEverything() {
        return false;
    }

    @Override
    public void setStoreEverything(boolean storeEverything) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStoreEverythingFilter(SubscriptionFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeLockBoundTask(Executor executor, Runnable task) {
        executor.execute(task);
    }

    @Override
    public abstract QDAgent buildAgent(QDAgent.Builder var1);

    @Override
    public abstract QDDistributor buildDistributor(QDDistributor.Builder var1);

    public class DistributorBuilder
    extends AbstractBuilder<QDDistributor.Builder, DistributorBuilder>
    implements QDDistributor.Builder {
        @Override
        public QDDistributor build() {
            return AbstractCollector.this.buildDistributor(this);
        }

        @Override
        public String toString() {
            return "DistributorBuilder{" + super.toString() + '}';
        }
    }

    public class AgentBuilder
    extends AbstractAgentBuilder {
        @Override
        public QDAgent build() {
            return AbstractCollector.this.buildAgent(this);
        }
    }
}

