/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl;

import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SubscriptionConsumer;
import com.devexperts.qd.SubscriptionIterator;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.ng.AbstractRecordProvider;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.util.LegacyAdapter;

public abstract class AbstractAgent
extends AbstractRecordProvider
implements QDAgent {
    private final QDAgent.AttachmentStrategy attachmentStrategy;
    private final boolean useHistorySnapshot;
    private final boolean hasEventTimeSequence;
    private final SubscriptionConsumer addingConsumer = new SubscriptionConsumer(){

        @Override
        public void processSubscription(SubscriptionIterator iterator) {
            AbstractAgent.this.addSubscription(iterator);
        }
    };
    private final SubscriptionConsumer removingConsumer = new SubscriptionConsumer(){

        @Override
        public void processSubscription(SubscriptionIterator iterator) {
            AbstractAgent.this.removeSubscription(iterator);
        }
    };

    protected AbstractAgent(QDContract contract, QDAgent.Builder builder) {
        this.attachmentStrategy = builder.getAttachmentStrategy();
        this.useHistorySnapshot = contract != QDContract.TICKER && builder.useHistorySnapshot();
        this.hasEventTimeSequence = builder.hasEventTimeSequence();
    }

    public final boolean hasAttachmentStrategy() {
        return this.attachmentStrategy != null;
    }

    public final Object updateAttachment(Object oldAttachment, RecordCursor cursor, boolean remove) {
        return this.attachmentStrategy.updateAttachment(oldAttachment, cursor, remove);
    }

    public boolean useHistorySnapshot() {
        return this.useHistorySnapshot;
    }

    @Override
    public RecordProvider getSnapshotProvider() {
        return RecordProvider.VOID;
    }

    @Override
    public final void setStreamOverflowStrategy(int max_buffer_size, boolean drop_oldest, boolean log_overflow) {
        this.setBufferOverflowStrategy(max_buffer_size, drop_oldest, log_overflow);
    }

    @Override
    public final void setBufferOverflowStrategy(int max_buffer_size, boolean drop_oldest, boolean log_overflow) {
        this.setMaxBufferSize(max_buffer_size);
        this.setBufferOverflowStrategy(drop_oldest ? QDAgent.BufferOverflowStrategy.DROP_OLDEST : QDAgent.BufferOverflowStrategy.DROP_NEWEST);
    }

    @Override
    public void setMaxBufferSize(int maxBufferSize) {
        if (maxBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setBufferOverflowStrategy(QDAgent.BufferOverflowStrategy bufferOverflowStrategy) {
        if (bufferOverflowStrategy == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public final SubscriptionConsumer getAddingSubscriptionConsumer() {
        return this.addingConsumer;
    }

    @Override
    public final SubscriptionConsumer getRemovingSubscriptionConsumer() {
        return this.removingConsumer;
    }

    @Override
    public final void addSubscription(SubscriptionIterator iterator) {
        RecordSource source = LegacyAdapter.of(iterator);
        this.addSubscription(source);
        LegacyAdapter.release(iterator, source);
    }

    @Override
    public int addSubscriptionPart(RecordSource source, int notify) {
        this.addSubscription(source);
        return 0;
    }

    @Override
    public final void removeSubscription(SubscriptionIterator iterator) {
        RecordSource source = LegacyAdapter.of(iterator);
        this.removeSubscription(source);
        LegacyAdapter.release(iterator, source);
    }

    @Override
    public int removeSubscriptionPart(RecordSource source, int notify) {
        this.removeSubscription(source);
        return 0;
    }

    @Override
    public final void setSubscription(SubscriptionIterator iterator) {
        RecordSource source = LegacyAdapter.of(iterator);
        this.setSubscription(source);
        LegacyAdapter.release(iterator, source);
    }

    @Override
    public int setSubscriptionPart(RecordSource source, int notify) {
        this.setSubscription(source);
        return 0;
    }

    @Override
    public int closePart(int notify) {
        this.close();
        return 0;
    }

    @Override
    public RecordMode getMode() {
        RecordMode mode = RecordMode.MARKED_DATA;
        if (this.attachmentStrategy != null) {
            mode = mode.withAttachment();
        }
        if (this.useHistorySnapshot) {
            mode = mode.withEventFlags();
        }
        if (this.hasEventTimeSequence) {
            mode = mode.withEventTimeSequence();
        }
        return mode;
    }

    @Override
    public abstract void setRecordListener(RecordListener var1);

    @Override
    public final boolean examineSubscription(SubscriptionVisitor visitor) {
        return this.examineSubscription(LegacyAdapter.of(visitor));
    }
}

