/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.SymbolCodec;
import java.util.Random;

public class SymbolList {
    protected final int[] ciphers;
    protected final String[] symbols;
    protected final int n;

    public SymbolList(String[] symbols, SymbolCodec codec) {
        this(symbols.length);
        for (int i = 0; i < symbols.length; ++i) {
            int c;
            String s = symbols[i];
            this.ciphers[i] = c = codec.encode(s);
            this.symbols[i] = c == 0 ? s : null;
        }
    }

    public SymbolList(int[] ciphers, String[] symbols) {
        this(symbols.length);
        if (ciphers.length != this.n) {
            throw new IllegalArgumentException("symbols and ciphers must have equal length");
        }
        System.arraycopy(symbols, 0, this.symbols, 0, this.n);
        System.arraycopy(ciphers, 0, this.ciphers, 0, this.n);
    }

    protected SymbolList(int n) {
        this.n = n;
        this.symbols = new String[n];
        this.ciphers = new int[n];
    }

    public SymbolList(SymbolList another) {
        this.n = another.n;
        this.ciphers = another.ciphers;
        this.symbols = another.symbols;
    }

    public String getSymbol(int i) {
        return this.symbols[i];
    }

    public int getCipher(int i) {
        return this.ciphers[i];
    }

    public int size() {
        return this.n;
    }

    public SymbolList generateRandomSublist(int expectedSize) {
        Random rnd = new Random();
        int[] a = new int[this.n];
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            if (rnd.nextInt(this.n) >= expectedSize) continue;
            a[k++] = i;
        }
        SymbolList res = new SymbolList(k);
        for (int i = 0; i < k; ++i) {
            res.ciphers[i] = this.ciphers[a[i]];
            res.symbols[i] = this.symbols[a[i]];
        }
        return res;
    }

    public int getUncodedCount() {
        int res = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.ciphers[i] != 0) continue;
            ++res;
        }
        return res;
    }
}

