/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.Deprecation;
import com.devexperts.qd.SubscriptionConsumer;
import com.devexperts.qd.SubscriptionIterator;
import com.devexperts.qd.SubscriptionListener;
import com.devexperts.qd.SubscriptionProvider;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.util.LegacyIteratorUtils;

@Deprecated
public class SubscriptionBuffer
implements SubscriptionConsumer,
SubscriptionProvider,
SubscriptionIterator,
SubscriptionVisitor {
    private SubscriptionListener listener;
    private DataRecord[] records = new DataRecord[16];
    private int[] ciphers = new int[this.records.length];
    private String[] symbols = new String[this.records.length];
    private long[] times = new long[this.records.length];
    private int record_mask = this.records.length - 1;
    private int record_head = 0;
    private int record_tail = 0;
    private int it_cipher = 0;
    private String it_symbol = null;
    private long it_time = 0L;
    public static final SubscriptionBuffer VOID;

    public static boolean process(SubscriptionIterator iterator, SubscriptionVisitor visitor) {
        return LegacyIteratorUtils.processSubscription(iterator, visitor);
    }

    public int size() {
        return this.record_tail - this.record_head & this.record_mask;
    }

    public boolean isEmpty() {
        return this.record_tail == this.record_head;
    }

    public void clear() {
        int i = this.record_head;
        while (i != this.record_tail) {
            this.records[i] = null;
            this.ciphers[i] = 0;
            this.symbols[i] = null;
            this.times[i] = 0L;
            i = i + 1 & this.record_mask;
        }
        this.record_head = 0;
        this.record_tail = 0;
        this.it_cipher = 0;
        this.it_symbol = null;
        this.it_time = 0L;
    }

    public int getCipher(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.ciphers[this.record_head + index & this.record_mask];
    }

    public String getSymbol(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.symbols[this.record_head + index & this.record_mask];
    }

    public long getTime(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.times[this.record_head + index & this.record_mask];
    }

    public DataRecord getRecord(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.records[this.record_head + index & this.record_mask];
    }

    public void examineRecord(int index, SubscriptionVisitor visitor) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        index = this.record_head + index & this.record_mask;
        visitor.visitRecord(this.records[index], this.ciphers[index], this.symbols[index], this.times[index]);
    }

    public boolean examineSubscription(SubscriptionVisitor visitor) {
        int i = this.record_head;
        while (i != this.record_tail) {
            if (!visitor.hasCapacity()) {
                return true;
            }
            visitor.visitRecord(this.records[i], this.ciphers[i], this.symbols[i], this.times[i]);
            i = i + 1 & this.record_mask;
        }
        return false;
    }

    public SubscriptionIterator examiningIterator() {
        return new SubscriptionIterator(){
            private int index;
            private int it_cipher;
            private String it_symbol;
            private long it_time;

            @Override
            public int getCipher() {
                return this.it_cipher;
            }

            @Override
            public String getSymbol() {
                return this.it_symbol;
            }

            @Override
            public long getTime() {
                return this.it_time;
            }

            @Override
            public DataRecord nextRecord() {
                if (this.index >= SubscriptionBuffer.this.size()) {
                    return null;
                }
                this.it_cipher = SubscriptionBuffer.this.getCipher(this.index);
                this.it_symbol = SubscriptionBuffer.this.getSymbol(this.index);
                this.it_time = SubscriptionBuffer.this.getTime(this.index);
                return SubscriptionBuffer.this.getRecord(this.index++);
            }
        };
    }

    @Override
    public void processSubscription(SubscriptionIterator iterator) {
        boolean was_empty = this.isEmpty();
        LegacyIteratorUtils.processSubscription(iterator, this);
        if (was_empty && !this.isEmpty()) {
            this.notifyListener();
        }
    }

    @Override
    public boolean retrieveSubscription(SubscriptionVisitor visitor) {
        return LegacyIteratorUtils.processSubscription(this, visitor);
    }

    @Override
    public void setSubscriptionListener(SubscriptionListener listener) {
        this.listener = listener;
        if (!this.isEmpty()) {
            this.notifyListener();
        }
    }

    @Override
    public int getCipher() {
        return this.it_cipher;
    }

    @Override
    public String getSymbol() {
        return this.it_symbol;
    }

    @Override
    public long getTime() {
        return this.it_time;
    }

    @Override
    public DataRecord nextRecord() {
        if (this.record_head == this.record_tail) {
            return null;
        }
        DataRecord record = this.records[this.record_head];
        this.it_cipher = this.ciphers[this.record_head];
        this.it_symbol = this.symbols[this.record_head];
        this.it_time = this.times[this.record_head];
        this.records[this.record_head] = null;
        this.ciphers[this.record_head] = 0;
        this.symbols[this.record_head] = null;
        this.times[this.record_head] = 0L;
        this.record_head = this.record_head + 1 & this.record_mask;
        return record;
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol, long time) {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.ensureCapacity(record);
        this.records[this.record_tail] = record;
        this.ciphers[this.record_tail] = cipher;
        this.symbols[this.record_tail] = symbol;
        this.times[this.record_tail] = time;
        this.record_tail = this.record_tail + 1 & this.record_mask;
    }

    public void visitRecord(DataRecord record, int cipher, String symbol) {
        this.visitRecord(record, cipher, symbol, 0L);
    }

    protected void notifyListener() {
        SubscriptionListener listener = this.listener;
        if (listener != null) {
            listener.subscriptionAvailable(this);
        }
    }

    protected void ensureCapacity(DataRecord record) {
        int size = this.record_tail - this.record_head & this.record_mask;
        if (this.record_mask - size <= 2) {
            int length = this.records.length;
            int new_length = length << 1;
            this.records = new DataRecord[new_length];
            SubscriptionBuffer.copy(this.records, this.records, this.record_head, this.record_tail, length);
            this.ciphers = new int[new_length];
            SubscriptionBuffer.copy(this.ciphers, this.ciphers, this.record_head, this.record_tail, length);
            this.symbols = new String[new_length];
            SubscriptionBuffer.copy(this.symbols, this.symbols, this.record_head, this.record_tail, length);
            this.times = new long[new_length];
            SubscriptionBuffer.copy(this.times, this.times, this.record_head, this.record_tail, length);
            this.record_mask = new_length - 1;
            this.record_head = 0;
            this.record_tail = size;
        }
    }

    protected static void copy(Object src, Object dst, int head, int tail, int length) {
        if (tail < head) {
            System.arraycopy(src, head, dst, 0, length - head);
            System.arraycopy(src, 0, dst, length - head, tail);
        } else {
            System.arraycopy(src, head, dst, 0, tail - head);
        }
    }

    static {
        Deprecation.warning(SubscriptionBuffer.class);
        VOID = new VoidBuffer();
    }

    private static class VoidBuffer
    extends SubscriptionBuffer
    implements SubscriptionListener {
        private VoidBuffer() {
        }

        @Override
        public SubscriptionIterator examiningIterator() {
            return this;
        }

        @Override
        public void setSubscriptionListener(SubscriptionListener listener) {
        }

        @Override
        public void visitRecord(DataRecord record, int cipher, String symbol, long time) {
        }

        @Override
        public void subscriptionAvailable(SubscriptionProvider provider) {
            provider.retrieveSubscription(this);
        }
    }
}

