/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.kit.ByteArrayField;
import com.devexperts.qd.kit.CompactCharField;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.kit.DateField;
import com.devexperts.qd.kit.DecimalField;
import com.devexperts.qd.kit.LongField;
import com.devexperts.qd.kit.MarshalledObjField;
import com.devexperts.qd.kit.PlainIntField;
import com.devexperts.qd.kit.SequenceField;
import com.devexperts.qd.kit.ShortStringField;
import com.devexperts.qd.kit.StringField;
import com.devexperts.qd.kit.TimeMillisField;
import com.devexperts.qd.kit.TimeSecondsField;
import com.devexperts.qd.kit.VoidIntField;
import com.devexperts.qd.kit.WideDecimalField;

public final class SerialFieldType {
    public static final SerialFieldType VOID = new SerialFieldType(0, "VOID");
    public static final SerialFieldType BYTE = new SerialFieldType(1, "BYTE");
    public static final SerialFieldType UTF_CHAR = new SerialFieldType(2, "UTF_CHAR");
    public static final SerialFieldType SHORT = new SerialFieldType(3, "SHORT");
    public static final SerialFieldType INT = new SerialFieldType(4, "INT");
    public static final SerialFieldType COMPACT_INT = new SerialFieldType(8, "COMPACT_INT");
    public static final SerialFieldType BYTE_ARRAY = new SerialFieldType(9, "BYTE_ARRAY");
    public static final SerialFieldType UTF_CHAR_ARRAY = new SerialFieldType(10, "UTF_CHAR_ARRAY");
    public static final SerialFieldType DECIMAL = new SerialFieldType(24, "DECIMAL");
    public static final SerialFieldType SHORT_STRING = new SerialFieldType(40, "SHORT_STRING");
    public static final SerialFieldType TIME_SECONDS = new SerialFieldType(56, "TIME_SECONDS");
    public static final SerialFieldType TIME_MILLIS = new SerialFieldType(152, "TIME_MILLIS");
    public static final SerialFieldType TIME_NANOS = new SerialFieldType(168, "TIME_NANOS");
    @Deprecated
    public static final SerialFieldType TIME = TIME_SECONDS;
    public static final SerialFieldType SEQUENCE = new SerialFieldType(72, "SEQUENCE");
    public static final SerialFieldType DATE = new SerialFieldType(88, "DATE");
    public static final SerialFieldType LONG = new SerialFieldType(104, "LONG");
    public static final SerialFieldType WIDE_DECIMAL = new SerialFieldType(120, "WIDE_DECIMAL");
    public static final SerialFieldType STRING = new SerialFieldType(137, "STRING");
    public static final SerialFieldType CUSTOM_OBJECT = new SerialFieldType(233, "CUSTOM_OBJECT");
    public static final SerialFieldType SERIAL_OBJECT = new SerialFieldType(249, "SERIAL_OBJECT");
    private static final SerialFieldType ID = LONG.withName("ID");
    private static final SerialFieldType MMID = SHORT_STRING.withName("MMID");
    private static final SerialFieldType EXCHANGE = UTF_CHAR.withName("EXCHANGE");
    private static final SerialFieldType PRICE = DECIMAL.withName("PRICE");
    private static final SerialFieldType SIZE = COMPACT_INT.withName("SIZE");
    private static final SerialFieldType VOLUME = DECIMAL.withName("VOLUME");
    private static final SerialFieldType COUNT = DECIMAL.withName("COUNT");
    private static final SerialFieldType VOLATILITY = DECIMAL.withName("VOLATILITY");
    private static final SerialFieldType OPEN_INTEREST = COMPACT_INT.withName("OPEN_INTEREST");
    private static final SerialFieldType BOOLEAN = COMPACT_INT.withName("BOOLEAN");
    private static final SerialFieldType TICK = COMPACT_INT.withName("TICK");
    private static final SerialFieldType SALE_CONDITIONS = SHORT_STRING.withName("SALE_CONDITIONS");
    private static final SerialFieldType SALE_FLAGS = COMPACT_INT.withName("SALE_FLAGS");
    private static final SerialFieldType PROFILE_FLAGS = COMPACT_INT.withName("PROFILE_FLAGS");
    private static final SerialFieldType BID_TIME = TIME_SECONDS.withName("BID_TIME");
    private static final SerialFieldType ASK_TIME = TIME_SECONDS.withName("ASK_TIME");
    private static final SerialFieldType TRADE_TIME = TIME_SECONDS.withName("TRADE_TIME");
    private static final SerialFieldType CANDLE_TIME = TIME_SECONDS.withName("CANDLE_TIME");
    private static final SerialFieldType QUOTE_PRICE = DECIMAL.withName("QUOTE_PRICE");
    private static final SerialFieldType TRADE_PRICE = DECIMAL.withName("TRADE_PRICE");
    private static final SerialFieldType SUMMARY_PRICE = DECIMAL.withName("SUMMARY_PRICE");
    private static final SerialFieldType CANDLE_PRICE = DECIMAL.withName("CANDLE_PRICE");
    private static final SerialFieldType CANDLE_OPEN_INTEREST = DECIMAL.withName("CANDLE_OPEN_INTEREST");
    private final String name;
    private final int id;
    private final boolean isObject;
    private final boolean isLong;

    private SerialFieldType(int id, String name) {
        this.id = id;
        this.name = name;
        this.isObject = (id & 0xFFFFFF0F) == 9 || (id & 0xFFFFFF0F) == 10;
        boolean bl = this.isLong = (id & 0xF0) == 112 || (id & 0xF0) == 96 || (id & 0xF0) == 144;
        if (this.isLong && this.isObject) {
            throw new IllegalArgumentException("conflicting type");
        }
    }

    public boolean isDecimal() {
        return (this.id & 0xF0) == 16;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SerialFieldType)) {
            return false;
        }
        SerialFieldType other = (SerialFieldType)o;
        return this.id == other.id && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.id;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean hasSameSerialTypeAs(SerialFieldType other) {
        return (other.id & 0xFFFFFF0F) == (this.id & 0xFFFFFF0F);
    }

    public boolean hasSameRepresentationAs(SerialFieldType other) {
        return (other.id & 0xF0) == (this.id & 0xF0);
    }

    public SerialFieldType withName(String name) {
        return new SerialFieldType(this.id, name);
    }

    public SerialFieldType forNamedField(String name) {
        SerialFieldType type = this.forNamedFieldImpl(name);
        if (!this.hasSameSerialTypeAs(type)) {
            throw new RuntimeException("Invalid type " + type + " for named field " + name + " with base type " + this);
        }
        return type;
    }

    private SerialFieldType forNamedFieldImpl(String name) {
        if (this == COMPACT_INT || this == TIME_SECONDS) {
            if (name.endsWith("Bid.Time")) {
                return BID_TIME;
            }
            if (name.endsWith("Ask.Time")) {
                return ASK_TIME;
            }
            if (name.endsWith("Last.Time") || name.endsWith("TradeHistory.Time") || name.endsWith("TimeAndSale.Time")) {
                return TRADE_TIME;
            }
            if ((name.startsWith("Trade.") || name.startsWith("Candle.")) && name.endsWith(".Time")) {
                return CANDLE_TIME;
            }
        }
        if (this == COMPACT_INT && name.endsWith("Time")) {
            return TIME_SECONDS;
        }
        if (this == DECIMAL) {
            if (name.endsWith("Bid.Price") || name.endsWith("Ask.Price")) {
                return QUOTE_PRICE;
            }
            if (name.endsWith("Last.Price") || name.endsWith("TradeHistory.Price") || name.endsWith("TradeHistory.Bid") || name.endsWith("TradeHistory.Ask") || name.endsWith("TimeAndSale.Price") || name.endsWith("TimeAndSale.Bid") || name.endsWith("TimeAndSale.Ask")) {
                return TRADE_PRICE;
            }
            if (name.endsWith("High.Price") || name.endsWith("Low.Price") || name.endsWith("Open.Price") || name.endsWith("Close.Price")) {
                return SUMMARY_PRICE;
            }
            if ((name.startsWith("Trade.") || name.startsWith("Candle.")) && (name.endsWith("Open") || name.endsWith("High") || name.endsWith("Low") || name.endsWith("Close") || name.endsWith("VWAP"))) {
                return CANDLE_PRICE;
            }
            if (name.endsWith("Price") || name.endsWith("Bid") || name.endsWith("Ask") || name.endsWith("VWAP") || name.endsWith("Open") || name.endsWith("High") || name.endsWith("Low") || name.endsWith("Close")) {
                return PRICE;
            }
        }
        if (this == COMPACT_INT && (name.endsWith("Date") || name.endsWith("DayId"))) {
            return DATE;
        }
        if (this == COMPACT_INT && name.endsWith("Sequence")) {
            return SEQUENCE;
        }
        if (this == LONG && name.endsWith("Id")) {
            return ID;
        }
        if (this == SHORT_STRING && name.endsWith("MMID")) {
            return MMID;
        }
        if (this == UTF_CHAR && name.endsWith("Exchange")) {
            return EXCHANGE;
        }
        if (this == COMPACT_INT && name.endsWith("Size")) {
            return SIZE;
        }
        if (this == DECIMAL && name.endsWith("Volume")) {
            return VOLUME;
        }
        if (this == DECIMAL && name.endsWith("Count")) {
            return COUNT;
        }
        if (this == DECIMAL && name.endsWith("Volatility")) {
            return VOLATILITY;
        }
        if (this == COMPACT_INT && name.endsWith("OpenInterest")) {
            return OPEN_INTEREST;
        }
        if (this == DECIMAL && name.startsWith("Trade.") && name.endsWith("OpenInterest")) {
            return CANDLE_OPEN_INTEREST;
        }
        if (this == SHORT_STRING && name.endsWith("SaleConditions")) {
            return SALE_CONDITIONS;
        }
        if (this == COMPACT_INT && (name.endsWith("IsIndex") || name.endsWith("IsEuropean") || name.endsWith("IsMarginable"))) {
            return BOOLEAN;
        }
        if (this == COMPACT_INT && name.endsWith("Tick")) {
            return TICK;
        }
        if (this == COMPACT_INT && name.endsWith("Sale.Flags")) {
            return SALE_FLAGS;
        }
        if (this == COMPACT_INT && name.endsWith("Profile.Flags")) {
            return PROFILE_FLAGS;
        }
        return this;
    }

    public DataIntField createDefaultIntInstance(int index, String name) {
        switch (this.id & 0xFFFFFF0F) {
            case 0: {
                return new VoidIntField(index, name);
            }
            case 2: {
                return new CompactCharField(index, name, this);
            }
            case 4: {
                return new PlainIntField(index, name, this);
            }
            case 8: {
                switch (this.id & 0xF0) {
                    case 16: {
                        return new DecimalField(index, name, this);
                    }
                    case 32: {
                        return new ShortStringField(index, name, this);
                    }
                    case 48: {
                        return new TimeSecondsField(index, name);
                    }
                    case 144: {
                        return new TimeMillisField(index, name);
                    }
                    case 64: {
                        return new SequenceField(index, name);
                    }
                    case 80: {
                        return new DateField(index, name);
                    }
                    case 96: {
                        return new LongField(index, name);
                    }
                    case 112: {
                        return new WideDecimalField(index, name);
                    }
                }
                return new CompactIntField(index, name, this);
            }
        }
        return null;
    }

    public DataObjField createDefaultObjInstance(int index, String name) {
        switch (this.id & 0xFFFFFF0F) {
            case 9: {
                switch (this.id & 0xF0) {
                    case 128: {
                        return new StringField(index, name, true);
                    }
                    case 240: {
                        return new MarshalledObjField(index, name);
                    }
                }
                return new ByteArrayField(index, name);
            }
            case 10: {
                return new StringField(index, name);
            }
        }
        return null;
    }

    public static class Bits {
        public static final int REPRESENTATION_MASK = 240;
        public static final int SERIAL_TYPE_MASK = -241;
        public static final int MIN_TYPE_ID = 0;
        public static final int MAX_TYPE_ID = 255;
        public static final int ID_VOID = 0;
        public static final int ID_BYTE = 1;
        public static final int ID_UTF_CHAR = 2;
        public static final int ID_SHORT = 3;
        public static final int ID_INT = 4;
        public static final int ID_COMPACT_INT = 8;
        public static final int ID_BYTE_ARRAY = 9;
        public static final int ID_UTF_CHAR_ARRAY = 10;
        public static final int FLAG_INT = 0;
        public static final int FLAG_DECIMAL = 16;
        public static final int FLAG_SHORT_STRING = 32;
        public static final int FLAG_TIME_SECONDS = 48;
        @Deprecated
        public static final int FLAG_TIME = 48;
        public static final int FLAG_SEQUENCE = 64;
        public static final int FLAG_DATE = 80;
        public static final int FLAG_LONG = 96;
        public static final int FLAG_WIDE_DECIMAL = 112;
        public static final int FLAG_STRING = 128;
        public static final int FLAG_TIME_MILLIS = 144;
        public static final int FLAG_TIME_NANOS = 160;
        public static final int FLAG_CUSTOM_OBJECT = 224;
        public static final int FLAG_SERIAL_OBJECT = 240;

        private Bits() {
        }
    }
}

