/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.StableSubscriptionFilter;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.kit.NotFilter;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordFilter;
import com.devexperts.qd.util.SymbolSet;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.GuardedBy;

public abstract class QDFilter
implements SubscriptionFilter,
StableSubscriptionFilter,
RecordFilter {
    public static final QDFilter ANYTHING = new Constant(true);
    public static final QDFilter NOTHING = new Constant(false);
    private final DataScheme scheme;
    private String name;
    @GuardedBy(value="updated")
    private ArrayList<UpdateListener> listeners;
    private final Updated updated;

    protected QDFilter(DataScheme scheme) {
        this(scheme, null);
    }

    protected QDFilter(DataScheme scheme, QDFilter source) {
        if (source != null && source.scheme != scheme) {
            throw new IllegalArgumentException("Scheme must match in an updated instance of dynamic filter");
        }
        this.scheme = scheme;
        this.updated = source != null ? source.updated : new Updated(this);
    }

    public final DataScheme getScheme() {
        return this.scheme;
    }

    public Kind getKind() {
        return Kind.OTHER;
    }

    public SymbolSet getSymbolSet() {
        return null;
    }

    public abstract boolean accept(QDContract var1, DataRecord var2, int var3, String var4);

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        String defaultName = this.getDefaultName();
        if (defaultName == null) {
            throw new UnsupportedOperationException("Filter name is not defined");
        }
        this.setName(defaultName);
        return this.name;
    }

    public SyntaxPrecedence getSyntaxPrecedence() {
        return SyntaxPrecedence.TOKEN;
    }

    public synchronized void setName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setShortName(String name) {
        QDFilter.checkShortName(name);
        this.setName(name);
    }

    public boolean hasShortName() {
        return QDFilter.isShortName(this.name);
    }

    public void setNameOrDefault(String name) {
        String defaultName = this.getDefaultName();
        this.setName(defaultName != null && defaultName.length() < name.length() ? defaultName : name);
    }

    public String getDefaultName() {
        return null;
    }

    @Override
    public final boolean acceptRecord(DataRecord record, int cipher, String symbol) {
        return this.accept(null, record, cipher, symbol);
    }

    @Override
    public final boolean accept(RecordCursor cur) {
        return this.acceptRecord(cur.getRecord(), cur.getCipher(), cur.getSymbol());
    }

    public QDFilter negate() {
        return new NotFilter(this);
    }

    @Override
    public QDFilter toStableFilter() {
        return ANYTHING;
    }

    public boolean isStable() {
        return this.toStableFilter() == this;
    }

    public boolean isFast() {
        return false;
    }

    public QDFilter unwrap() {
        return this;
    }

    public boolean isDynamic() {
        return false;
    }

    public Updated getUpdated() {
        return this.updated;
    }

    public QDFilter getUpdatedFilter() {
        return this.updated.filter;
    }

    public final void addUpdateListener(UpdateListener listener) {
        if (this.addUpdateListenerNoFireImpl(listener)) {
            listener.filterUpdated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addUpdateListenerNoFireImpl(UpdateListener listener) {
        if (!this.isDynamic()) {
            return false;
        }
        Updated updated = this.updated;
        synchronized (updated) {
            boolean fireImmediately;
            boolean bl = fireImmediately = this.getUpdatedFilter() != this;
            if (!fireImmediately) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                boolean wasEmpty = this.listeners.isEmpty();
                this.listeners.add(listener);
                if (wasEmpty) {
                    this.dynamicTrackingStart();
                }
            }
            return fireImmediately;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateListener(UpdateListener listener) {
        Updated updated = this.updated;
        synchronized (updated) {
            if (this.listeners != null) {
                boolean wasEmpty = this.listeners.isEmpty();
                this.listeners.remove(listener);
                if (!wasEmpty && this.listeners.isEmpty()) {
                    this.dynamicTrackingStop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFilterUpdated(QDFilter updatedFilter) {
        ArrayList<UpdateListener> fireListeners;
        Updated updated = this.updated;
        synchronized (updated) {
            if (this.updated.getFilter() != this) {
                return;
            }
            if (updatedFilter == null) {
                updatedFilter = this.produceUpdatedFilter();
            }
            if (updatedFilter == this) {
                return;
            }
            this.updated.setFilter(updatedFilter);
            fireListeners = this.listeners;
            this.listeners = null;
            if (fireListeners != null && !fireListeners.isEmpty()) {
                this.dynamicTrackingStop();
            }
        }
        if (fireListeners != null) {
            for (UpdateListener listener : fireListeners) {
                listener.filterUpdated(this);
            }
        }
    }

    @GuardedBy(value="updated")
    protected void dynamicTrackingStart() {
    }

    @GuardedBy(value="updated")
    protected void dynamicTrackingStop() {
    }

    protected QDFilter produceUpdatedFilter() {
        return this;
    }

    public static QDFilter fromFilter(SubscriptionFilter filter, DataScheme scheme) {
        if (filter instanceof QDFilter) {
            QDFilter result = (QDFilter)filter;
            if (scheme != null && result.getScheme() != null && scheme != result.getScheme()) {
                throw new IllegalArgumentException("the supplied filter has different scheme");
            }
            return result;
        }
        if (filter == null) {
            return ANYTHING;
        }
        StableSubscriptionFilter stable = filter instanceof StableSubscriptionFilter ? ((StableSubscriptionFilter)filter).toStableFilter() : null;
        return new Legacy(scheme, filter, stable);
    }

    public static void checkShortName(String name) {
        if (!QDFilter.isShortName(name)) {
            throw new IllegalArgumentException("Custom filter names can contain only lower-case English letters optionally starting with negation '!' sign");
        }
    }

    private static boolean isShortName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        int start = 0;
        if (name.startsWith("!")) {
            ++start;
        }
        for (int i = start; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static class Updated
    implements UpdateListener {
        volatile QDFilter filter;
        volatile CopyOnWriteArrayList<UpdateListener> listeners;

        Updated(QDFilter filter) {
            this.filter = filter;
        }

        synchronized void setFilter(QDFilter filter) {
            this.filter = filter;
            if (this.listeners != null && !this.listeners.isEmpty()) {
                filter.addUpdateListenerNoFireImpl(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUpdateListener(UpdateListener listener) {
            if (!this.filter.isDynamic()) {
                return;
            }
            Updated updated = this;
            synchronized (updated) {
                if (this.listeners == null) {
                    this.listeners = new CopyOnWriteArrayList();
                }
                boolean wasEmpty = this.listeners.isEmpty();
                this.listeners.add(listener);
                if (wasEmpty) {
                    this.filter.addUpdateListenerNoFireImpl(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdateListener(UpdateListener listener) {
            if (!this.filter.isDynamic()) {
                return;
            }
            Updated updated = this;
            synchronized (updated) {
                if (this.listeners == null || this.listeners.isEmpty()) {
                    return;
                }
                this.listeners.remove(listener);
                if (this.listeners.isEmpty()) {
                    this.filter.removeUpdateListener(this);
                }
            }
        }

        public QDFilter getFilter() {
            return this.filter;
        }

        @Override
        public void filterUpdated(QDFilter filter) {
            CopyOnWriteArrayList<UpdateListener> listeners = this.listeners;
            if (listeners != null) {
                for (UpdateListener listener : listeners) {
                    listener.filterUpdated(filter);
                }
            }
        }
    }

    public static interface UpdateListener {
        public void filterUpdated(QDFilter var1);
    }

    private static class Constant
    extends QDFilter {
        private final boolean accepts;

        Constant(boolean accepts) {
            super(null);
            this.accepts = accepts;
            this.setName(this.getDefaultName());
        }

        @Override
        public Kind getKind() {
            return this.accepts ? Kind.ANYTHING : Kind.NOTHING;
        }

        @Override
        public boolean isFast() {
            return true;
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            return this.accepts;
        }

        @Override
        public String getDefaultName() {
            return this.accepts ? "*" : "!*";
        }

        @Override
        public QDFilter toStableFilter() {
            return this;
        }

        @Override
        public QDFilter negate() {
            return this.accepts ? NOTHING : ANYTHING;
        }
    }

    private static class Legacy
    extends QDFilter {
        private final SubscriptionFilter filter;
        private final StableSubscriptionFilter stable;

        Legacy(DataScheme scheme, SubscriptionFilter filter, StableSubscriptionFilter stable) {
            super(scheme);
            this.filter = filter;
            this.stable = stable;
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            return this.filter.acceptRecord(record, cipher, symbol);
        }

        @Override
        public boolean isStable() {
            return this.stable == this.filter;
        }

        @Override
        public QDFilter toStableFilter() {
            return this.stable == this.filter ? this : QDFilter.fromFilter(this.stable, this.getScheme());
        }

        @Override
        public String getDefaultName() {
            return this.filter.toString();
        }
    }

    public static enum SyntaxPrecedence {
        OR,
        AND,
        TOKEN;

    }

    public static enum Kind {
        ANYTHING,
        NOTHING,
        RECORD_ONLY,
        SYMBOL_SET,
        SYMBOL_SET_WITH_ATTRIBUTES,
        PATTERN,
        OTHER_SYMBOL_ONLY,
        OTHER;


        public boolean isRecordOnly() {
            return this == RECORD_ONLY;
        }

        public boolean isSymbolOnly() {
            return this == SYMBOL_SET || this == SYMBOL_SET_WITH_ATTRIBUTES || this == PATTERN || this == OTHER_SYMBOL_ONLY;
        }
    }
}

