/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.HistorySubscriptionFilter;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.QDStream;
import com.devexperts.qd.QDTicker;
import com.devexperts.qd.impl.matrix.MatrixFactory;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.services.Services;
import com.devexperts.util.SystemProperties;

public abstract class QDFactory {
    private static String version;
    private static boolean versionShown;
    private static volatile QDFactory defaultFactory;
    private static volatile DataScheme defaultScheme;

    public abstract QDCollector.Builder<?> collectorBuilder(QDContract var1);

    public final QDCollector.Builder<QDTicker> tickerBuilder() {
        return this.collectorBuilder(QDContract.TICKER);
    }

    public final QDCollector.Builder<QDStream> streamBuilder() {
        return this.collectorBuilder(QDContract.STREAM);
    }

    public final QDCollector.Builder<QDHistory> historyBuilder() {
        return this.collectorBuilder(QDContract.HISTORY);
    }

    public final QDTicker createTicker(DataScheme scheme) {
        return this.tickerBuilder().withScheme(scheme).build();
    }

    public final QDStream createStream(DataScheme scheme) {
        return this.streamBuilder().withScheme(scheme).build();
    }

    public final QDHistory createHistory(DataScheme scheme) {
        return this.historyBuilder().withScheme(scheme).build();
    }

    public final QDTicker createTicker(DataScheme scheme, QDStats stats) {
        return this.tickerBuilder().withScheme(scheme).withStats(stats).build();
    }

    public final QDStream createStream(DataScheme scheme, QDStats stats) {
        return this.streamBuilder().withScheme(scheme).withStats(stats).build();
    }

    public final QDHistory createHistory(DataScheme scheme, QDStats stats) {
        return this.historyBuilder().withScheme(scheme).withStats(stats).build();
    }

    public final QDHistory createHistory(DataScheme scheme, QDStats stats, HistorySubscriptionFilter historyFilter) {
        return this.historyBuilder().withScheme(scheme).withStats(stats).withHistoryFilter(historyFilter).build();
    }

    public QDAgent.Builder createVoidAgentBuilder(QDContract contract, DataScheme scheme) {
        throw new UnsupportedOperationException();
    }

    public static synchronized void showVersion() {
        if (!versionShown) {
            QDLog.log.info("Using " + QDFactory.getVersion() + ", (C) Devexperts");
            versionShown = true;
        }
    }

    private static synchronized QDFactory createDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        }
        QDFactory.showVersion();
        defaultFactory = Services.createService(QDFactory.class, null, null);
        if (defaultFactory == null) {
            defaultFactory = new MatrixFactory();
        }
        return defaultFactory;
    }

    private static synchronized DataScheme createDefaultScheme() {
        if (defaultScheme != null) {
            return defaultScheme;
        }
        QDFactory.showVersion();
        defaultScheme = QDFactory.createDefaultScheme(null);
        QDLog.log.info("Using scheme " + defaultScheme.getClass().getName());
        return defaultScheme;
    }

    public static DataScheme createDefaultScheme(ClassLoader loader) {
        DataScheme scheme = Services.createService(DataScheme.class, loader, loader != null ? null : SystemProperties.getProperty("scheme", null));
        if (scheme == null) {
            throw new IllegalArgumentException("Default scheme is not found");
        }
        return scheme;
    }

    public static QDStats createStats(QDStats.SType type, DataScheme scheme) {
        QDStats stats = Services.createService(QDStats.class, null, null);
        if (stats == null) {
            return QDStats.VOID;
        }
        stats.initRoot(type, scheme);
        return stats;
    }

    public static String getVersion() {
        String version = QDFactory.version;
        if (version == null) {
            String mainVersion = QDFactory.getImplementationVersion(Package.getPackage("com.devexperts.qd"));
            StringBuilder sb = new StringBuilder("QDS-");
            sb.append(mainVersion);
            QDFactory.checkOtherPackageVersion(sb, mainVersion, "dxlib", "com.devexperts.services");
            QDFactory.checkOtherPackageVersion(sb, mainVersion, "file", "com.devexperts.qd.qds.file");
            QDFactory.checkOtherPackageVersion(sb, mainVersion, "mars", "com.devexperts.mars.common");
            QDFactory.checkOtherPackageVersion(sb, mainVersion, "monitoring", "com.devexperts.qd.monitoring");
            QDFactory.checkOtherPackageVersion(sb, mainVersion, "dxfeed", "com.dxfeed.api");
            QDFactory.checkOtherPackageVersion(sb, mainVersion, "tools", "com.devexperts.qd.tools");
            QDFactory.version = version = sb.toString();
        }
        return version;
    }

    private static void checkOtherPackageVersion(StringBuilder sb, String mainVersion, String shortName, String fqName) {
        String otherVersion;
        Package otherPackage = Package.getPackage(fqName);
        if (otherPackage != null && !(otherVersion = QDFactory.getImplementationVersion(otherPackage)).equals(mainVersion)) {
            sb.append('+').append(shortName).append('-').append(otherVersion);
        }
    }

    public static void setVersion(String version) {
        QDFactory.version = version;
    }

    private static String getImplementationVersion(Package p) {
        String version = p == null ? null : p.getImplementationVersion();
        return version == null ? "UNKNOWN" : version;
    }

    public static QDFactory getDefaultFactory() {
        return defaultFactory == null ? QDFactory.createDefaultFactory() : defaultFactory;
    }

    public static DataScheme getDefaultScheme() {
        return defaultScheme == null ? QDFactory.createDefaultScheme() : defaultScheme;
    }
}

