/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.DataProvider;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.SubscriptionProvider;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.stats.QDStatsContainer;

public interface QDErrorHandler {
    public static final QDErrorHandler DEFAULT = new QDErrorHandler(){

        @Override
        public void handleDataError(DataProvider provider, Throwable t) {
            QDLog.log.error(this.annotate(provider, "Error while processing data notification"), t);
            while (provider.retrieveData(DataVisitor.VOID)) {
            }
        }

        @Override
        public void handleSubscriptionError(SubscriptionProvider provider, Throwable t) {
            QDLog.log.error(this.annotate(provider, "Error while processing subscription notification"), t);
            while (provider.retrieveSubscription(SubscriptionVisitor.VOID)) {
            }
        }

        private String annotate(Object obj, String message) {
            if (obj instanceof QDStatsContainer) {
                message = message + " [" + ((QDStatsContainer)obj).getStats().getFullKeyProperties() + "]";
            }
            return message;
        }
    };

    public void handleDataError(DataProvider var1, Throwable var2);

    public void handleSubscriptionError(SubscriptionProvider var1, Throwable var2);
}

