/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.QDStream;
import com.devexperts.qd.QDTicker;
import com.devexperts.qd.stats.QDStats;
import java.util.Locale;

public enum QDContract implements QDCollector.Factory
{
    TICKER(QDTicker.class),
    STREAM(QDStream.class),
    HISTORY(QDHistory.class);

    private final Class<? extends QDCollector> intf;
    private final String string;

    private QDContract(Class<? extends QDCollector> intf) {
        this.intf = intf;
        StringBuilder sb = new StringBuilder(this.name().toLowerCase(Locale.US));
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        this.string = sb.toString();
    }

    public Class<? extends QDCollector> getInterface() {
        return this.intf;
    }

    @Override
    public QDContract getContract() {
        return this;
    }

    @Override
    public QDCollector createCollector(QDFactory factory, QDCollector.Builder<?> builder) {
        return factory.collectorBuilder(this).copyFrom(builder).build();
    }

    @Override
    public QDStats.SType getStatsType() {
        switch (this) {
            case TICKER: {
                return QDStats.SType.TICKER;
            }
            case STREAM: {
                return QDStats.SType.STREAM;
            }
            case HISTORY: {
                return QDStats.SType.HISTORY;
            }
        }
        throw new AssertionError((Object)"cannot happen");
    }

    public boolean hasTime() {
        return this == HISTORY;
    }

    public boolean hasSnapshotData() {
        return this != STREAM;
    }

    public boolean usesEventFlags() {
        return this == HISTORY;
    }

    public String toString() {
        return this.string;
    }
}

