/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd;

import com.devexperts.qd.DataConsumer;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataIterator;
import com.devexperts.qd.DataListener;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataProvider;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.Deprecation;
import com.devexperts.qd.util.LegacyIteratorUtils;

public class DataBuffer
implements DataConsumer,
DataProvider,
DataIterator,
DataVisitor {
    private DataListener listener;
    private DataRecord[] records = new DataRecord[16];
    private int[] ciphers = new int[this.records.length];
    private String[] symbols = new String[this.records.length];
    private int[] int_ref = new int[this.records.length];
    private int[] obj_ref = new int[this.records.length];
    private int record_mask = this.records.length - 1;
    private int record_head = 0;
    private int record_tail = 0;
    private int[] int_fields = new int[64];
    private int int_mask = this.int_fields.length - 1;
    private int int_head = 0;
    private int int_tail = 0;
    private Object[] obj_fields = new Object[16];
    private int obj_mask = this.obj_fields.length - 1;
    private int obj_head = 0;
    private int obj_tail = 0;
    private int it_cipher = 0;
    private String it_symbol = null;
    private int it_field = -1;
    private int it_int_count = 0;
    private int it_obj_count = 0;
    private int vis_field = -1;
    private int vis_int_count = 0;
    private int vis_obj_count = 0;
    public static final DataBuffer VOID;

    public static boolean process(DataIterator iterator, DataVisitor visitor) {
        return LegacyIteratorUtils.processData(iterator, visitor);
    }

    public int size() {
        return this.record_tail - this.record_head & this.record_mask;
    }

    public boolean isEmpty() {
        return this.record_tail == this.record_head;
    }

    public void clear() {
        if (this.vis_field >= 0) {
            this.vis_field = this.vis_int_count + this.vis_obj_count;
            this.completeVisit();
        }
        int i = this.record_head;
        while (i != this.record_tail) {
            this.records[i] = null;
            this.ciphers[i] = 0;
            this.symbols[i] = null;
            this.int_ref[i] = 0;
            this.obj_ref[i] = 0;
            i = i + 1 & this.record_mask;
        }
        this.record_head = 0;
        this.record_tail = 0;
        i = this.int_head;
        while (i != this.int_tail) {
            this.int_fields[i] = 0;
            i = i + 1 & this.int_mask;
        }
        this.int_head = 0;
        this.int_tail = 0;
        i = this.obj_head;
        while (i != this.obj_tail) {
            this.obj_fields[i] = null;
            i = i + 1 & this.obj_mask;
        }
        this.obj_head = 0;
        this.obj_tail = 0;
        this.it_cipher = 0;
        this.it_symbol = null;
        this.it_field = -1;
        this.it_int_count = 0;
        this.it_obj_count = 0;
        this.vis_field = -1;
        this.vis_int_count = 0;
        this.vis_obj_count = 0;
    }

    public int getCipher(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.ciphers[this.record_head + index & this.record_mask];
    }

    public String getSymbol(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.symbols[this.record_head + index & this.record_mask];
    }

    public DataRecord getRecord(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.records[this.record_head + index & this.record_mask];
    }

    public long getTime(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.records[index].hasTime()) {
            throw new IllegalArgumentException();
        }
        int ref = this.int_ref[index];
        return (long)this.int_fields[ref & this.int_mask] << 32 | (long)this.int_fields[ref + 1 & this.int_mask] & 0xFFFFFFFFL;
    }

    public int getInt(int index, int int_field_index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        index = this.record_head + index & this.record_mask;
        if (int_field_index < 0 || int_field_index >= this.records[index].getIntFieldCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.int_fields[this.int_ref[index] + int_field_index & this.int_mask];
    }

    public Object getObj(int index, int obj_field_index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        index = this.record_head + index & this.record_mask;
        if (obj_field_index < 0 || obj_field_index >= this.records[index].getObjFieldCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.obj_fields[this.obj_ref[index] + obj_field_index & this.obj_mask];
    }

    public void examineRecord(int index, DataVisitor visitor) {
        int i;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        index = this.record_head + index & this.record_mask;
        DataRecord record = this.records[index];
        int iref = this.int_ref[index];
        int oref = this.obj_ref[index];
        visitor.visitRecord(record, this.ciphers[index], this.symbols[index]);
        int n = record.getIntFieldCount();
        for (i = 0; i < n; ++i) {
            visitor.visitIntField(record.getIntField(i), this.int_fields[iref + i & this.int_mask]);
        }
        n = record.getObjFieldCount();
        for (i = 0; i < n; ++i) {
            visitor.visitObjField(record.getObjField(i), this.obj_fields[oref + i & this.obj_mask]);
        }
    }

    public boolean examineData(DataVisitor visitor) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!visitor.hasCapacity()) {
                return true;
            }
            this.examineRecord(i, visitor);
        }
        return false;
    }

    public DataProvider examiningProvider() {
        return new LocalProvider();
    }

    public DataIterator examiningIterator() {
        return this.examiningIterator(0, this.size());
    }

    public DataIterator examiningIterator(boolean reversed) {
        return reversed ? this.examiningIterator(this.size() - 1, -1) : this.examiningIterator(0, this.size());
    }

    public DataIterator examiningIterator(int index, int last_index) {
        if (index < last_index) {
            if (index < 0 || last_index > this.size()) {
                throw new IllegalArgumentException("indices are out of range (forward)");
            }
            return new LocalIterator(index, last_index, 1);
        }
        if (index > last_index) {
            if (index >= this.size() || last_index < -1) {
                throw new IllegalArgumentException("indices are out of range (reversed)");
            }
            return new LocalIterator(index, last_index, -1);
        }
        if (index > this.size() || index < -1) {
            throw new IllegalArgumentException("indices are out of range (empty)");
        }
        return VOID;
    }

    @Override
    public void processData(DataIterator iterator) {
        boolean was_empty = this.isEmpty();
        LegacyIteratorUtils.processData(iterator, this);
        if (was_empty && !this.isEmpty()) {
            this.notifyListener();
        }
    }

    @Override
    public boolean retrieveData(DataVisitor visitor) {
        return LegacyIteratorUtils.processData(this, visitor);
    }

    @Override
    public void setDataListener(DataListener listener) {
        this.listener = listener;
        if (!this.isEmpty()) {
            this.notifyListener();
        }
    }

    @Override
    public int getCipher() {
        return this.it_cipher;
    }

    @Override
    public String getSymbol() {
        return this.it_symbol;
    }

    @Override
    public DataRecord nextRecord() {
        if (this.it_field >= 0) {
            throw new IllegalStateException();
        }
        if (this.record_head == this.record_tail) {
            return null;
        }
        DataRecord record = this.records[this.record_head];
        this.it_cipher = this.ciphers[this.record_head];
        this.it_symbol = this.symbols[this.record_head];
        this.it_field = 0;
        this.it_int_count = record.getIntFieldCount();
        this.it_obj_count = record.getObjFieldCount();
        this.completeIteration();
        return record;
    }

    @Override
    public int nextIntField() {
        int i;
        if ((i = this.it_field++) < 0 || i >= this.it_int_count) {
            --this.it_field;
            throw new IllegalStateException();
        }
        int value = this.int_fields[this.int_head + i & this.int_mask];
        this.completeIteration();
        return value;
    }

    @Override
    public Object nextObjField() {
        int i;
        if ((i = this.it_field++ - this.it_int_count) < 0 || i >= this.it_obj_count) {
            --this.it_field;
            throw new IllegalStateException();
        }
        Object value = this.obj_fields[this.obj_head + i & this.obj_mask];
        this.completeIteration();
        return value;
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol) {
        if (this.vis_field >= 0) {
            throw new IllegalStateException();
        }
        this.ensureCapacity(record);
        this.records[this.record_tail] = record;
        this.ciphers[this.record_tail] = cipher;
        this.symbols[this.record_tail] = symbol;
        this.int_ref[this.record_tail] = this.int_tail;
        this.obj_ref[this.record_tail] = this.obj_tail;
        this.vis_field = 0;
        this.vis_int_count = record.getIntFieldCount();
        this.vis_obj_count = record.getObjFieldCount();
        this.completeVisit();
    }

    @Override
    public void visitIntField(DataIntField field, int value) {
        int i;
        if ((i = this.vis_field++) < 0 || i >= this.vis_int_count || field != this.records[this.record_tail].getIntField(i)) {
            --this.vis_field;
            throw new IllegalStateException();
        }
        this.int_fields[this.int_tail + i & this.int_mask] = value;
        this.completeVisit();
    }

    @Override
    public void visitObjField(DataObjField field, Object value) {
        int i;
        if ((i = this.vis_field++ - this.vis_int_count) < 0 || i >= this.vis_obj_count || field != this.records[this.record_tail].getObjField(i)) {
            --this.vis_field;
            throw new IllegalStateException();
        }
        this.obj_fields[this.obj_tail + i & this.obj_mask] = value;
        this.completeVisit();
    }

    protected void completeIteration() {
        if (this.it_field != this.it_int_count + this.it_obj_count) {
            return;
        }
        this.records[this.record_head] = null;
        this.ciphers[this.record_head] = 0;
        this.symbols[this.record_head] = null;
        this.int_ref[this.record_head] = 0;
        this.obj_ref[this.record_head] = 0;
        int i = this.it_int_count;
        while (--i >= 0) {
            this.int_fields[this.int_head + i & this.int_mask] = 0;
        }
        i = this.it_obj_count;
        while (--i >= 0) {
            this.obj_fields[this.obj_head + i & this.obj_mask] = null;
        }
        this.record_head = this.record_head + 1 & this.record_mask;
        this.int_head = this.int_head + this.it_int_count & this.int_mask;
        this.obj_head = this.obj_head + this.it_obj_count & this.obj_mask;
        this.it_field = -1;
        this.it_int_count = 0;
        this.it_obj_count = 0;
    }

    protected void completeVisit() {
        if (this.vis_field != this.vis_int_count + this.vis_obj_count) {
            return;
        }
        this.record_tail = this.record_tail + 1 & this.record_mask;
        this.int_tail = this.int_tail + this.vis_int_count & this.int_mask;
        this.obj_tail = this.obj_tail + this.vis_obj_count & this.obj_mask;
        this.vis_field = -1;
        this.vis_int_count = 0;
        this.vis_obj_count = 0;
    }

    protected void notifyListener() {
        DataListener listener = this.listener;
        if (listener != null) {
            listener.dataAvailable(this);
        }
    }

    protected void ensureCapacity(DataRecord record) {
        int i;
        int new_length;
        int length;
        int size = this.record_tail - this.record_head & this.record_mask;
        if (this.record_mask - size <= 2) {
            length = this.records.length;
            new_length = length << 1;
            this.records = new DataRecord[new_length];
            DataBuffer.copy(this.records, this.records, this.record_head, this.record_tail, length);
            this.ciphers = new int[new_length];
            DataBuffer.copy(this.ciphers, this.ciphers, this.record_head, this.record_tail, length);
            this.symbols = new String[new_length];
            DataBuffer.copy(this.symbols, this.symbols, this.record_head, this.record_tail, length);
            this.int_ref = new int[new_length];
            DataBuffer.copy(this.int_ref, this.int_ref, this.record_head, this.record_tail, length);
            this.obj_ref = new int[new_length];
            DataBuffer.copy(this.obj_ref, this.obj_ref, this.record_head, this.record_tail, length);
            this.record_mask = new_length - 1;
            this.record_head = 0;
            this.record_tail = size;
        }
        if (this.int_mask - (size = this.int_tail - this.int_head & this.int_mask) <= record.getIntFieldCount() + 1) {
            length = this.int_fields.length;
            new_length = DataBuffer.growLength(length, size + record.getIntFieldCount() + 1);
            this.int_fields = new int[new_length];
            DataBuffer.copy(this.int_fields, this.int_fields, this.int_head, this.int_tail, length);
            i = this.record_head;
            while (i != this.record_tail) {
                this.int_ref[i] = this.int_ref[i] - this.int_head & this.int_mask;
                i = i + 1 & this.record_mask;
            }
            this.int_mask = new_length - 1;
            this.int_head = 0;
            this.int_tail = size;
        }
        if (this.obj_mask - (size = this.obj_tail - this.obj_head & this.obj_mask) <= record.getObjFieldCount() + 1) {
            length = this.obj_fields.length;
            new_length = DataBuffer.growLength(length, size + record.getObjFieldCount() + 1);
            this.obj_fields = new Object[new_length];
            DataBuffer.copy(this.obj_fields, this.obj_fields, this.obj_head, this.obj_tail, length);
            i = this.record_head;
            while (i != this.record_tail) {
                this.obj_ref[i] = this.obj_ref[i] - this.obj_head & this.obj_mask;
                i = i + 1 & this.record_mask;
            }
            this.obj_mask = new_length - 1;
            this.obj_head = 0;
            this.obj_tail = size;
        }
    }

    protected static int growLength(int length, int size) {
        while ((length <<= 1) > 0 && length < size) {
        }
        if (length <= 0 || size < 0) {
            throw new OutOfMemoryError();
        }
        return length;
    }

    protected static void copy(Object src, Object dst, int head, int tail, int length) {
        if (tail < head) {
            System.arraycopy(src, head, dst, 0, length - head);
            System.arraycopy(src, 0, dst, length - head, tail);
        } else {
            System.arraycopy(src, head, dst, 0, tail - head);
        }
    }

    static {
        Deprecation.warning(DataBuffer.class);
        VOID = new VoidBuffer();
    }

    private class LocalIterator
    implements DataIterator {
        private int index;
        private final int last_index;
        private final int increment;
        private int it_cipher;
        private String it_symbol;
        private int it_field = -1;
        private int it_int_count;
        private int it_obj_count;

        public LocalIterator(int first_index, int last_index, int increment) {
            this.index = first_index;
            this.last_index = last_index;
            this.increment = increment;
        }

        @Override
        public int getCipher() {
            return this.it_cipher;
        }

        @Override
        public String getSymbol() {
            return this.it_symbol;
        }

        @Override
        public DataRecord nextRecord() {
            if (this.it_field >= 0) {
                throw new IllegalStateException();
            }
            if (this.index == this.last_index) {
                return null;
            }
            DataRecord record = DataBuffer.this.getRecord(this.index);
            this.it_cipher = DataBuffer.this.getCipher(this.index);
            this.it_symbol = DataBuffer.this.getSymbol(this.index);
            this.it_field = 0;
            this.it_int_count = record.getIntFieldCount();
            this.it_obj_count = record.getObjFieldCount();
            this.completeIteration();
            return record;
        }

        @Override
        public int nextIntField() {
            int i;
            if ((i = this.it_field++) < 0 || i >= this.it_int_count) {
                --this.it_field;
                throw new IllegalStateException();
            }
            int value = DataBuffer.this.getInt(this.index, i);
            this.completeIteration();
            return value;
        }

        @Override
        public Object nextObjField() {
            int i;
            if ((i = this.it_field++ - this.it_int_count) < 0 || i >= this.it_obj_count) {
                --this.it_field;
                throw new IllegalStateException();
            }
            Object value = DataBuffer.this.getObj(this.index, i);
            this.completeIteration();
            return value;
        }

        private void completeIteration() {
            if (this.it_field != this.it_int_count + this.it_obj_count) {
                return;
            }
            this.index += this.increment;
            this.it_field = -1;
            this.it_int_count = 0;
            this.it_obj_count = 0;
        }
    }

    private class LocalProvider
    implements DataProvider {
        private final DataIterator it;

        LocalProvider() {
            this.it = DataBuffer.this.examiningIterator();
        }

        @Override
        public boolean retrieveData(DataVisitor visitor) {
            return LegacyIteratorUtils.processData(this.it, visitor);
        }

        @Override
        public void setDataListener(DataListener listener) {
        }
    }

    private static class VoidBuffer
    extends DataBuffer
    implements DataListener {
        VoidBuffer() {
        }

        @Override
        public DataIterator examiningIterator() {
            return this;
        }

        @Override
        public void setDataListener(DataListener listener) {
        }

        @Override
        public void visitRecord(DataRecord record, int cipher, String symbol) {
        }

        @Override
        public void visitIntField(DataIntField field, int value) {
        }

        @Override
        public void visitObjField(DataObjField field, Object value) {
        }

        @Override
        public void dataAvailable(DataProvider provider) {
            provider.retrieveData(this);
        }
    }
}

