/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.proto;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class JVMId
implements Comparable<JVMId> {
    private static final int UID_SIZE = 16;
    private static final int TEXT_LENGTH = SystemProperties.getIntProperty(JVMId.class, "textLength", 5);
    private static final int MAX_JVM_ID_BYTES = SystemProperties.getIntProperty(JVMId.class, "maxJVMIdBytes", 100);
    private static final char[] CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final JVMId JVM_ID = new JVMId();
    private final byte[] uid;
    private String text;

    public static JVMId readJvmId(BufferedInput in, ReadContext ctx) throws IOException {
        if (ctx == null) {
            byte[] uid = in.readByteArray();
            return uid == null ? null : new JVMId(uid);
        }
        long length = in.readCompactLong();
        if (length == 0L || length > (long)MAX_JVM_ID_BYTES) {
            throw new IOException("Illegal JVMId length: " + length);
        }
        if (length == -1L) {
            return null;
        }
        if (length < -1L) {
            return ctx.getJVMId(length);
        }
        byte[] uid = new byte[(int)length];
        in.readFully(uid);
        JVMId jvmId = new JVMId(uid);
        ctx.addJVMId(jvmId);
        return jvmId;
    }

    public static void writeJvmId(BufferedOutput out, JVMId jvmId, WriteContext ctx) throws IOException {
        if (ctx == null) {
            out.writeByteArray(jvmId == null ? null : jvmId.uid);
            return;
        }
        int length = ctx.getIndex(jvmId);
        out.writeCompactInt(length);
        if (length > 0) {
            out.write(jvmId.uid);
        }
    }

    private JVMId() {
        this.uid = new byte[16];
        ByteBuffer buf = ByteBuffer.wrap(this.uid);
        UUID uuid = UUID.randomUUID();
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
    }

    protected JVMId(byte[] uid) {
        if (uid == null) {
            throw new NullPointerException();
        }
        this.uid = uid;
    }

    private String createText() {
        int i;
        char[] result = new char[TEXT_LENGTH];
        int temp = 0;
        for (i = Math.max(0, this.uid.length - 4); i < this.uid.length; ++i) {
            temp = temp << 8 | this.uid[i] & 0xFF;
        }
        for (i = TEXT_LENGTH - 1; i >= 0; --i) {
            result[i] = CHARS[Math.abs(temp % CHARS.length)];
            temp /= CHARS.length;
        }
        return new String(result);
    }

    public byte[] getUID() {
        return this.uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JVMId)) {
            return false;
        }
        JVMId other = (JVMId)o;
        return Arrays.equals(this.uid, other.uid);
    }

    public int hashCode() {
        int result = 0;
        for (byte b : this.uid) {
            result = result * 27 + b;
        }
        return result;
    }

    public String toString() {
        if (this.text != null) {
            return this.text;
        }
        this.text = this.createText();
        return this.text;
    }

    @Override
    public int compareTo(JVMId other) {
        return JVMId.arrayCompare(this.uid, other.uid);
    }

    public static int arrayCompare(byte[] a1, byte[] a2) {
        int n = Math.min(a1.length, a2.length);
        for (int i = 0; i < n; ++i) {
            if (a1[i] < a2[i]) {
                return -1;
            }
            if (a1[i] <= a2[i]) continue;
            return 1;
        }
        if (a1.length < a2.length) {
            return -1;
        }
        if (a1.length > a2.length) {
            return 1;
        }
        return 0;
    }

    public static class ReadContext {
        private List<JVMId> jvmIds = new ArrayList<JVMId>();

        JVMId getJVMId(long index) throws IOException {
            if (index > -2L || index <= (long)(-this.jvmIds.size() - 2)) {
                throw new IOException("Invalid JVMId reference: " + index);
            }
            return this.jvmIds.get((int)(-index - 2L));
        }

        void addJVMId(JVMId jvmId) {
            this.jvmIds.add(jvmId);
        }
    }

    public static class WriteContext {
        private final Map<JVMId, Integer> jvmIdMap = new HashMap<JVMId, Integer>();

        int getIndex(JVMId jvmId) {
            if (jvmId == null) {
                return -1;
            }
            if (this.jvmIdMap.containsKey(jvmId)) {
                return this.jvmIdMap.get(jvmId);
            }
            int index = -this.jvmIdMap.size() - 2;
            this.jvmIdMap.put(jvmId, index);
            return jvmId.getUID().length;
        }
    }
}

