/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.proto;

import com.devexperts.connector.proto.JVMId;
import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.io.Serializable;

public class EndpointId
implements Comparable<EndpointId>,
Serializable {
    private static final int COUNTER_MODULO = SystemProperties.getIntProperty(EndpointId.class, "counterModulo", 64);
    private static final long[] ENDPOINT_COUNTER;
    private static final long serialVersionUID = -3853750500070074505L;
    private final JVMId jvmId;
    private String name;
    private final long id;

    public static synchronized EndpointId newEndpointId(String name) {
        int i;
        int n = i = name.hashCode() & COUNTER_MODULO - 1;
        long l = ENDPOINT_COUNTER[n];
        ENDPOINT_COUNTER[n] = l + 1L;
        return new EndpointId(JVMId.JVM_ID, name, l);
    }

    public static EndpointId readEndpointId(BufferedInput in, JVMId.ReadContext ctx) throws IOException {
        JVMId jvmId = JVMId.readJvmId(in, ctx);
        if (jvmId == null) {
            return null;
        }
        String name = in.readUTFString();
        long id = in.readCompactLong();
        return new EndpointId(jvmId, name, id);
    }

    public static void writeEndpointId(BufferedOutput out, EndpointId endpointId, JVMId.WriteContext ctx) throws IOException {
        if (endpointId == null) {
            out.writeByteArray(null);
            return;
        }
        JVMId.writeJvmId(out, endpointId.jvmId, ctx);
        out.writeUTFString(endpointId.name);
        out.writeCompactLong(endpointId.id);
    }

    private EndpointId(JVMId jvmId, String name, long id) {
        this.jvmId = jvmId;
        this.name = name;
        this.id = id;
    }

    public JVMId getJVMId() {
        return this.jvmId;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public int compareTo(EndpointId other) {
        int i = this.jvmId.compareTo(other.jvmId);
        if (i != 0) {
            return i;
        }
        i = this.name.compareTo(other.name);
        if (i != 0) {
            return i;
        }
        return this.id < other.id ? -1 : (this.id > other.id ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointId)) {
            return false;
        }
        EndpointId other = (EndpointId)o;
        return this.jvmId.equals(other.jvmId) && this.name.equals(other.name) && this.id == other.id;
    }

    public int hashCode() {
        return (this.jvmId.hashCode() * 27 + this.name.hashCode()) * 27 + ((int)this.id ^ (int)(this.id >> 32));
    }

    public String toString() {
        return this.name + "@" + (this.id == 0L ? this.jvmId.toString() : this.jvmId + "." + this.id);
    }

    static {
        if (COUNTER_MODULO <= 0 || (COUNTER_MODULO & COUNTER_MODULO - 1) != 0) {
            throw new ExceptionInInitializerError("counterModule must be a power of 2");
        }
        ENDPOINT_COUNTER = new long[COUNTER_MODULO];
    }
}

