/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.proto;

import java.util.Locale;

public class ConfigurationKey<T> {
    private final String name;
    private final String lowerCaseName;
    private final Class<T> type;
    private final String description;

    public static <T> ConfigurationKey<T> create(String name, Class<T> type) {
        return new ConfigurationKey<T>(name, type, "");
    }

    public static <T> ConfigurationKey<T> create(String name, Class<T> type, String description) {
        return new ConfigurationKey<T>(name, type, description);
    }

    protected ConfigurationKey(String name, Class<T> type, String description) {
        if (name == null || type == null || description == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.lowerCaseName = name.toLowerCase(Locale.US);
        this.type = type;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        return o instanceof ConfigurationKey && this.lowerCaseName.equals(((ConfigurationKey)o).lowerCaseName);
    }

    public int hashCode() {
        return this.lowerCaseName.hashCode();
    }

    public String toString() {
        return this.name + ":" + this.type.getName();
    }
}

