/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.proto;

import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.ConfigurationException;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.util.ConfigUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ConfigurableObject
implements Cloneable {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private Map<ConfigurationKey<?>, IntrospectedKey<?>> introspectedConfiguration;

    public ConfigurableObject clone() {
        try {
            return (ConfigurableObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Set<ConfigurationKey<?>> supportedConfiguration() {
        return this.introspectConfiguration().keySet();
    }

    public <T> T getConfiguration(ConfigurationKey<T> key) {
        Object result;
        IntrospectedKey<?> introspectedKey = this.introspectConfiguration().get(key);
        if (introspectedKey == null) {
            return null;
        }
        try {
            result = introspectedKey.getter.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Getter is not accessible for '" + introspectedKey + "' in " + this.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(introspectedKey, e.getCause());
        }
        if (key.getType() == introspectedKey.getter.getReturnType()) {
            return (T)result;
        }
        if (key.getType() == String.class) {
            return (T)String.valueOf(result);
        }
        throw new IllegalArgumentException("Cannot coerce type of '" + introspectedKey + "' to '" + key + "' to get value");
    }

    public <T> boolean setConfiguration(ConfigurationKey<T> key, T value) throws ConfigurationException {
        Object resolvedValue;
        if (value != null && !key.getType().isInstance(value)) {
            throw new IllegalArgumentException("Invalid value class " + value.getClass().getName() + " for '" + key + "'");
        }
        IntrospectedKey<?> introspectedKey = this.introspectConfiguration().get(key);
        if (introspectedKey == null) {
            return false;
        }
        if (key.getType() == introspectedKey.getType()) {
            resolvedValue = value;
        } else if (key.getType() == String.class) {
            resolvedValue = ConfigUtil.convertStringToObject(introspectedKey.getType(), (String)value);
        } else {
            throw new IllegalArgumentException("Cannot coerce type of '" + key + "' to '" + introspectedKey + "' to set value");
        }
        try {
            introspectedKey.setter.invoke((Object)this, resolvedValue);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Setter is not accessible for '" + introspectedKey + "' in " + this.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(introspectedKey, e.getCause());
        }
        return true;
    }

    public void reinitConfiguration() {
    }

    private void ensureAccessible(Method method) {
        if (Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return;
        }
        if (method.isAccessible()) {
            return;
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private synchronized Map<ConfigurationKey<?>, IntrospectedKey<?>> introspectConfiguration() {
        if (this.introspectedConfiguration != null) {
            return this.introspectedConfiguration;
        }
        this.introspectedConfiguration = new LinkedHashMap();
        for (Method setter : this.getClass().getMethods()) {
            Method getter;
            Configurable configurable = setter.getAnnotation(Configurable.class);
            if (configurable == null) continue;
            String setterName = setter.getName();
            if (!Modifier.isPublic(setter.getModifiers())) {
                throw new IllegalArgumentException("@Configurable setter '" + setterName + "' method is not public");
            }
            if (!setterName.startsWith(SET_PREFIX) || setterName.length() <= SET_PREFIX.length() || !Character.isUpperCase(setterName.charAt(SET_PREFIX.length()))) {
                throw new IllegalArgumentException("@Configurable setter '" + setterName + "' method has invalid name");
            }
            if (setter.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("@Configurable setter '" + setterName + "' method has invalid return type");
            }
            Class<?>[] parameterTypes = setter.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalArgumentException("@Configurable setter '" + setterName + "' method has wrong number of parameters");
            }
            try {
                getter = this.getClass().getMethod(GET_PREFIX + setterName.substring(SET_PREFIX.length()), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getter = this.getClass().getMethod(IS_PREFIX + setterName.substring(SET_PREFIX.length()), new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw new IllegalArgumentException("@Configurable setter '" + setterName + "' has no matching getter");
                }
            }
            if (!Modifier.isPublic(getter.getModifiers())) {
                throw new IllegalArgumentException("@Configurable setter '" + setterName + "' has non-public getter");
            }
            String name = !configurable.name().isEmpty() ? configurable.name() : Character.toLowerCase(setterName.charAt(SET_PREFIX.length())) + setterName.substring(SET_PREFIX.length() + 1);
            this.ensureAccessible(getter);
            this.ensureAccessible(setter);
            IntrospectedKey introspectedKey = new IntrospectedKey(name, parameterTypes[0], configurable.description(), getter, setter);
            this.introspectedConfiguration.put(introspectedKey, introspectedKey);
        }
        return this.introspectedConfiguration;
    }

    static class IntrospectedKey<T>
    extends ConfigurationKey<T> {
        final Method getter;
        final Method setter;

        IntrospectedKey(String name, Class type, String description, Method getter, Method setter) {
            super(name, type, description);
            this.getter = getter;
            this.setter = setter;
        }
    }
}

