/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.proto;

import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.ConfigurableObject;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.io.ChunkPool;
import com.devexperts.logging.Logging;
import java.io.IOException;

public abstract class ApplicationConnectionFactory
extends ConfigurableObject {
    public static final ConfigurationKey<String> NAME = ConfigurationKey.create("name", String.class);
    public static final ConfigurationKey<ChunkPool> CHUNK_POOL_CONFIGURATION_KEY = ConfigurationKey.create("chunkPool", ChunkPool.class);
    protected Logging log;
    private String name;
    private ChunkPool chunkPool = ChunkPool.DEFAULT;

    protected ApplicationConnectionFactory() {
        this(null);
    }

    protected ApplicationConnectionFactory(String name) {
        this.name = name;
        this.log = ApplicationConnectionFactory.getLoggingInternal(name == null ? this.getDefaultName() : name);
    }

    private String getDefaultName() {
        String suffix;
        String type = this.getClass().getSimpleName().replace('$', '-');
        if (type.endsWith(suffix = "ConnectionFactory")) {
            type = type.substring(0, type.length() - suffix.length());
        }
        return type;
    }

    public abstract ApplicationConnection<?> createConnection(TransportConnection var1) throws IOException;

    public String getName() {
        return this.name;
    }

    @Configurable(description="name of this connection")
    public void setName(String name) {
        this.name = name;
        this.log = ApplicationConnectionFactory.getLoggingInternal(name);
    }

    public ChunkPool getChunkPool() {
        return this.chunkPool;
    }

    @Configurable(description="Chunk pool")
    public void setChunkPool(ChunkPool chunkPool) {
        this.chunkPool = chunkPool;
    }

    @Override
    public ApplicationConnectionFactory clone() {
        return (ApplicationConnectionFactory)super.clone();
    }

    public abstract String toString();

    private static Logging getLoggingInternal(String name) {
        return Logging.getLogging(ApplicationConnectionFactory.class.getName() + "." + name);
    }
}

