/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.proto;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.io.ChunkList;
import com.devexperts.logging.Logging;

public abstract class ApplicationConnection<F extends ApplicationConnectionFactory> {
    private static final int STATE_NEW = 0;
    private static final int STATE_WORKING = 1;
    private static final int STATE_CLOSED = 2;
    protected final Logging log = Logging.getLogging(this.getClass());
    protected final F factory;
    protected final TransportConnection transportConnection;
    private volatile int state;

    protected ApplicationConnection(F factory, TransportConnection transportConnection) {
        this.factory = ((ApplicationConnectionFactory)factory).clone();
        this.transportConnection = transportConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        if (this.state != 0) {
            return;
        }
        ApplicationConnection applicationConnection = this;
        synchronized (applicationConnection) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
        }
        this.startImpl();
    }

    public abstract ChunkList retrieveChunks(Object var1);

    public abstract boolean processChunks(ChunkList var1, Object var2);

    public long examine(long currentTime) {
        return Long.MAX_VALUE;
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.state == 2) {
            return;
        }
        ApplicationConnection applicationConnection = this;
        synchronized (applicationConnection) {
            if (this.state == 2) {
                return;
            }
            this.state = 2;
        }
        try {
            this.closeImpl();
        }
        finally {
            this.notifyClosed();
        }
    }

    public void markForImmediateRestart() {
        this.transportConnection.markForImmediateRestart();
    }

    protected void startImpl() {
    }

    protected void closeImpl() {
    }

    protected void notifyClosed() {
        if (this.state != 2) {
            return;
        }
        try {
            this.transportConnection.connectionClosed();
        }
        catch (Throwable t) {
            this.log.error("Unexpected error while notifying transport connection", t);
        }
    }

    protected void notifyChunksAvailable() {
        if (this.state != 1) {
            return;
        }
        try {
            this.transportConnection.chunksAvailable();
        }
        catch (Throwable t) {
            this.log.error("Unexpected error while notifying transport connection", t);
            this.close();
        }
    }

    protected void notifyReadyToProcess() {
        if (this.state != 1) {
            return;
        }
        try {
            this.transportConnection.readyToProcessChunks();
        }
        catch (Throwable t) {
            this.log.error("Unexpected error while notifying transport connection", t);
            this.close();
        }
    }
}

