/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.codec.ssl;

import com.devexperts.connector.codec.CodecConnectionFactory;
import com.devexperts.connector.codec.ssl.SSLConnection;
import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.util.ExecutorProvider;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLConnectionFactory
extends CodecConnectionFactory {
    private static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = SSLConnectionFactory.createExecutorProvider(SystemProperties.getIntProperty("com.devexperts.qd.qtp.ssl.executorThreadsNumber", Runtime.getRuntime().availableProcessors()));
    private final SSLContext context;
    private String keyStore = SystemProperties.getProperty("javax.net.ssl.keyStore", null);
    private String keyStorePassword = SystemProperties.getProperty("javax.net.ssl.keyStorePassword", null);
    private String keyStoreProvider = SystemProperties.getProperty("javax.net.ssl.keyStoreProvider", null);
    private String keyStoreType = SystemProperties.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
    private String trustStore = SystemProperties.getProperty("javax.net.ssl.trustStore", null);
    private String trustStorePassword = SystemProperties.getProperty("javax.net.ssl.trustStorePassword", null);
    private String trustStoreProvider = SystemProperties.getProperty("javax.net.ssl.trustStoreProvider", null);
    private String trustStoreType = SystemProperties.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    private String protocols = SystemProperties.getProperty("com.devexperts.connector.codec.ssl.protocols", null);
    private String cipherSuites = SystemProperties.getProperty("com.devexperts.connector.codec.ssl.cipherSuites", null);
    private TrustManager trustManager;
    private String[] protocolsArr;
    private String[] cipherSuitesArr;
    private boolean isServer = false;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private int taskThreads;
    private Executor taskExecutor;
    private ExecutorProvider taskExecutorProvider;
    private volatile boolean isInitialized;

    @Nonnull
    private static ExecutorProvider createExecutorProvider(int nThreads) {
        return new ExecutorProvider(nThreads, "SSLTasksExecutor", Logging.getLogging(SSLConnection.class));
    }

    SSLConnectionFactory(ApplicationConnectionFactory delegate) {
        super(delegate);
        try {
            this.context = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    @Configurable
    public void setKeyStore(String keyStore) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Configurable
    public void setKeyStorePassword(String keyStorePassword) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    @Configurable
    public void setKeyStoreProvider(String keyStoreProvider) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Configurable
    public void setKeyStoreType(String keyStoreType) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    @Configurable
    public void setTrustStore(String trustStore) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Configurable
    public void setTrustStorePassword(String trustStorePassword) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    @Configurable
    public void setTrustStoreProvider(String trustStoreProvider) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.trustStoreProvider = trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Configurable
    public void setTrustStoreType(String trustStoreType) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.trustStoreType = trustStoreType;
    }

    public boolean isServer() {
        return this.isServer;
    }

    @Configurable(name="isServer")
    public void setServer(boolean server) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.isServer = server;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    @Configurable
    public void setNeedClientAuth(boolean needClientAuth) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    @Configurable
    public void setWantClientAuth(boolean wantClientAuth) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.wantClientAuth = wantClientAuth;
    }

    public int getTaskThreads() {
        return this.taskThreads;
    }

    @Configurable
    public void setTaskThreads(int taskThreads) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.taskThreads = taskThreads;
    }

    public Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Configurable
    public void setTaskExecutor(Executor taskExecutor) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.taskExecutor = taskExecutor;
    }

    public String getProtocols() {
        return this.protocols;
    }

    @Configurable
    public void setProtocols(String protocols) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.protocols = protocols;
    }

    public String getCipherSuites() {
        return this.cipherSuites;
    }

    @Configurable
    public void setCipherSuites(String cipherSuites) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.cipherSuites = cipherSuites;
    }

    @Override
    public void setTrustManager(TrustManager trustManager) {
        if (this.isInitialized) {
            throw new IllegalStateException("Factory has already been initialized.");
        }
        this.trustManager = trustManager;
    }

    private ExecutorProvider getExecutorProvider() {
        if (this.taskExecutorProvider != null) {
            return this.taskExecutorProvider;
        }
        if (this.taskExecutor != null) {
            this.taskExecutorProvider = new ExecutorProvider(this.taskExecutor);
            return this.taskExecutorProvider;
        }
        if (this.taskThreads > 0) {
            this.taskExecutorProvider = SSLConnectionFactory.createExecutorProvider(this.taskThreads);
            return this.taskExecutorProvider;
        }
        return DEFAULT_EXECUTOR_PROVIDER;
    }

    private void init() throws GeneralSecurityException, IOException {
        KeyManagerFactory keyManagerFactory = null;
        if (this.keyStore != null) {
            KeyStore keyStore = SSLConnectionFactory.getKeyStore(this.keyStoreType, this.keyStoreProvider, this.keyStore, this.keyStorePassword);
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
        }
        TrustManager[] trustManagers = null;
        if (this.trustManager != null) {
            trustManagers = new TrustManager[]{this.trustManager};
        } else if (this.trustStore != null) {
            KeyStore trustStore = SSLConnectionFactory.getKeyStore(this.trustStoreType, this.trustStoreProvider, this.trustStore, this.trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        this.context.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagers, null);
        SSLEngine engine = this.context.createSSLEngine();
        if (this.protocols != null) {
            this.protocolsArr = this.protocols.trim().split(";");
            try {
                engine.setEnabledProtocols(this.protocolsArr);
            }
            catch (IllegalArgumentException e) {
                this.log.error(e.getMessage() + " protocols are not supported. Available protocols: " + Arrays.toString(engine.getSupportedProtocols()));
                throw new GeneralSecurityException(e);
            }
        }
        if (this.cipherSuites != null) {
            this.cipherSuitesArr = this.cipherSuites.trim().split(";");
            try {
                engine.setEnabledCipherSuites(this.cipherSuitesArr);
            }
            catch (IllegalArgumentException e) {
                this.log.error(e.getMessage() + " cipher suites are not supported. Available cipher suites: " + Arrays.toString(engine.getSupportedCipherSuites()));
                throw new GeneralSecurityException(e);
            }
        }
        this.isInitialized = true;
    }

    private static KeyStore getKeyStore(String type, String provider, String url, String password) throws GeneralSecurityException, IOException {
        assert (url != null);
        KeyStore result = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        try (URLInputStream in = new URLInputStream(url);){
            result.load(in, password == null ? null : password.toCharArray());
        }
        return result;
    }

    @Override
    public ApplicationConnection<?> createConnection(TransportConnection transportConnection) throws IOException {
        if (!this.isInitialized) {
            try {
                this.init();
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Failed to initialize ssl engine: " + e.getMessage());
            }
        }
        SSLEngine engine = this.context.createSSLEngine();
        if (this.protocolsArr != null) {
            engine.setEnabledProtocols(this.protocolsArr);
        }
        if (this.cipherSuitesArr != null) {
            engine.setEnabledCipherSuites(this.cipherSuitesArr);
        }
        engine.setUseClientMode(!this.isServer);
        if (this.isServer) {
            if (this.needClientAuth) {
                engine.setWantClientAuth(this.wantClientAuth);
                engine.setNeedClientAuth(true);
            } else {
                engine.setNeedClientAuth(false);
                engine.setWantClientAuth(this.wantClientAuth);
            }
        }
        return new SSLConnection(this.getDelegate(), this, transportConnection, engine, this.getExecutorProvider().newReference());
    }

    @Override
    public String toString() {
        return "ssl+" + this.getDelegate().toString();
    }
}

