/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.codec.ssl;

import com.devexperts.connector.codec.CodecConnection;
import com.devexperts.connector.codec.ssl.SSLConnectionFactory;
import com.devexperts.connector.codec.ssl.SSLEngineAdapter;
import com.devexperts.connector.codec.ssl.SSLEngineSynchronizedAdapter;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkedInput;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.util.ExecutorProvider;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

class SSLConnection
extends CodecConnection<SSLConnectionFactory> {
    private static final String SYNC_SSL_ENGINE_PROPERTY = "com.devexperts.connector.codec.ssl.synchronizeSSLEngine";
    private static final ThreadLocal<ByteBuffer> inAppBuffer = new ThreadLocal();
    private static final ThreadLocal<ByteBuffer> inNetBuffer = new ThreadLocal();
    private static final ThreadLocal<ByteBuffer> outAppBuffer = new ThreadLocal();
    private static final ThreadLocal<ByteBuffer> outNetBuffer = new ThreadLocal();
    private final SSLEngineAdapter engine;
    private final ExecutorProvider.Reference executorReference;
    private final ChunkedInput inNetChunkedInput;
    private final ChunkedInput outAppChunkedInput;
    private final ChunkedOutput inAppChunkedOutput;
    private final ChunkedOutput outNetChunkedOutput;
    private volatile boolean delegateHasChunks = true;
    private volatile boolean delegateReadyToProcess = true;
    private volatile boolean isExecutingTask = false;
    private volatile boolean hasUnsentChunks = false;
    private final ArrayBlockingQueue<ChunkList> chunkListsToProcess = new ArrayBlockingQueue(4);
    private final AtomicBoolean isProcessing = new AtomicBoolean();

    SSLConnection(ApplicationConnectionFactory delegateFactory, SSLConnectionFactory factory, TransportConnection transportConnection, SSLEngine engine, ExecutorProvider.Reference executorReference) throws IOException {
        super(delegateFactory, factory, transportConnection);
        boolean syncEngine = SystemProperties.getBooleanProperty(SYNC_SSL_ENGINE_PROPERTY, true);
        this.engine = syncEngine ? new SSLEngineSynchronizedAdapter(engine) : new SSLEngineAdapter(engine);
        this.executorReference = executorReference;
        this.inNetChunkedInput = new ChunkedInput(factory.getChunkPool());
        this.outAppChunkedInput = new ChunkedInput(factory.getChunkPool());
        this.inAppChunkedOutput = new ChunkedOutput(factory.getChunkPool());
        this.outNetChunkedOutput = new ChunkedOutput(factory.getChunkPool());
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        this.notifyChunksAvailable();
    }

    @Override
    protected void closeImpl() {
        super.closeImpl();
        this.executorReference.close();
    }

    @Override
    public void chunksAvailable() {
        this.delegateHasChunks = true;
        super.chunksAvailable();
    }

    @Override
    public void readyToProcessChunks() {
        this.delegateReadyToProcess = true;
        if (!this.isExecutingTask) {
            super.readyToProcessChunks();
        }
    }

    private ByteBuffer getBuffer(ThreadLocal<ByteBuffer> threadLocal, boolean isAppBuffer) {
        int capacity;
        ByteBuffer buffer = threadLocal.get();
        SSLSession session = this.engine.getSession();
        int n = capacity = isAppBuffer ? session.getApplicationBufferSize() : session.getPacketBufferSize();
        if (buffer == null || buffer.capacity() < capacity) {
            buffer = ByteBuffer.allocateDirect(capacity);
            threadLocal.set(buffer);
        }
        buffer.clear();
        return buffer;
    }

    private void executeEngineTasks() {
        Runnable task = this.engine.getDelegatedTask();
        if (task == null) {
            return;
        }
        this.isExecutingTask = true;
        this.executorReference.getOrCreateExecutor().execute(() -> {
            task.run();
            this.isExecutingTask = false;
            this.initiateNextOperation();
        });
    }

    private void initiateNextOperation() {
        switch (this.engine.getHandshakeStatus()) {
            case NEED_WRAP: {
                this.notifyChunksAvailable();
                break;
            }
            case NEED_UNWRAP: {
                if (!this.processChunks(ChunkList.EMPTY, null)) break;
                this.notifyReadyToProcess();
                break;
            }
            case NEED_TASK: {
                this.executeEngineTasks();
                break;
            }
            case FINISHED: 
            case NOT_HANDSHAKING: {
                if (this.delegateReadyToProcess && !this.isExecutingTask) {
                    this.notifyReadyToProcess();
                }
                if (!this.delegateHasChunks && !this.hasUnsentChunks) break;
                this.notifyChunksAvailable();
            }
        }
    }

    @Override
    public ChunkList retrieveChunks(Object owner) {
        if (!this.outAppChunkedInput.hasAvailable() && this.delegateHasChunks) {
            this.delegateHasChunks = false;
            try {
                ChunkList chunks = this.delegate.retrieveChunks(this);
                if (chunks != null) {
                    this.outAppChunkedInput.addAllToInput(chunks, this);
                }
            }
            catch (Throwable t) {
                this.log.error("Unexpected error", t);
                this.close();
                return null;
            }
        }
        return this.wrap(owner);
    }

    /*
     * Unable to fully structure code
     */
    private ChunkList wrap(Object owner) {
        outAppBuffer = this.getBuffer(SSLConnection.outAppBuffer, true);
        outNetBuffer = this.getBuffer(SSLConnection.outNetBuffer, false);
        outAppBuffer.flip();
        this.outAppChunkedInput.mark();
        block14: while (true) {
            outAppBuffer.compact();
            try {
                this.outAppChunkedInput.readToByteBuffer(outAppBuffer);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            outAppBuffer.flip();
            try {
                result = this.engine.wrap(outAppBuffer, outNetBuffer);
            }
            catch (SSLException e) {
                this.log.error("Failed to wrap", e);
                this.outNetChunkedOutput.clear();
                this.close();
                return null;
            }
            outNetBuffer.flip();
            try {
                this.outNetChunkedOutput.writeFromByteBuffer(outNetBuffer);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            outNetBuffer.clear();
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[result.getStatus().ordinal()]) {
                case 1: {
                    this.outNetChunkedOutput.clear();
                    this.close();
                    return null;
                }
                case 2: {
                    outNetBuffer = this.getBuffer(SSLConnection.outNetBuffer, false);
                    continue block14;
                }
            }
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[result.getHandshakeStatus().ordinal()]) {
                case 1: {
                    continue block14;
                }
                case 4: 
                case 5: {
                    if (!this.outAppChunkedInput.hasAvailable() && outAppBuffer.remaining() == 0) ** break;
                    continue block14;
                    break block14;
                }
            }
            break;
        }
        this.outAppChunkedInput.rewind(outAppBuffer.remaining());
        this.outAppChunkedInput.unmark();
        this.hasUnsentChunks = this.outAppChunkedInput.hasAvailable();
        this.initiateNextOperation();
        return this.outNetChunkedOutput.getOutput(owner);
    }

    @Override
    public boolean processChunks(ChunkList newChunks, Object owner) {
        if (newChunks == null) {
            throw new NullPointerException("chunks is null");
        }
        if (newChunks == ChunkList.EMPTY && !this.chunkListsToProcess.isEmpty()) {
            return false;
        }
        newChunks.handOver(owner, this);
        try {
            this.chunkListsToProcess.put(newChunks);
        }
        catch (InterruptedException e) {
            this.close();
            return false;
        }
        if (!this.isProcessing.compareAndSet(false, true)) {
            return false;
        }
        boolean newChunksAppeared = true;
        while (!this.isClosed()) {
            block9: {
                while (true) {
                    ChunkList chunks;
                    if ((chunks = this.chunkListsToProcess.poll()) != null) {
                        newChunksAppeared = true;
                        this.inNetChunkedInput.addAllToInput(chunks, this);
                        continue;
                    }
                    if (newChunksAppeared) break block9;
                    this.isProcessing.set(false);
                    if (this.chunkListsToProcess.isEmpty()) {
                        return this.delegateReadyToProcess && !this.isExecutingTask;
                    }
                    if (!this.isProcessing.compareAndSet(false, true)) break;
                }
                return false;
            }
            newChunksAppeared = false;
            ChunkList inAppChunks = this.unwrap();
            if (inAppChunks == null) continue;
            this.delegateReadyToProcess = false;
            if (!this.delegate.processChunks(inAppChunks, this)) continue;
            this.delegateReadyToProcess = true;
        }
        return false;
    }

    private ChunkList unwrap() {
        ByteBuffer inNetBuffer = this.getBuffer(SSLConnection.inNetBuffer, false);
        ByteBuffer inAppBuffer = this.getBuffer(SSLConnection.inAppBuffer, true);
        inNetBuffer.flip();
        this.inNetChunkedInput.mark();
        block18: while (true) {
            SSLEngineResult result;
            inNetBuffer.compact();
            try {
                this.inNetChunkedInput.readToByteBuffer(inNetBuffer);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            inNetBuffer.flip();
            try {
                result = this.engine.unwrap(inNetBuffer, inAppBuffer);
            }
            catch (SSLException e) {
                this.log.error("Failed to unwrap", e);
                this.close();
                this.inAppChunkedOutput.clear();
                return null;
            }
            inAppBuffer.flip();
            try {
                this.inAppChunkedOutput.writeFromByteBuffer(inAppBuffer);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            inAppBuffer.clear();
            switch (result.getStatus()) {
                case CLOSED: {
                    this.inAppChunkedOutput.clear();
                    this.close();
                    return null;
                }
                case BUFFER_OVERFLOW: {
                    inAppBuffer = this.getBuffer(SSLConnection.inAppBuffer, true);
                    continue block18;
                }
                case BUFFER_UNDERFLOW: {
                    break block18;
                }
                default: {
                    switch (result.getHandshakeStatus()) {
                        case NEED_WRAP: {
                            this.notifyChunksAvailable();
                            break block18;
                        }
                        case NEED_TASK: {
                            this.executeEngineTasks();
                            break block18;
                        }
                    }
                    continue block18;
                }
            }
            break;
        }
        this.inNetChunkedInput.rewind(inNetBuffer.remaining());
        this.inNetChunkedInput.unmark();
        switch (this.engine.getHandshakeStatus()) {
            case FINISHED: 
            case NOT_HANDSHAKING: {
                if (!this.delegateHasChunks && !this.hasUnsentChunks) break;
                this.notifyChunksAvailable();
            }
        }
        return this.inAppChunkedOutput.getOutput(this);
    }
}

