/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.codec.shaped;

import com.devexperts.connector.codec.CodecConnectionFactory;
import com.devexperts.connector.codec.shaped.ShapedConnection;
import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.TransportConnection;
import java.io.IOException;

public class ShapedConnectionFactory
extends CodecConnectionFactory {
    private double outLimit = Double.POSITIVE_INFINITY;

    ShapedConnectionFactory(ApplicationConnectionFactory delegate) {
        super(delegate);
    }

    public double getOutLimit() {
        return this.outLimit;
    }

    @Configurable(description="output throughput limit (bytes per second)")
    public void setOutLimit(double outLimit) {
        if (outLimit <= 0.0) {
            throw new IllegalArgumentException("positive value expected");
        }
        this.outLimit = outLimit;
    }

    @Override
    public ApplicationConnection<?> createConnection(TransportConnection transportConnection) throws IOException {
        return new ShapedConnection(this.getDelegate(), this, transportConnection);
    }

    @Override
    public String toString() {
        return "shaped+" + this.getDelegate().toString();
    }
}

