/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.codec.shaped;

import com.devexperts.connector.codec.CodecConnection;
import com.devexperts.connector.codec.shaped.ShapedConnectionFactory;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import java.io.IOException;
import javax.annotation.concurrent.GuardedBy;

class ShapedConnection
extends CodecConnection<ShapedConnectionFactory> {
    private static final long COMMITTED_BURST_DURATION = 100L;
    private final double outLimit;
    private final Object chunksLock = new Object();
    private final ChunkPool chunkPool = ChunkPool.DEFAULT;
    private final double cbs;
    private volatile long lastTime;
    private volatile boolean delegateHasChunks = true;
    private ChunkList chunksForSending;
    @GuardedBy(value="chunksLock")
    private long outBucket;

    ShapedConnection(ApplicationConnectionFactory delegateFactory, ShapedConnectionFactory config, TransportConnection transportConnection) throws IOException {
        super(delegateFactory, config, transportConnection);
        this.outLimit = config.getOutLimit();
        this.cbs = 100.0 * this.outLimit / 1000.0;
    }

    @Override
    protected void startImpl() {
        this.lastTime = System.currentTimeMillis();
        super.startImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl() {
        super.closeImpl();
        Object object = this.chunksLock;
        synchronized (object) {
            if (this.chunksForSending != null) {
                this.chunksForSending.recycle(this);
                this.chunksForSending = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long examine(long currentTime) {
        boolean hasChunks;
        Object object = this.chunksLock;
        synchronized (object) {
            hasChunks = this.chunksForSending != null;
        }
        long nextTime = super.examine(currentTime);
        if (this.delegateHasChunks || hasChunks) {
            this.notifyChunksAvailable();
            nextTime = Math.min(nextTime, currentTime + 10L);
        }
        return nextTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkList retrieveChunks(Object owner) {
        Object object = this.chunksLock;
        synchronized (object) {
            ChunkList result;
            long availableSize;
            if (this.isClosed()) {
                return null;
            }
            long curTime = System.currentTimeMillis();
            long interval = Math.max(curTime - this.lastTime, 0L);
            this.outBucket = (long)Math.min(this.cbs, (double)this.outBucket + (double)interval * this.outLimit / 1000.0);
            this.lastTime = curTime;
            if (this.outBucket <= 0L) {
                return null;
            }
            long l = availableSize = this.chunksForSending == null ? 0L : this.chunksForSending.getTotalLength();
            if (availableSize < this.outBucket && this.delegateHasChunks) {
                this.delegateHasChunks = false;
                ChunkList delegateChunks = this.delegate.retrieveChunks(this);
                if (delegateChunks != null) {
                    availableSize += delegateChunks.getTotalLength();
                    if (this.chunksForSending == null) {
                        this.chunksForSending = delegateChunks;
                    } else {
                        this.chunksForSending.addAll(delegateChunks, this);
                    }
                }
            }
            if (availableSize <= this.outBucket) {
                result = this.chunksForSending;
                this.chunksForSending = null;
                this.outBucket -= availableSize;
            } else {
                result = this.chunkPool.getChunkList(this);
                while (this.outBucket > 0L) {
                    Chunk chunk = this.chunksForSending.get(0);
                    if ((long)chunk.getLength() > this.outBucket) {
                        result.addAll(this.chunkPool.copyToChunkList(chunk.getBytes(), chunk.getOffset(), (int)this.outBucket, this), this);
                        this.chunksForSending.setChunkRange(0, chunk.getOffset() + (int)this.outBucket, chunk.getLength() - (int)this.outBucket, this);
                        this.outBucket = 0L;
                        continue;
                    }
                    chunk = this.chunksForSending.poll(this);
                    result.add(chunk, this);
                    this.outBucket -= (long)chunk.getLength();
                }
            }
            if (result != null) {
                result.handOver(this, owner);
            }
            return result;
        }
    }

    @Override
    public void chunksAvailable() {
        this.delegateHasChunks = true;
        super.chunksAvailable();
    }
}

