/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector.codec;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.ConfigurationException;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.io.ChunkPool;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.TrustManager;

public abstract class CodecConnectionFactory
extends ApplicationConnectionFactory {
    private ApplicationConnectionFactory delegate;

    protected CodecConnectionFactory(ApplicationConnectionFactory delegate) {
        super(delegate.getName());
        this.delegate = delegate;
    }

    @Override
    public Set<ConfigurationKey<?>> supportedConfiguration() {
        LinkedHashSet set = new LinkedHashSet(super.supportedConfiguration());
        set.addAll(this.delegate.supportedConfiguration());
        return set;
    }

    @Override
    public <T> T getConfiguration(ConfigurationKey<T> key) {
        if (super.supportedConfiguration().contains(key)) {
            return super.getConfiguration(key);
        }
        return this.delegate.getConfiguration(key);
    }

    @Override
    public <T> boolean setConfiguration(ConfigurationKey<T> key, T value) throws ConfigurationException {
        if (super.supportedConfiguration().contains(key)) {
            return super.setConfiguration(key, value);
        }
        return this.delegate.setConfiguration(key, value);
    }

    @Override
    public void reinitConfiguration() {
        this.delegate.reinitConfiguration();
    }

    @Override
    public CodecConnectionFactory clone() {
        CodecConnectionFactory clone = (CodecConnectionFactory)super.clone();
        clone.delegate = this.delegate.clone();
        return clone;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    @Configurable(description="name of this connection")
    public void setName(String name) {
        super.setName(name);
        this.delegate.setName(name);
    }

    @Override
    public ChunkPool getChunkPool() {
        return this.delegate.getChunkPool();
    }

    @Override
    @Configurable(description="Chunk pool")
    public void setChunkPool(ChunkPool chunkPool) {
        super.setChunkPool(chunkPool);
        this.delegate.setChunkPool(chunkPool);
    }

    public ApplicationConnectionFactory getDelegate() {
        return this.delegate;
    }

    public void setTrustManager(TrustManager trustManager) {
        if (this.delegate instanceof CodecConnectionFactory) {
            ((CodecConnectionFactory)this.delegate).setTrustManager(trustManager);
        }
    }
}

