/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.auth;

import com.devexperts.util.Base64;
import com.devexperts.util.InvalidFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AuthToken
implements Serializable {
    public static final String BASIC_SCHEME = "Basic";
    public static final String BEARER_SCHEME = "Bearer";
    private static final long serialVersionUID = 0L;
    private transient String scheme;
    private transient String user;
    private transient String password;
    private transient String value;
    private String string;

    public static AuthToken valueOf(String string) {
        Objects.requireNonNull(string);
        AuthToken at = new AuthToken(string);
        at.decode();
        return at;
    }

    public static AuthToken createBasicToken(String userPassword) {
        Objects.requireNonNull(userPassword);
        int i = userPassword.indexOf(58);
        if (i < 1 || i == userPassword.length() - 1) {
            throw new InvalidFormatException("Does not contain user:password");
        }
        AuthToken at = new AuthToken(BASIC_SCHEME, userPassword.substring(0, i), userPassword.substring(i + 1));
        return at;
    }

    public static AuthToken createBasicToken(String user, String password) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        AuthToken at = new AuthToken(BASIC_SCHEME, user, password);
        return at;
    }

    public static AuthToken createBearerToken(String accessToken) {
        Objects.requireNonNull(accessToken);
        AuthToken at = new AuthToken(BEARER_SCHEME, accessToken);
        return at;
    }

    public static AuthToken createCustomToken(String scheme, String value) {
        if (scheme.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(value);
        return new AuthToken(scheme, value);
    }

    private AuthToken(@Nonnull String string) {
        this.string = string;
    }

    private AuthToken(@Nonnull String scheme, @Nonnull String user, @Nonnull String password) {
        this.scheme = scheme;
        this.user = user;
        this.password = password;
        this.value = Base64.DEFAULT.encode((user + ":" + password).getBytes(StandardCharsets.UTF_8));
        this.string = scheme + " " + this.value;
    }

    private AuthToken(@Nonnull String scheme, @Nonnull String value) {
        this.scheme = scheme;
        this.value = value;
        this.string = scheme + " " + value;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AuthToken)) {
            return false;
        }
        return this.string.equals(((AuthToken)o).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public String toString() {
        return this.string;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.decode();
    }

    private void decode() {
        int j = this.string.indexOf(32);
        if (j <= 0) {
            throw new InvalidFormatException("Expected space-separated scheme and value");
        }
        this.scheme = this.string.substring(0, j);
        this.value = this.string.substring(j + 1);
        if (this.scheme.equals(BASIC_SCHEME)) {
            String userPassword = new String(Base64.DEFAULT.decode(this.value), StandardCharsets.UTF_8);
            int i = userPassword.indexOf(58);
            if (i < 0) {
                throw new InvalidFormatException("Does not contain user:password");
            }
            this.user = userPassword.substring(0, i);
            this.password = userPassword.substring(i + 1);
            return;
        }
    }
}

