/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.auth;

import com.devexperts.auth.SessionCloseListener;
import com.devexperts.logging.Logging;
import com.devexperts.util.TypedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AuthSession {
    private Object subject;
    private final List<SessionCloseListener> listeners = new ArrayList<SessionCloseListener>();
    private volatile String closeReason;
    private final TypedMap sessionVariables = new TypedMap();

    public AuthSession(Object subject) {
        this.subject = subject;
    }

    public boolean isClosed() {
        return this.closeReason != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseListener(SessionCloseListener listener) {
        String closeReason;
        Objects.requireNonNull(listener);
        AuthSession authSession = this;
        synchronized (authSession) {
            closeReason = this.closeReason;
            if (closeReason == null) {
                this.listeners.add(listener);
            }
        }
        if (closeReason != null) {
            listener.close(this, closeReason);
        }
    }

    public synchronized void removeCloseListener(SessionCloseListener listener) {
        this.listeners.remove(listener);
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.subject = subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(String closeReason) {
        Objects.requireNonNull(closeReason);
        SessionCloseListener[] sessionCloseListenerArray = this;
        synchronized (this) {
            if (this.closeReason != null) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.closeReason = closeReason;
            SessionCloseListener[] listeners = this.listeners.toArray(new SessionCloseListener[this.listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            try {
                this.closeImpl(closeReason);
            }
            catch (Throwable t) {
                Logging.getLogging(this.getClass()).error("Unexpected error in closeImpl()", t);
            }
            for (SessionCloseListener listener : listeners) {
                try {
                    listener.close((AuthSession)this, closeReason);
                }
                catch (Throwable t) {
                    Logging.getLogging(this.getClass()).error("Failed to notify session listener", t);
                }
            }
            return;
        }
    }

    protected void closeImpl(String closeReason) {
    }

    public TypedMap variables() {
        return this.sessionVariables;
    }
}

