/*
 * Decompiled with CFR 0.152.
 */
package com.pixelduke.window;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

interface FoundationLibrary
extends Library {
    public static final NativeLong NULL = new NativeLong(0L);
    public static final FoundationLibrary INSTANCE = (FoundationLibrary)Native.load((String)"Foundation", FoundationLibrary.class, Map.of("string-encoding", StandardCharsets.UTF_8.name()));
    public static final NativeLong stringCls = INSTANCE.objc_getClass("NSString");
    public static final Pointer stringSel = INSTANCE.sel_registerName("string");
    public static final Pointer allocSel = INSTANCE.sel_registerName("alloc");
    public static final Pointer initWithBytesLengthEncodingSel = INSTANCE.sel_registerName("initWithBytes:length:encoding:");
    public static final long NSUTF16LittleEndianStringEncoding = -1811939072L;

    public NativeLong objc_getClass(String var1);

    public NativeLong objc_lookUpClass(String var1);

    public Pointer sel_registerName(String var1);

    public NativeLong objc_msgSend(NativeLong var1, Pointer var2);

    public NativeLong objc_msgSend(NativeLong var1, Pointer var2, Pointer ... var3);

    public NativeLong objc_msgSend(NativeLong var1, Pointer var2, NativeLong ... var3);

    public NativeLong objc_msgSend(NativeLong var1, Pointer var2, byte[] var3, int var4, long var5);

    public NativeLong objc_msgSend(NativeLong var1, Pointer var2, boolean var3);

    public NativeLong objc_msgSend(NativeLong var1, Pointer var2, double var3);

    public NativeLong objc_msgSend(NativeLong var1, Pointer var2, Double var3, Double var4, Double var5, Double var6);

    public static String toNativeString(NativeLong nativeLong) {
        if (NULL.equals((Object)nativeLong)) {
            return null;
        }
        CoreFoundation.CFStringRef cfString = new CoreFoundation.CFStringRef(new Pointer(nativeLong.longValue()));
        try {
            String string = CoreFoundation.INSTANCE.CFStringGetLength(cfString).intValue() > 0 ? cfString.stringValue() : "";
            return string;
        }
        finally {
            cfString.release();
        }
    }

    public static NativeLong fromJavaString(String s) {
        if (s.isEmpty()) {
            return INSTANCE.objc_msgSend(stringCls, stringSel);
        }
        byte[] utf16Bytes = s.getBytes(Charset.forName("UTF-16LE"));
        return INSTANCE.objc_msgSend(INSTANCE.objc_msgSend(stringCls, allocSel), initWithBytesLengthEncodingSel, utf16Bytes, utf16Bytes.length, -1811939072L);
    }
}

