/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.study;

import bo.aj;
import bo.ap;
import bo.ar;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.StudyInfo;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.Enums$EntryState;
import com.motivewave.platform.sdk.common.Enums$MAMethod;
import com.motivewave.platform.sdk.common.Enums$StrategyState;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.NVP;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TimeFrame;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DiscreteDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.InstrumentDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.menu.MenuDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.ResizePoint;
import com.motivewave.platform.sdk.order_mgmt.Order;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.StudyHeader;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Study
implements Cloneable {
    public static final int SHIFT_DOWN = 64;
    public static final int CTRL_DOWN = 128;
    public static final int META_DOWN = 256;
    public static final int ALT_DOWN = 512;
    private Map figureMap = Collections.synchronizedMap(new HashMap());
    private RuntimeDescriptor runtimeDescriptor = this.createRD();
    private SettingsDescriptor settingsDescriptor;
    private Settings settings;
    private StudyInfo info;
    private int minBars = 20;
    private Map minBarMap = new HashMap();
    private Long minStartTime = null;
    private int figureUpdateCount = 0;
    private boolean figureUpdatePending = false;
    private boolean cancelInProgress = false;
    private boolean ignoreFigureUpdates = false;
    private boolean vetoClosePosition = false;
    private boolean destroyed = false;
    private Enums$StrategyState state = Enums$StrategyState.INACTIVE;
    private Enums$EntryState entryState = Enums$EntryState.NONE;
    private Boolean iLong = null;
    private Map labelMap = Collections.synchronizedMap(new HashMap());
    private Float stopPrice = null;
    private Float targetPrice = null;
    private DataContext dataCtx = null;
    private int lastSize = -1;
    private com.motivewave.common.util.ap weakSupport = new com.motivewave.common.util.ap((Object)this);
    private Boolean overlay = null;
    private long lastRangeUpdate = 0L;
    private long lastRedraw = 0L;
    private long lastValuesUpdated = 0L;

    public void initialize(Defaults defaults) {
    }

    public void onLoad(Defaults defaults) {
    }

    protected void precalculate(DataContext dataContext) {
    }

    protected void postcalculate(DataContext dataContext) {
    }

    protected void calculate(int n, DataContext dataContext) {
    }

    protected void calculateValues(DataContext dataContext) {
        int n;
        List list;
        this.dataCtx = dataContext;
        if (dataContext == null) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        if (this.getInfo().isMultipleInstruments() && !Util.isEmpty(list = this.getInstruments())) {
            for (Object object : list) {
                if (object == null || dataSeries.hasData((Instrument)object)) continue;
                return;
            }
        }
        if (!Util.isEmpty(list = this.getBarSizes())) {
            for (Object object : list) {
                DataSeries dataSeries2 = dataContext.getDataSeries((BarSize)object);
                if (dataSeries2 != null && dataSeries2.hasData()) continue;
                return;
            }
        }
        if (dataSeries == null) {
            return;
        }
        StudyInfo studyInfo = this.getInfo();
        boolean bl = this.getSettings().isBarUpdates() || studyInfo != null && studyInfo.isRequiresBarUpdates();
        int n2 = 0;
        if (this.lastSize > dataSeries.size()) {
            this.lastSize = -1;
        }
        if (dataSeries.size() - this.lastSize == 1) {
            for (n = dataSeries.size() - 1; n >= 0; --n) {
                if (!dataSeries.isComplete(n)) continue;
                n2 = n + 1;
                break;
            }
        }
        for (n = n2; n < dataSeries.size(); ++n) {
            if (dataSeries.isComplete(n) || !bl && !dataSeries.isBarComplete(n)) continue;
            this.calculate(n, dataContext);
        }
        this.lastSize = dataSeries.size();
        this.notifyRangeUpdated();
    }

    public boolean isRepaintAllOnUpdate() {
        return false;
    }

    public boolean hasFooter() {
        return false;
    }

    public void onBarOpen(DataContext dataContext) {
        this.onBarUpdate(dataContext);
    }

    public void onBarUpdate(DataContext dataContext) {
        this.dataCtx = dataContext;
        StudyInfo studyInfo = this.getInfo();
        if (this.getSettings().isBarUpdates() || studyInfo != null && studyInfo.isRequiresBarUpdates()) {
            this.calculate(dataContext.getDataSeries().size() - 1, dataContext);
        }
    }

    public void onTick(DataContext dataContext, Tick tick) {
    }

    public void onBarClose(DataContext dataContext) {
        this.dataCtx = dataContext;
        this.calculate(dataContext.getDataSeries().size() - 1, dataContext);
    }

    public void onDataSeriesMoved(DataContext dataContext) {
        this.dataCtx = dataContext;
    }

    public void onDataSeriesUpdated(DataContext dataContext) {
        this.ignoreFigureUpdates = true;
        try {
            this.dataCtx = dataContext;
            this.precalculate(dataContext);
            this.calculateValues(dataContext);
            this.postcalculate(dataContext);
        }
        finally {
            this.ignoreFigureUpdates = false;
        }
        this.notifyFiguresUpdated();
    }

    public void onNewDataSeries(DataContext dataContext) {
        this.ignoreFigureUpdates = true;
        try {
            this.lastSize = -1;
            this.dataCtx = dataContext;
            this.clearFigures();
            this.precalculate(dataContext);
            this.calculateValues(dataContext);
            this.postcalculate(dataContext);
        }
        finally {
            this.ignoreFigureUpdates = false;
        }
        this.notifyFiguresUpdated();
    }

    public void onSettingsUpdated(DataContext dataContext) {
    }

    public void recalculate(DataContext dataContext) {
        this.ignoreFigureUpdates = true;
        try {
            this.dataCtx = dataContext;
            this.clearFigures();
            this.labelMap.clear();
            this.updateDefaultGuides();
            DataSeries dataSeries = dataContext.getDataSeries();
            if (dataSeries != null && dataSeries.hasData()) {
                this.precalculate(dataContext);
                this.calculateValues(dataContext);
                this.postcalculate(dataContext);
            }
        }
        finally {
            this.ignoreFigureUpdates = false;
        }
        this.notifyFiguresUpdated();
    }

    public MenuDescriptor onMenu(String string, Point point, DrawContext drawContext) {
        return null;
    }

    public void onBeginResize(ResizePoint resizePoint, DrawContext drawContext) {
    }

    public void onResize(ResizePoint resizePoint, DrawContext drawContext) {
    }

    public void onEndResize(ResizePoint resizePoint, DrawContext drawContext) {
    }

    public boolean supportsDrag() {
        return false;
    }

    public void onHover(Point2D point2D, int n, DrawContext drawContext) {
    }

    public void onHoverLost(Point2D point2D, int n, DrawContext drawContext) {
    }

    public void onBeginDrag(Point2D point2D, int n, DrawContext drawContext) {
    }

    public void onDrag(Point2D point2D, int n, DrawContext drawContext) {
    }

    public void onEndDrag(Point2D point2D, int n, DrawContext drawContext) {
    }

    public boolean onDoubleClick(Point point, int n) {
        return true;
    }

    public boolean onClick(Point point, int n) {
        return true;
    }

    public boolean onWheelMoved(Point point, int n, int n2) {
        return true;
    }

    public void clearState() {
        this.labelMap.clear();
        this.clearFigures();
        this.lastSize = -1;
    }

    public final RuntimeDescriptor createRD() {
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        this.setRuntimeDescriptor(runtimeDescriptor);
        return runtimeDescriptor;
    }

    public final RuntimeDescriptor getRuntimeDescriptor() {
        return this.runtimeDescriptor;
    }

    public final void setRuntimeDescriptor(RuntimeDescriptor runtimeDescriptor) {
        if (runtimeDescriptor == null) {
            h.c();
        }
        if (runtimeDescriptor == this.runtimeDescriptor) {
            return;
        }
        RuntimeDescriptor runtimeDescriptor2 = this.runtimeDescriptor;
        this.runtimeDescriptor = runtimeDescriptor;
        this.firePropertyChange("runtimeDescriptor", runtimeDescriptor2, this.runtimeDescriptor);
    }

    public final SettingsDescriptor createSD() {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        return settingsDescriptor;
    }

    public final SettingsDescriptor getSettingsDescriptor() {
        return this.settingsDescriptor;
    }

    public final void setSettingsDescriptor(SettingsDescriptor settingsDescriptor) {
        if (settingsDescriptor == this.settingsDescriptor) {
            return;
        }
        SettingsDescriptor settingsDescriptor2 = this.settingsDescriptor;
        this.settingsDescriptor = settingsDescriptor;
        if (this.settings != null) {
            this.settings.setDescriptor(settingsDescriptor);
        }
        this.firePropertyChange("settingsDescriptor", settingsDescriptor2, this.settingsDescriptor);
    }

    public final Settings getSettings() {
        if (this.settings == null) {
            this.settings = new Settings(this.settingsDescriptor);
        }
        return this.settings;
    }

    public final void setSettings(Settings settings) {
        Settings settings2 = this.settings;
        this.settings = settings;
        this.labelMap.clear();
        if (settings != null) {
            settings.setDescriptor(this.settingsDescriptor);
            this.updateDefaultGuides();
            for (InputDependency inputDependency : this.settingsDescriptor.getDependencies()) {
                inputDependency.setSettingsDescriptor(this.settingsDescriptor);
                inputDependency.onSourceUpdated(settings, new HashMap());
            }
        }
        this.firePropertyChange("settings", settings2, this.settings);
    }

    public List getBarSizes() {
        ArrayList<BarSize> arrayList = new ArrayList<BarSize>();
        Settings settings = this.getSettings();
        if (settings == null) {
            return arrayList;
        }
        SettingsDescriptor settingsDescriptor = this.getSettingsDescriptor();
        for (String string : settings.getBarSizes()) {
            BarSize barSize = settings.getBarSize(string);
            SettingDescriptor settingDescriptor = settingsDescriptor.getSetting(string);
            if (settingDescriptor != null && !settingDescriptor.isEnabled() || arrayList.contains(barSize)) continue;
            arrayList.add(barSize);
        }
        return arrayList;
    }

    public List getInstruments() {
        Settings settings = this.getSettings();
        ArrayList<Instrument> arrayList = new ArrayList<Instrument>();
        if (settings == null) {
            return arrayList;
        }
        SettingsDescriptor settingsDescriptor = this.getSettingsDescriptor();
        for (String string : settings.getInstruments()) {
            SettingDescriptor settingDescriptor;
            Instrument instrument = settings.getInstrument(string);
            if (instrument == null || (settingDescriptor = settingsDescriptor.getSetting(string)) != null && !settingDescriptor.isEnabled()) continue;
            arrayList.add(instrument);
        }
        return arrayList;
    }

    private void updateDefaultGuides() {
        Plot plot = this.runtimeDescriptor.getDefaultPlot();
        for (String string : this.settings.getGuides()) {
            boolean bl = false;
            for (String string2 : this.runtimeDescriptor.getPlotKeys()) {
                Plot plot2 = this.runtimeDescriptor.getPlot(string2);
                if (plot2 == plot || !plot2.getGuides().contains(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            plot.declareGuide(string);
        }
    }

    public String getPopupMessage(double d, double d2, DrawContext drawContext) {
        for (Figure figure : this.getFigures()) {
            String string;
            if (figure == null || !figure.contains(d, d2, drawContext) || Util.isEmpty(string = figure.getPopupMessage(d, d2, drawContext))) continue;
            return string;
        }
        return "";
    }

    public final StudyHeader getHeader() {
        return this.getClass().getAnnotation(StudyHeader.class);
    }

    public String getLabel() {
        return this.getLabel("__DEFAULT__");
    }

    public String getLabel(String string) {
        String string2 = (String)this.labelMap.get(string);
        if (string2 != null) {
            return string2;
        }
        RuntimeDescriptor runtimeDescriptor = this.getRuntimeDescriptor();
        StudyInfo studyInfo = ap.a((Study)this);
        if (studyInfo == null) {
            return "";
        }
        Object object = studyInfo.getGraphLabel();
        if (runtimeDescriptor == null) {
            return object;
        }
        Plot plot = runtimeDescriptor.getPlot(string);
        if (plot == null) {
            return object;
        }
        List list = plot.getLabelSettings();
        if (plot.getLabelPrefix() != null) {
            object = plot.getLabelPrefix();
        }
        if (Util.isEmpty(list)) {
            return object;
        }
        SettingsDescriptor settingsDescriptor = this.getSettingsDescriptor();
        Settings settings = this.getSettings();
        if (settings != null) {
            Object object2 = "(";
            boolean bl = true;
            for (String string3 : list) {
                Object object3;
                NVP nVP;
                SettingDescriptor settingDescriptor = null;
                if (settingsDescriptor != null) {
                    settingDescriptor = settingsDescriptor.getSetting(string3);
                }
                if (settingDescriptor != null && !settingDescriptor.isEnabled()) continue;
                Object object4 = settings.getSetting(string3);
                if (object4 == null && settingDescriptor != null && (object4 = settingDescriptor.getDefaultValue()) == null && this.dataCtx != null && settingDescriptor instanceof InstrumentDescriptor) {
                    object4 = this.dataCtx.getInstrument().getSymbol();
                }
                if (ab.a((Object)object4, (SettingDescriptor)settingDescriptor)) continue;
                if (settingDescriptor != null && settingDescriptor instanceof DiscreteDescriptor && (nVP = ((DiscreteDescriptor)(object3 = (DiscreteDescriptor)settingDescriptor)).findNVP(h.b((Object)object4))) != null) {
                    object4 = nVP.getName();
                }
                if (Util.isEmpty(object3 = ab.a((Object)object4, (SettingDescriptor)settingDescriptor))) continue;
                if (bl) {
                    bl = false;
                } else {
                    object2 = (String)object2 + ",";
                }
                object2 = (String)object2 + (String)object3;
            }
            if (!Util.compare(object2 = (String)object2 + ")", "()")) {
                object = (String)object + (String)object2;
            }
        }
        this.labelMap.put(string, object);
        return object;
    }

    protected final void clearFigures() {
        boolean bl = this.figureMap.isEmpty();
        this.figureMap.clear();
        if (!bl) {
            this.figureUpdatePending = true;
        }
        this.notifyFiguresUpdated();
    }

    protected final void clearFigures(String string) {
        List list = (List)this.figureMap.get(string);
        if (list == null) {
            return;
        }
        boolean bl = list.isEmpty();
        list.clear();
        if (!bl) {
            this.figureUpdatePending = true;
        }
        this.notifyFiguresUpdated();
    }

    public void onFiguresLaidOut(DrawContext drawContext) {
    }

    protected final void addFigure(Figure figure) {
        this.addFigure("__DEFAULT__", figure);
    }

    protected final void setFigures(List list) {
        this.setFigures("__DEFAULT__", list);
    }

    protected final void addFigureFront(Figure figure) {
        this.addFigureFront("__DEFAULT__", figure);
    }

    protected final void addFigure(String string, Figure figure) {
        if (figure == null) {
            return;
        }
        ArrayList<Figure> arrayList = (ArrayList<Figure>)this.figureMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Figure>();
            this.figureMap.put(string, arrayList);
        }
        if (this.contains(arrayList, figure)) {
            return;
        }
        arrayList.add(figure);
        this.figureUpdatePending = true;
        this.notifyFiguresUpdated();
    }

    protected final void setFigures(String string, List list) {
        if (Util.isEmpty(list)) {
            this.figureMap.put(string, new ArrayList());
        } else {
            this.figureMap.put(string, new ArrayList(list));
        }
        this.figureUpdatePending = true;
        this.notifyFiguresUpdated();
    }

    protected final void addFigures(Collection collection) {
        this.addFigures("__DEFAULT__", collection);
    }

    protected final void addFigures(String string, Collection collection) {
        if (Util.isEmpty(collection)) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.figureMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.figureMap.put(string, arrayList);
        }
        boolean bl = true;
        for (Figure figure : collection) {
            if (this.contains(arrayList, figure)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        arrayList.removeAll(collection);
        arrayList.addAll(collection);
        this.figureUpdatePending = true;
        this.notifyFiguresUpdated();
    }

    protected final void addFigure(int n, Figure figure) {
        this.addFigure("__DEFAULT__", n, figure);
    }

    protected final void addFigure(String string, int n, Figure figure) {
        if (figure == null) {
            return;
        }
        ArrayList<Figure> arrayList = (ArrayList<Figure>)this.figureMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Figure>();
            this.figureMap.put(string, arrayList);
        }
        arrayList.remove(figure);
        if (Util.isEmpty(arrayList)) {
            arrayList.add(figure);
        } else if (n < 0) {
            arrayList.add(0, figure);
        } else if (n >= arrayList.size() - 1) {
            arrayList.add(figure);
        } else {
            arrayList.add(n, figure);
        }
        this.figureUpdatePending = true;
        this.notifyFiguresUpdated();
    }

    protected final void addFigureFront(String string, Figure figure) {
        if (figure == null) {
            return;
        }
        ArrayList<Figure> arrayList = (ArrayList<Figure>)this.figureMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Figure>();
            this.figureMap.put(string, arrayList);
        }
        if (this.contains(arrayList, figure)) {
            arrayList.remove(figure);
        }
        if (Util.isEmpty(arrayList)) {
            arrayList.add(figure);
        } else {
            arrayList.add(0, figure);
        }
        this.figureUpdatePending = true;
        this.notifyFiguresUpdated();
    }

    protected final void removeFigure(Figure figure) {
        this.removeFigure("__DEFAULT__", figure);
    }

    protected final void removeFigure(String string, Figure figure) {
        if (figure == null) {
            return;
        }
        List list = (List)this.figureMap.get(string);
        if (list == null) {
            return;
        }
        if (!list.contains(figure)) {
            return;
        }
        list.remove(figure);
        this.figureUpdatePending = true;
        this.notifyFiguresUpdated();
    }

    private boolean contains(List list, Figure figure) {
        int n = list.size();
        if (n <= 10) {
            return list.contains(figure);
        }
        for (int i2 = n - 1; i2 >= n - 10 && i2 < list.size(); --i2) {
            if (!((Figure)list.get(i2)).equals(figure)) continue;
            return true;
        }
        return false;
    }

    protected final void removeFigures(Collection collection) {
        this.removeFigures("__DEFAULT__", collection);
    }

    protected final void removeFigures(String string, Collection collection) {
        if (Util.isEmpty(collection)) {
            return;
        }
        List list = (List)this.figureMap.get(string);
        if (list == null) {
            return;
        }
        boolean bl = false;
        for (Figure figure : collection) {
            if (!list.contains(figure)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        list.removeAll(collection);
        this.figureUpdatePending = true;
        this.notifyFiguresUpdated();
    }

    public final List getFigures() {
        return this.getFigures("__DEFAULT__");
    }

    public final List getFigures(String string) {
        List list = (List)this.figureMap.get(string);
        if (list == null) {
            return new ArrayList();
        }
        return new ArrayList(list);
    }

    public int getMinBars() {
        if (this.minBars != 20) {
            return this.minBars;
        }
        Settings settings = this.getSettings();
        int n = settings.getInteger("period", 0);
        int n2 = settings.getInteger("period2", 0);
        int n3 = settings.getInteger("period3", 0);
        int n4 = settings.getInteger("period4", 0);
        int n5 = n + n2 + n3 + n4;
        int n6 = 1;
        for (String string : settings.getMAMethods()) {
            Enums$MAMethod enums$MAMethod = settings.getMAMethod(string);
            if (Util.in((Object)enums$MAMethod, new Object[]{Enums$MAMethod.EMA, Enums$MAMethod.MEMA}) && n6 < 2) {
                n6 = 2;
            }
            if (Util.in((Object)enums$MAMethod, new Object[]{Enums$MAMethod.DEMA}) && n6 < 4) {
                n6 = 3;
            }
            if (!Util.in((Object)enums$MAMethod, new Object[]{Enums$MAMethod.DEMA}) || n6 >= 4) continue;
            n6 = 4;
        }
        if ((n5 *= n6) > 0) {
            return n5;
        }
        return this.minBars;
    }

    public int getMinBars(DataContext dataContext) {
        return this.getMinBars();
    }

    public int getMinBars(DataContext dataContext, BarSize barSize) {
        Integer n = (Integer)this.minBarMap.get(barSize);
        if (n != null) {
            return n;
        }
        return this.getMinBars();
    }

    public void setMinBars(int n) {
        this.minBars = n;
    }

    public void setMinBars(int n, BarSize barSize) {
        this.minBarMap.put(barSize, n);
    }

    public Long getMinStartTime() {
        return this.minStartTime;
    }

    public Long getMinStartTime(DataContext dataContext) {
        return this.getMinStartTime();
    }

    public void setMinStartTime(Long l2) {
        this.minStartTime = l2;
    }

    public void onActivate(OrderContext orderContext) {
    }

    public void onSessionStarted(OrderContext orderContext, TimeFrame timeFrame) {
    }

    public void onSessionEnded(OrderContext orderContext, TimeFrame timeFrame) {
        if (this.getSettings().isCloseOnSessionEnd()) {
            orderContext.closeAtMarket();
        }
        this.setState(Enums$StrategyState.DORMANT);
    }

    public void onBarOpen(OrderContext orderContext) {
        this.onBarUpdate(orderContext);
    }

    public void onBarUpdate(OrderContext orderContext) {
    }

    public void onBarClose(OrderContext orderContext) {
        this.onBarUpdate(orderContext);
    }

    public void onSignal(OrderContext orderContext, Object object) {
    }

    public void onDeactivate(OrderContext orderContext) {
        if (this.getSettings().isCloseOnDeactivate() && !this.vetoClosePosition) {
            orderContext.closeAtMarket();
        }
        orderContext.cancelOrders();
        this.setState(Enums$StrategyState.INACTIVE);
    }

    public void setVetoCloseOnDeactivate(boolean bl) {
        this.vetoClosePosition = bl;
    }

    public void onReset(OrderContext orderContext) {
        this.setState(Enums$StrategyState.INACTIVE);
        this.setLong(null);
    }

    public void onPositionClosed(OrderContext orderContext) {
    }

    public void onEnterNow(OrderContext orderContext) {
    }

    public void onOrderFilled(OrderContext orderContext, Order order) {
    }

    public void onOrderCancelled(OrderContext orderContext, Order order) {
    }

    public void onOrderRejected(OrderContext orderContext, Order order) {
    }

    public void onOrderModified(OrderContext orderContext, Order order) {
    }

    public final Enums$StrategyState getState() {
        return this.state;
    }

    public final void setState(Enums$StrategyState enums$StrategyState) {
        if (enums$StrategyState == this.state) {
            return;
        }
        Enums$StrategyState enums$StrategyState2 = this.state;
        this.state = enums$StrategyState;
        this.firePropertyChange("state", (Object)enums$StrategyState2, (Object)this.state);
    }

    public final Enums$EntryState getEntryState() {
        return this.entryState;
    }

    public final void setEntryState(Enums$EntryState enums$EntryState) {
        if (enums$EntryState == this.entryState) {
            return;
        }
        Enums$EntryState enums$EntryState2 = this.entryState;
        this.entryState = enums$EntryState;
        this.firePropertyChange("entryState", (Object)enums$EntryState2, (Object)this.entryState);
    }

    public final boolean isLong() {
        if (this.iLong == null) {
            return false;
        }
        return this.iLong;
    }

    public final boolean isShort() {
        if (this.iLong == null) {
            return false;
        }
        return this.iLong == false;
    }

    public final void setLong(Boolean bl) {
        if (bl == this.iLong) {
            return;
        }
        Boolean bl2 = this.iLong;
        this.iLong = bl;
        this.firePropertyChange("long", bl2, this.iLong);
    }

    public final boolean isCancelInProgress() {
        return this.cancelInProgress;
    }

    public final void setCancelInProgress(boolean bl) {
        if (this.cancelInProgress == bl) {
            return;
        }
        boolean bl2 = this.cancelInProgress;
        this.cancelInProgress = bl;
        this.firePropertyChange("cancelInProgress", bl2, this.cancelInProgress);
    }

    public final Float getStopPrice() {
        return this.stopPrice;
    }

    public final void setStopPrice(Float f2) {
        if (f2 == this.stopPrice) {
            return;
        }
        Float f3 = this.stopPrice;
        this.stopPrice = f2;
        this.firePropertyChange("stopPrice", f3, this.stopPrice);
    }

    public final Float getTargetPrice() {
        return this.targetPrice;
    }

    public final void setTargetPrice(Float f2) {
        if (f2 == this.targetPrice) {
            return;
        }
        Float f3 = this.targetPrice;
        this.targetPrice = f2;
        this.firePropertyChange("targetPrice", f3, this.targetPrice);
    }

    public final void setDataContext(DataContext dataContext) {
        this.dataCtx = dataContext;
    }

    public DataContext getDataContext() {
        return this.dataCtx;
    }

    public final String get(String string, Object ... objectArray) {
        if (this.getInfo() == null) {
            return null;
        }
        try {
            return this.getInfo().get(string, objectArray);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public final double round(double d) {
        if (this.dataCtx == null || this.dataCtx.getInstrument() == null) {
            return d;
        }
        if (this.isOverlay()) {
            return Util.round(this.dataCtx.getInstrument().round(d), 8);
        }
        if (this.runtimeDescriptor == null || this.runtimeDescriptor.getMinTick() == null) {
            return d;
        }
        double d2 = this.runtimeDescriptor.getMinTick();
        if (d2 == 0.0) {
            return d;
        }
        return Util.round(Util.round(d, d2), 8);
    }

    public final String format(double d) {
        if (this.dataCtx == null || this.dataCtx.getInstrument() == null) {
            return "" + d;
        }
        if (this.isOverlay()) {
            return this.dataCtx.getInstrument().format(d);
        }
        if (this.runtimeDescriptor == null || this.runtimeDescriptor.getMinTick() == null) {
            return "" + d;
        }
        double d2 = this.runtimeDescriptor.getMinTick();
        if (d2 == 0.0) {
            return "" + d;
        }
        return "" + Util.round(Util.round(d, d2), 8);
    }

    public final boolean crossedAbove(Object object, Object object2) {
        if (this.dataCtx == null) {
            return false;
        }
        DataSeries dataSeries = this.dataCtx.getDataSeries();
        if (dataSeries == null) {
            return false;
        }
        return this.crossedAbove(dataSeries, dataSeries.size() - 1, object, object2);
    }

    public final boolean crossedAbove(DataSeries dataSeries, int n, Object object, Object object2) {
        if (dataSeries == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Double d = dataSeries.getDouble(n, object);
        Double d2 = dataSeries.getDouble(n, object2);
        if (d == null || d2 == null) {
            return false;
        }
        if (this.round2(d) <= this.round2(d2)) {
            return false;
        }
        double[] dArray = this.getNonEqualPair(dataSeries, n - 1, object, object2);
        if (dArray == null) {
            return false;
        }
        return dArray[0] < dArray[1];
    }

    public final boolean crossedAbove(Object object, double d) {
        if (this.dataCtx == null) {
            return false;
        }
        DataSeries dataSeries = this.dataCtx.getDataSeries();
        if (dataSeries == null) {
            return false;
        }
        return this.crossedAbove(dataSeries, dataSeries.size() - 1, object, d);
    }

    public final boolean crossedAbove(DataSeries dataSeries, int n, Object object, double d) {
        if (dataSeries == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Double d2 = dataSeries.getDouble(n, object);
        if (d2 == null) {
            return false;
        }
        if (this.round2(d2) <= this.round2(d)) {
            return false;
        }
        Double d3 = this.getNonEqualValue(dataSeries, n - 1, object, d);
        if (d3 == null) {
            return false;
        }
        return d3 < d;
    }

    public final boolean crossedBelow(Object object, Object object2) {
        if (this.dataCtx == null) {
            return false;
        }
        DataSeries dataSeries = this.dataCtx.getDataSeries();
        if (dataSeries == null) {
            return false;
        }
        return this.crossedBelow(dataSeries, dataSeries.size() - 1, object, object2);
    }

    public final boolean crossedBelow(DataSeries dataSeries, int n, Object object, Object object2) {
        if (dataSeries == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Double d = dataSeries.getDouble(n, object);
        Double d2 = dataSeries.getDouble(n, object2);
        if (d == null || d2 == null) {
            return false;
        }
        if (this.round2(d) >= this.round2(d2)) {
            return false;
        }
        double[] dArray = this.getNonEqualPair(dataSeries, n - 1, object, object2);
        if (dArray == null) {
            return false;
        }
        return dArray[0] > dArray[1];
    }

    public final boolean crossedBelow(Object object, double d) {
        if (this.dataCtx == null) {
            return false;
        }
        DataSeries dataSeries = this.dataCtx.getDataSeries();
        if (dataSeries == null) {
            return false;
        }
        return this.crossedBelow(dataSeries, dataSeries.size() - 1, object, d);
    }

    public final boolean crossedBelow(DataSeries dataSeries, int n, Object object, double d) {
        if (dataSeries == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Double d2 = dataSeries.getDouble(n, object);
        if (d2 == null) {
            return false;
        }
        if (this.round2(d2) >= this.round2(d)) {
            return false;
        }
        Double d3 = this.getNonEqualValue(dataSeries, n - 1, object, d);
        if (d3 == null) {
            return false;
        }
        return d3 > d;
    }

    private double[] getNonEqualPair(DataSeries dataSeries, int n, Object object, Object object2) {
        if (n < 0) {
            return null;
        }
        Double d = null;
        Double d2 = null;
        while (n >= 0) {
            d = dataSeries.getDouble(n, object);
            if (d == null) {
                --n;
                continue;
            }
            d2 = dataSeries.getDouble(n, object2);
            if (d2 == null) {
                --n;
                continue;
            }
            d = this.round2(d);
            d2 = this.round2(d2);
            if (!(Math.abs(d - d2) < 1.0E-9)) break;
            --n;
        }
        if (n < 0) {
            return null;
        }
        if (d == null || d2 == null) {
            return null;
        }
        return new double[]{d, d2};
    }

    private Double getNonEqualValue(DataSeries dataSeries, int n, Object object, double d) {
        int n2 = 0;
        while (n >= 0) {
            if (++n2 > 200) {
                return null;
            }
            if (n < 0) {
                return null;
            }
            Double d2 = dataSeries.getDouble(n, object);
            if (d2 == null) {
                --n;
                continue;
            }
            d2 = this.round2(d2);
            d = this.round2(d);
            if (Math.abs(d2 - d) < 1.0E-9) {
                --n;
                continue;
            }
            return d2;
        }
        return null;
    }

    private final double round2(double d) {
        if (this.dataCtx == null || this.dataCtx.getInstrument() == null) {
            return d;
        }
        if (this.isOverlay()) {
            double d2 = this.dataCtx.getInstrument().getTickSize() / 10.0;
            return Util.round(Util.round(d, d2), 8);
        }
        if (this.runtimeDescriptor == null || this.runtimeDescriptor.getMinTick() == null) {
            return d;
        }
        double d3 = this.runtimeDescriptor.getMinTick();
        if (d3 == 0.0) {
            return d;
        }
        return Util.round(Util.round(d, d3), 8);
    }

    public final void debug(String string) {
        ar.a((Study)this, (Enums.LogType)Enums.LogType.DEBUG, (String)string);
    }

    public final void info(String string) {
        ar.a((Study)this, (Enums.LogType)Enums.LogType.INFO, (String)string);
    }

    public final void warning(String string) {
        ar.a((Study)this, (Enums.LogType)Enums.LogType.WARNING, (String)string);
    }

    public final void error(String string) {
        ar.a((Study)this, (Enums.LogType)Enums.LogType.ERROR, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        com.motivewave.common.util.ap ap2 = this.weakSupport;
        synchronized (ap2) {
            this.weakSupport.b(propertyChangeListener);
            this.weakSupport.a(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        com.motivewave.common.util.ap ap2 = this.weakSupport;
        synchronized (ap2) {
            this.weakSupport.b(string, propertyChangeListener);
            this.weakSupport.a(string, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.weakSupport.b(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.weakSupport.b(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        try {
            if (this.weakSupport == null) {
                return;
            }
            this.weakSupport.a(string, object, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.figureMap.clear();
        this.weakSupport.a();
        if (this.settings instanceof aj) {
            ((aj)this.settings).destroy();
        }
    }

    protected void notifyRangeUpdated() {
        if (System.currentTimeMillis() - this.lastRangeUpdate < 300L) {
            return;
        }
        this.firePropertyChange("rangeUpdated", false, true);
        this.lastRangeUpdate = System.currentTimeMillis();
    }

    protected void notifyValuesUpdated() {
        if (System.currentTimeMillis() - this.lastValuesUpdated < 300L) {
            return;
        }
        this.firePropertyChange("valuesUpdated", false, true);
        this.lastValuesUpdated = System.currentTimeMillis();
    }

    protected void notifyRedraw() {
        long l2 = b.n() / 2;
        long l3 = System.currentTimeMillis() / l2 * l2;
        if (this.lastRedraw > l3 - l2) {
            return;
        }
        this.lastRedraw = l3;
        this.firePropertyChange("redraw", false, true);
    }

    public Study clone() {
        try {
            Study study = (Study)super.clone();
            if (this.figureMap != null) {
                study.figureMap = Collections.synchronizedMap(new HashMap());
                for (String string : this.figureMap.keySet()) {
                    List list = (List)this.figureMap.get(string);
                    if (list == null) continue;
                    study.figureMap.put(string, new ArrayList(list));
                }
            }
            if (this.settings != null) {
                study.settings = this.settings.clone();
            }
            return study;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private StudyInfo getInfo() {
        if (this.info == null) {
            this.info = ap.a((Study)this);
        }
        return this.info;
    }

    private boolean isOverlay() {
        if (this.overlay != null) {
            return this.overlay;
        }
        this.overlay = this.getHeader().overlay();
        return this.overlay;
    }

    public void beginFigureUpdate() {
        ++this.figureUpdateCount;
    }

    public void endFigureUpdate() {
        --this.figureUpdateCount;
        if (this.figureUpdateCount < 0) {
            this.figureUpdateCount = 0;
        }
        this.notifyFiguresUpdated();
    }

    private void notifyFiguresUpdated() {
        if (this.ignoreFigureUpdates || this.figureUpdateCount > 0) {
            return;
        }
        if (this.figureUpdatePending) {
            this.figureUpdatePending = false;
            this.firePropertyChange("figures", null, "");
            this.figureUpdatePending = false;
        }
    }
}

