/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.profile;

import ay.a;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.profile.VolumeProfile;
import java.util.Collections;
import java.util.List;

public class VolumeRow {
    private VolumeProfile profile;
    private float startPrice;
    private float endPrice;
    private double volume = 0.0;
    private double askVolume = 0.0;
    private double bidVolume = 0.0;
    private int lastSize = -1;
    private int index = -1;
    private a bidTrades;
    private a askTrades;

    public VolumeRow(VolumeProfile volumeProfile, float f2, float f3) {
        this.profile = volumeProfile;
        this.startPrice = f2;
        this.endPrice = f3;
    }

    public boolean contains(float f2) {
        return f2 < this.endPrice && f2 >= this.startPrice;
    }

    public boolean isPOC() {
        return this.profile.getPOC() == this;
    }

    public boolean isUAHigh() {
        List list = this.profile.getRows();
        if (list == null || list.isEmpty() || this != list.get(list.size() - 1)) {
            return false;
        }
        return this.bidVolume > 0.0;
    }

    public boolean isUALow() {
        List list = this.profile.getRows();
        if (list == null || list.isEmpty() || this != list.get(0)) {
            return false;
        }
        return this.askVolume > 0.0;
    }

    public VolumeProfile getProfile() {
        return this.profile;
    }

    private VolumeRow getNext() {
        this.updateIndex();
        if (this.index < 0) {
            return null;
        }
        List list = this.profile.getRows();
        if (this.index >= list.size() - 1) {
            return null;
        }
        return (VolumeRow)list.get(this.index + 1);
    }

    private VolumeRow getPrev() {
        this.updateIndex();
        if (this.index <= 0) {
            return null;
        }
        return (VolumeRow)this.profile.getRows().get(this.index - 1);
    }

    public boolean isBidImbalance(double d, int n, boolean bl) {
        boolean bl2;
        if (this.bidVolume <= 0.0) {
            return false;
        }
        VolumeRow volumeRow = this.getNext();
        if (volumeRow == null) {
            return false;
        }
        boolean bl3 = bl ? this.bidVolume - volumeRow.getAskVolume() >= (double)n : (bl2 = true);
        if (volumeRow.getAskVolume() == 0.0) {
            return bl2;
        }
        if (this.bidVolume / volumeRow.getAskVolume() < d) {
            return false;
        }
        return bl2;
    }

    public boolean isAskImbalance(double d, int n, boolean bl) {
        boolean bl2;
        if (this.askVolume <= 0.0) {
            return false;
        }
        VolumeRow volumeRow = this.getPrev();
        if (volumeRow == null) {
            return false;
        }
        boolean bl3 = bl ? this.askVolume - volumeRow.getBidVolume() >= (double)n : (bl2 = true);
        if (volumeRow.getBidVolume() <= 0.0) {
            return bl2;
        }
        if (this.askVolume / volumeRow.getBidVolume() < d) {
            return false;
        }
        return bl2;
    }

    public float getStartPrice() {
        return this.startPrice;
    }

    public float getEndPrice() {
        return this.endPrice;
    }

    public float getRowPrice() {
        if (this.profile.getRangeTicks() == 1) {
            return this.startPrice;
        }
        return this.profile.getInstrument().round((this.startPrice + this.endPrice) / 2.0f);
    }

    public void addFrom(VolumeRow volumeRow) {
        this.volume += volumeRow.volume;
        this.askVolume += volumeRow.askVolume;
        this.bidVolume += volumeRow.bidVolume;
    }

    public void onTick(Tick tick) {
        VolumeRow volumeRow;
        float f2 = tick.getVolumeAsFloat();
        if (f2 <= 0.0f) {
            f2 = 1.0f;
        }
        this.volume += (double)f2;
        boolean bl = tick.isAskTick();
        if (bl) {
            this.askVolume += (double)f2;
        } else {
            this.bidVolume += (double)f2;
        }
        if (this.profile.isFilterTrades() && f2 >= this.profile.getMinTradeSize()) {
            if (bl) {
                if (this.askTrades == null) {
                    this.askTrades = new a();
                }
                this.askTrades.a((Object)tick);
            } else {
                if (this.bidTrades == null) {
                    this.bidTrades = new a();
                }
                this.bidTrades.a((Object)tick);
            }
        }
        if ((volumeRow = this.profile.getPOC()) == this) {
            return;
        }
        if (volumeRow == null || volumeRow.getVolume() < this.volume) {
            this.profile.setPOC(this);
        }
    }

    public double getVolume() {
        return this.volume;
    }

    public double getAskVolume() {
        return this.askVolume;
    }

    public double getBidVolume() {
        return this.bidVolume;
    }

    public double getDelta() {
        return this.askVolume - this.bidVolume;
    }

    public List getAskTrades() {
        return this.askTrades == null ? Collections.EMPTY_LIST : this.askTrades.a();
    }

    public List getBidTrades() {
        return this.bidTrades == null ? Collections.EMPTY_LIST : this.bidTrades.a();
    }

    private void updateIndex() {
        List list = this.profile.getRows();
        int n = list.size();
        if (n != this.lastSize) {
            this.lastSize = n;
            this.index = list.indexOf(this);
        }
    }
}

