/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.profile;

import ay.a;
import com.motivewave.platform.common.Enums;
import com.motivewave.platform.common.b;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.profile.Profile;
import com.motivewave.platform.sdk.profile.VolumeRow;
import java.util.ArrayList;
import java.util.List;

public class VolumeProfile
extends Profile {
    private a rows = new a();
    private VolumeRow pocRow;
    protected double maxDelta = -1.7976931348623157E308;
    protected double minDelta = Double.MAX_VALUE;
    protected double totalDelta = 0.0;
    protected double maxBidVolume = 0.0;
    protected double maxAskVolume = 0.0;
    protected double maxVolume = 0.0;
    protected double minVolume = Double.MAX_VALUE;
    protected double maxRowDelta = -1.7976931348623157E308;
    protected double minRowDelta = Double.MAX_VALUE;
    protected double totalBidVolume;
    protected double totalAskVolume;
    private float tickSize;
    private double tickSizeD = this.instrument.getTickSize();
    private VolumeProfile prev;
    private VolumeProfile next;
    private int ticks = 0;
    private boolean complete = false;
    private boolean filterTrades = false;
    private float minTradeSize = 0.0f;
    private int[] lastVA;
    private Enums.VAMethod lastVAMethod;
    private double lastPer = -1.0;
    private double lastTotalVolume = 0.0;
    private int[] lastHVNs;
    private int lastHVNSensitivity = -1;
    private int[] lastLVNs;
    private int lastLVNSensitivity = -1;
    private int lastRow = -1;

    public VolumeProfile(long l2, long l3, Instrument instrument, int n) {
        super(l2, l3, instrument, n);
        this.tickSize = (float)this.instrument.getTickSize();
    }

    public boolean isSummary() {
        return false;
    }

    public VolumeProfile getPrev() {
        return this.prev;
    }

    public void setPrev(VolumeProfile volumeProfile) {
        this.prev = volumeProfile;
    }

    public VolumeProfile getNext() {
        return this.next;
    }

    public void setNext(VolumeProfile volumeProfile) {
        this.next = volumeProfile;
    }

    public double getAVAP() {
        int n = this.rows.a();
        return n == 0 ? 0.0 : this.totalVolume / (double)n;
    }

    public double getDeltaPer() {
        if (this.totalVolume <= 0.0) {
            return 0.0;
        }
        return this.totalDelta / this.totalVolume;
    }

    public double getDeltaChange() {
        if (this.prev == null) {
            return 0.0;
        }
        return this.totalDelta - this.prev.totalDelta;
    }

    public double getMaxDelta() {
        if (this.maxDelta == -1.7976931348623157E308) {
            return 0.0;
        }
        return this.maxDelta;
    }

    public boolean isMaxDeltaSet() {
        return this.maxDelta != -1.7976931348623157E308;
    }

    public double getMinDelta() {
        if (this.minDelta == Double.MAX_VALUE) {
            return 0.0;
        }
        return this.minDelta;
    }

    public double getMaxRowDelta() {
        if (this.maxRowDelta == -1.7976931348623157E308) {
            this.calcMinMaxRowDelta();
        }
        return this.maxRowDelta;
    }

    public double getMinRowDelta() {
        if (this.minRowDelta == Double.MAX_VALUE) {
            this.calcMinMaxRowDelta();
        }
        return this.minRowDelta;
    }

    private void calcMinMaxRowDelta() {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (VolumeRow volumeRow : this.rows.a()) {
            double d3 = volumeRow.getDelta();
            if (d3 > d2) {
                d2 = d3;
            }
            if (!(d3 < d)) continue;
            d = d3;
        }
        this.minRowDelta = d;
        this.maxRowDelta = d2;
    }

    public double getMaxAskVolume() {
        if (this.maxAskVolume != 0.0) {
            return this.maxAskVolume;
        }
        double d = 0.0;
        for (VolumeRow volumeRow : this.rows.a()) {
            if (!(volumeRow.getAskVolume() > d)) continue;
            d = volumeRow.getAskVolume();
        }
        this.maxAskVolume = d;
        return d;
    }

    public double getMaxVolume() {
        if (this.maxVolume != 0.0) {
            return this.maxVolume;
        }
        double d = 0.0;
        for (VolumeRow volumeRow : this.rows.a()) {
            if (!(volumeRow.getVolume() > d)) continue;
            d = volumeRow.getVolume();
        }
        this.maxVolume = d;
        return d;
    }

    public double getMinVolume() {
        if (this.minVolume != 0.0) {
            return this.minVolume;
        }
        double d = 0.0;
        for (VolumeRow volumeRow : this.rows.a()) {
            if (d != 0.0 && !(volumeRow.getVolume() < d)) continue;
            d = volumeRow.getVolume();
        }
        this.minVolume = d;
        return d;
    }

    public double getMaxBidVolume() {
        if (this.maxBidVolume != 0.0) {
            return this.maxBidVolume;
        }
        double d = 0.0;
        for (VolumeRow volumeRow : this.rows.a()) {
            if (!(volumeRow.getBidVolume() > d)) continue;
            d = volumeRow.getBidVolume();
        }
        this.maxBidVolume = d;
        return d;
    }

    public double getTotalDelta() {
        if (this.totalDelta != 0.0) {
            return this.totalDelta;
        }
        double d = 0.0;
        for (VolumeRow volumeRow : this.rows.a()) {
            d += volumeRow.getDelta();
        }
        this.totalDelta = d;
        return d;
    }

    public double getVolumePerSecond() {
        double d;
        long l2 = this.endTime;
        long l3 = this.getLastTime();
        if (l2 == -1L || l2 == Long.MAX_VALUE || l2 > l3) {
            l2 = l3;
        }
        if ((d = (double)(l2 - this.startTime) / 1000.0) <= 0.0) {
            return 0.0;
        }
        return this.totalVolume / d;
    }

    public double getTotalBidVolume() {
        return this.totalBidVolume;
    }

    public double getTotalAskVolume() {
        return this.totalAskVolume;
    }

    public float getVALow(int[] nArray) {
        if (nArray == null || nArray.length != 2 || this.rows == null || nArray[0] < 0 || nArray[0] >= this.rows.a()) {
            return 0.0f;
        }
        VolumeRow volumeRow = (VolumeRow)this.rows.a(nArray[0]);
        return volumeRow.getStartPrice();
    }

    public float getVAHigh(int[] nArray) {
        if (nArray == null || nArray.length != 2 || this.rows == null || nArray[1] < 0 || nArray[1] >= this.rows.a()) {
            return 0.0f;
        }
        VolumeRow volumeRow = (VolumeRow)this.rows.a(nArray[1]);
        return this.rangeTicks <= 1 ? volumeRow.getStartPrice() : volumeRow.getEndPrice();
    }

    public int[] getValueArea(double d) {
        return this.getValueArea(d, b.a());
    }

    public int[] getLVNs(int n) {
        int[] nArray = this.lastLVNs;
        int n2 = this.lastLVNSensitivity;
        if (nArray != null && n == n2) {
            return nArray;
        }
        this.lastLVNs = nArray = this.calcLVNs(n);
        this.lastLVNSensitivity = n;
        return nArray;
    }

    public int[] getHVNs(int n) {
        int[] nArray = this.lastHVNs;
        int n2 = this.lastHVNSensitivity;
        if (nArray != null && n == n2) {
            return nArray;
        }
        this.lastHVNs = nArray = this.calcHVNs(n);
        this.lastHVNSensitivity = n;
        return nArray;
    }

    public int[] getValueArea(double d, Enums.VAMethod vAMethod) {
        d = Util.round(d, 4);
        int[] nArray = this.lastVA;
        double d2 = this.lastPer;
        Enums.VAMethod vAMethod2 = this.lastVAMethod;
        if (nArray != null && d == d2 && vAMethod2 == vAMethod) {
            return nArray;
        }
        int[] nArray2 = vAMethod == Enums.VAMethod.OPTIMIZED ? this._getValueAreaOpt(d) : this._getValueArea(d);
        this.lastVA = nArray2;
        nArray = nArray2;
        this.lastPer = d;
        this.lastTotalVolume = this.totalVolume;
        this.lastVAMethod = vAMethod;
        return nArray;
    }

    private int[] _getValueArea(double d) {
        int n;
        int n2;
        List list = this.rows.a();
        VolumeRow volumeRow = this.getPOC();
        if (volumeRow == null || Util.isEmpty(list)) {
            return new int[]{-1, -1};
        }
        int n3 = list.indexOf(volumeRow);
        double d2 = this.totalVolume * d;
        double d3 = volumeRow.getVolume();
        if (d3 >= d2) {
            return new int[]{n3, n3};
        }
        int n4 = n3 - 1;
        int n5 = n3 + 1;
        int n6 = list.size();
        while (d3 < d2) {
            double d4 = 0.0;
            if (n4 >= 0) {
                d4 += ((VolumeRow)list.get(n4)).getVolume();
            }
            if (n4 > 0) {
                d4 += ((VolumeRow)list.get(n4 - 1)).getVolume();
            }
            double d5 = 0.0;
            if (n5 < n6) {
                d5 += ((VolumeRow)list.get(n5)).getVolume();
            }
            if (n5 < n6 - 1) {
                d5 += ((VolumeRow)list.get(n5 + 1)).getVolume();
            }
            if (d4 > d5) {
                d3 += d4;
                n4 -= 2;
            } else {
                d3 += d5;
                n5 += 2;
            }
            if (n4 >= 0 || n5 < n6) continue;
            break;
        }
        if ((n2 = n4 + 1) < 0) {
            n2 = 0;
        }
        if ((n = n5 - 1) >= n6) {
            n = n6 - 1;
        }
        return new int[]{n2, n};
    }

    private int[] _getValueAreaOpt(double d) {
        int n;
        List list = this.rows.a();
        VolumeRow volumeRow = this.getPOC();
        if (volumeRow == null || Util.isEmpty(list)) {
            return new int[]{-1, -1};
        }
        int n2 = list.indexOf(volumeRow);
        if (n2 < 0) {
            n2 = 0;
        }
        double d2 = this.totalVolume * d;
        double d3 = volumeRow.getVolume();
        if (d3 >= d2) {
            return new int[]{n2, n2};
        }
        int n3 = -1;
        double d4 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = list.size() - 1;
        double d5 = 0.0;
        for (n = n2; n >= 0; --n) {
            if ((d5 += ((VolumeRow)list.get(n)).getVolume()) < d2) continue;
            n6 = n;
            break;
        }
        d5 = 0.0;
        for (n = n2; n < list.size(); ++n) {
            if ((d5 += ((VolumeRow)list.get(n)).getVolume()) < d2) continue;
            n7 = n;
            break;
        }
        block2: for (n = n6; n <= n7; ++n) {
            d5 = 0.0;
            for (int i2 = n; i2 <= n7; ++i2) {
                if (!((d5 += ((VolumeRow)list.get(i2)).getVolume()) >= d2) || n2 < n || n2 > i2) continue;
                int n8 = i2 - n;
                if (n3 != -1 && n8 >= n3 && (n8 != n3 || !(d5 > d4))) continue block2;
                n4 = n;
                n5 = i2;
                n3 = n8;
                d4 = d5;
                continue block2;
            }
        }
        if (n3 == -1) {
            return new int[]{0, list.size() - 1};
        }
        return new int[]{n4, n5};
    }

    public void setFilterTrades(boolean bl) {
        this.filterTrades = bl;
    }

    public boolean isFilterTrades() {
        return this.filterTrades;
    }

    public void setMinTradeSize(float f2) {
        this.minTradeSize = f2;
    }

    public float getMinTradeSize() {
        return this.minTradeSize;
    }

    public int getTicks() {
        return this.ticks;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
        if (bl) {
            this.lastVA = null;
            this.lastPer = -1.0;
            this.pocRow = null;
        }
    }

    @Override
    public void onTick(Tick tick) {
        if (this.firstTick == null) {
            this.firstTick = tick;
        }
        float f2 = tick.getPrice();
        VolumeRow volumeRow = this.findOrCreate(f2);
        volumeRow.onTick(tick);
        float f3 = tick.getVolumeAsFloat();
        this.totalVolume += (double)f3;
        boolean bl = tick.isAskTick();
        if (bl) {
            this.totalAskVolume += (double)f3;
        } else {
            this.totalBidVolume += (double)f3;
        }
        if (this.openPrice == 0.0f) {
            this.lowPrice = this.highPrice = f2;
            this.openPrice = this.highPrice;
            this.minDelta = Double.MAX_VALUE;
            this.maxDelta = -1.7976931348623157E308;
        }
        if (f2 < this.lowPrice) {
            this.lowPrice = f2;
        }
        if (f2 > this.highPrice) {
            this.highPrice = f2;
        }
        this.lastPrice = f2;
        this.totalDelta += bl ? (double)f3 : (double)(-f3);
        if (this.totalDelta < this.minDelta) {
            this.minDelta = this.totalDelta;
        }
        if (this.totalDelta > this.maxDelta) {
            this.maxDelta = this.totalDelta;
        }
        this.minVolume = 0.0;
        this.maxVolume = 0.0;
        this.maxAskVolume = 0.0;
        this.maxBidVolume = 0.0;
        if (this.rows.a() < 1000 || this.lastTotalVolume > 0.0 && this.totalVolume / this.lastTotalVolume > 1.001) {
            this.lastVA = null;
            this.lastPer = -1.0;
        }
        ++this.ticks;
        this.lastTick = tick;
        this.lastHVNs = null;
        this.lastLVNs = null;
        this.lastHVNSensitivity = -1;
        this.lastLVNSensitivity = -1;
        this.minRowDelta = Double.MAX_VALUE;
        this.maxRowDelta = -1.7976931348623157E308;
    }

    public List getRows() {
        return this.rows.a();
    }

    public VolumeRow find(float f2) {
        block5: {
            if (this.lastRow < 0) break block5;
            VolumeRow volumeRow = (VolumeRow)this.rows.a(this.lastRow);
            if (volumeRow.contains(f2)) {
                return volumeRow;
            }
            if (f2 < volumeRow.getStartPrice()) {
                for (int i2 = this.lastRow - 1; i2 >= 0; --i2) {
                    volumeRow = (VolumeRow)this.rows.a(i2);
                    if (!volumeRow.contains(f2)) continue;
                    this.lastRow = i2;
                    return volumeRow;
                }
            } else {
                for (int i3 = this.lastRow + 1; i3 < this.rows.a(); ++i3) {
                    volumeRow = (VolumeRow)this.rows.a(i3);
                    if (!volumeRow.contains(f2)) continue;
                    this.lastRow = i3;
                    return volumeRow;
                }
            }
        }
        return null;
    }

    protected VolumeRow findOrCreate(float f2) {
        VolumeRow volumeRow = this.find(f2 = this.round(f2));
        if (volumeRow != null) {
            return volumeRow;
        }
        float f3 = f2;
        float f4 = f2 + this.tickSize;
        if (this.rangeTicks > 1) {
            long l2 = Math.round(f2 / this.tickSize);
            long l3 = l2 / (long)this.rangeTicks * (long)this.rangeTicks;
            long l4 = l2 / (long)this.rangeTicks * (long)this.rangeTicks + (long)this.rangeTicks;
            f3 = this.round((double)l3 * this.tickSizeD);
            f4 = this.round((double)l4 * this.tickSizeD);
        } else {
            f4 = this.round(f4);
        }
        volumeRow = new VolumeRow(this, f3, f4);
        if (this.rows.a()) {
            this.rows.a((Object)volumeRow);
            this.lastRow = 0;
        } else if (f2 >= ((VolumeRow)this.rows.a(this.rows.a() - 1)).getEndPrice()) {
            this.rows.b((Object)volumeRow);
            this.lastRow = this.rows.a() - 1;
        } else {
            for (int i2 = 0; i2 < this.rows.a(); ++i2) {
                if (!(((VolumeRow)this.rows.a(i2)).getStartPrice() > f2)) continue;
                this.rows.b(i2, (Object)volumeRow);
                this.lastRow = i2;
                return volumeRow;
            }
        }
        return volumeRow;
    }

    private float round(double d) {
        return (float)Util.roundDouble(Util.round(d, this.tickSizeD), 9);
    }

    public VolumeRow getPOC() {
        if (this.pocRow == null) {
            this.updatePOC();
        }
        return this.pocRow;
    }

    public float getPOCMidpoint() {
        VolumeRow volumeRow = this.getPOC();
        if (volumeRow == null) {
            return 0.0f;
        }
        if (this.rangeTicks <= 1) {
            return volumeRow.getStartPrice();
        }
        return (volumeRow.getEndPrice() + volumeRow.getStartPrice()) / 2.0f;
    }

    public void updatePOC() {
        int n = 0;
        int n2 = (this.rows.a() - 1) / 2;
        int n3 = -1;
        VolumeRow volumeRow = null;
        for (VolumeRow volumeRow2 : this.rows.a()) {
            if (volumeRow == null) {
                volumeRow = volumeRow2;
                n3 = n;
            } else if (volumeRow2.getVolume() > volumeRow.getVolume()) {
                volumeRow = volumeRow2;
                n3 = n;
            } else if (volumeRow2.getVolume() == volumeRow.getVolume() && Math.abs(n - n2) < Math.abs(n3 - n2)) {
                volumeRow = volumeRow2;
                n3 = n;
            }
            ++n;
        }
        this.pocRow = volumeRow;
        this.lastVA = null;
    }

    protected int[] calcLVNs(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = this.rows.a();
        for (int i2 = n + 1; i2 < list.size() - n - 1; ++i2) {
            double d = ((VolumeRow)list.get(i2)).getVolume();
            boolean bl = true;
            for (int i3 = i2 - (n + 1); i3 < i2 + n; ++i3) {
                if (i3 == i2 || !(((VolumeRow)list.get(i3)).getVolume() < d)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(i2);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            nArray[i4] = (Integer)arrayList.get(i4);
        }
        return nArray;
    }

    protected int[] calcHVNs(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = this.rows.a();
        for (int i2 = n + 1; i2 < list.size() - n - 1; ++i2) {
            double d = ((VolumeRow)list.get(i2)).getVolume();
            boolean bl = true;
            for (int i3 = i2 - (n + 1); i3 < i2 + n; ++i3) {
                if (i3 == i2 || !(((VolumeRow)list.get(i3)).getVolume() > d)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(i2);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            nArray[i4] = (Integer)arrayList.get(i4);
        }
        return nArray;
    }

    void setPOC(VolumeRow volumeRow) {
        this.pocRow = volumeRow;
        this.lastVA = null;
    }
}

