/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.profile;

import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.profile.TPOCell;
import com.motivewave.platform.sdk.profile.TPOProfile;
import java.util.ArrayList;
import java.util.List;

public class TPORow {
    private TPOProfile profile;
    private float startPrice;
    private float endPrice;
    private double volume = 0.0;
    private double askVolume = 0.0;
    private double bidVolume = 0.0;
    private List cells = new ArrayList();

    TPORow(TPOProfile tPOProfile, float f2, float f3) {
        this.profile = tPOProfile;
        this.startPrice = f2;
        this.endPrice = f3;
    }

    public boolean isPOC() {
        return this.profile.getPOC() == this;
    }

    public TPOProfile getProfile() {
        return this.profile;
    }

    public float getStartPrice() {
        return this.startPrice;
    }

    public float getEndPrice() {
        return this.endPrice;
    }

    public boolean contains(float f2) {
        return f2 >= this.startPrice && f2 < this.endPrice;
    }

    public float getRowPrice() {
        if (this.profile.getRangeTicks() == 1) {
            return this.startPrice;
        }
        return this.profile.getInstrument().round((this.startPrice + this.endPrice) / 2.0f);
    }

    void onTick(Tick tick) {
        float f2;
        ArrayList<TPOCell> arrayList = this.cells;
        TPOCell tPOCell = this.cells.size() > 0 ? (TPOCell)this.cells.get(this.cells.size() - 1) : null;
        TPOCell tPOCell2 = tPOCell == null || tPOCell.getEndTime() <= tick.getTime() ? null : tPOCell;
        boolean bl = false;
        if (tPOCell2 == null) {
            long l2 = tPOCell == null ? this.profile.getStartTime() : tPOCell.getEndTime();
            int n = (int)((tick.getTime() - this.profile.getLetterStartTime()) / this.profile.getInterval());
            l2 = this.profile.getLetterStartTime() + this.profile.getInterval() * (long)n;
            long l3 = l2 + this.profile.getInterval();
            while (l3 <= tick.getTime()) {
                l2 = l3;
                l3 = l2 + this.profile.getInterval();
            }
            String string = this.profile.getLetter(tick.getTime());
            tPOCell2 = new TPOCell(this, l2, l3, string);
            this.profile.registerLetter(string, tPOCell2);
            if (!this.profile.getInstrument().isInsideTradingHours(tick.getTime(), true)) {
                tPOCell2.setETH(true);
            }
            arrayList = new ArrayList<TPOCell>(this.cells);
            arrayList.add(tPOCell2);
            this.cells = arrayList;
            if (this.cells.size() >= this.profile.getMaxCells()) {
                bl = true;
                this.profile.updateMaxCells(this);
            }
        }
        if ((f2 = tick.getVolumeAsFloat()) <= 0.0f) {
            f2 = 1.0f;
        }
        this.volume += (double)f2;
        if (tick.isAskTick()) {
            this.askVolume += (double)f2;
        } else {
            this.bidVolume += (double)f2;
        }
        TPOCell tPOCell3 = this.profile.lastCell;
        if (tPOCell3 != null && h.a((Object)tPOCell3.getLetter(), (Object)tPOCell2.getLetter())) {
            tPOCell3.setClose(false);
        }
        tPOCell2.setClose(true);
        this.profile.lastCell = tPOCell2;
        if (!this.profile.isPOCVolume()) {
            if (bl) {
                this.profile.setPOC(null);
            }
            return;
        }
        TPORow tPORow = this.profile.getPOC();
        if (tPORow == this) {
            return;
        }
        if (tPORow == null || tPORow.getVolume() < this.volume) {
            this.profile.setPOC(this);
        }
    }

    long resetIncomplete(long l2) {
        TPOCell tPOCell;
        ArrayList arrayList = this.cells;
        TPOCell tPOCell2 = tPOCell = arrayList.size() == 0 ? null : (TPOCell)arrayList.get(arrayList.size() - 1);
        if (tPOCell != null && tPOCell.getEndTime() > l2) {
            arrayList = new ArrayList(this.cells);
            arrayList.remove(tPOCell);
            tPOCell = arrayList.size() == 0 ? null : (TPOCell)arrayList.get(arrayList.size() - 1);
            this.cells = arrayList;
        }
        return tPOCell == null ? this.profile.getStartTime() : tPOCell.getEndTime();
    }

    public double getVolume() {
        return this.volume;
    }

    public double getAskVolume() {
        return this.askVolume;
    }

    public double getBidVolume() {
        return this.bidVolume;
    }

    public double getDelta() {
        return this.askVolume - this.bidVolume;
    }

    public List getCells() {
        return this.cells;
    }

    public int getCellCount() {
        return this.cells.size();
    }
}

