/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.profile;

import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.profile.VolumeProfile;
import com.motivewave.platform.sdk.profile.VolumeRow;
import java.util.List;

public class SummaryProfile
extends VolumeProfile {
    public SummaryProfile(long l2, long l3, Instrument instrument, int n) {
        super(l2, l3, instrument, n);
    }

    @Override
    public boolean isSummary() {
        return true;
    }

    public void populate(List list) {
        for (VolumeProfile volumeProfile : list) {
            if (volumeProfile.getStartTime() < this.getStartTime() || volumeProfile.getStartTime() >= this.getEndTime()) continue;
            for (VolumeRow volumeRow : volumeProfile.getRows()) {
                VolumeRow volumeRow2 = this.findOrCreate(volumeRow.getStartPrice());
                volumeRow2.addFrom(volumeRow);
            }
            this.totalVolume += volumeProfile.totalVolume;
            this.totalAskVolume += volumeProfile.totalAskVolume;
            this.totalBidVolume += volumeProfile.totalBidVolume;
            if (this.openPrice == 0.0f) {
                this.openPrice = volumeProfile.openPrice;
                this.lowPrice = volumeProfile.lowPrice;
                this.highPrice = volumeProfile.highPrice;
            }
            if (volumeProfile.lowPrice < this.lowPrice) {
                this.lowPrice = volumeProfile.lowPrice;
            }
            if (volumeProfile.highPrice > this.highPrice) {
                this.highPrice = volumeProfile.highPrice;
            }
            this.lastPrice = volumeProfile.lastPrice;
            if (volumeProfile.getMaxDelta() > this.maxDelta) {
                this.maxDelta = volumeProfile.getMaxDelta();
            }
            if (!(volumeProfile.getMinDelta() < this.minDelta)) continue;
            this.minDelta = volumeProfile.getMinDelta();
        }
        this.updatePOC();
    }
}

