/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.profile;

import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TickOperation;

public abstract class Profile
implements TickOperation {
    protected Instrument instrument;
    protected long startTime;
    protected long endTime;
    protected int rangeTicks;
    protected float openPrice;
    protected float highPrice;
    protected float lowPrice;
    protected float lastPrice;
    protected double totalVolume;
    protected Tick firstTick;
    protected Tick lastTick;

    protected Profile(long l2, long l3, Instrument instrument, int n) {
        this.startTime = l2;
        this.endTime = l3;
        this.instrument = instrument;
        this.rangeTicks = n;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l2) {
        this.endTime = l2;
    }

    public int getRangeTicks() {
        return this.rangeTicks;
    }

    public float getLastPrice() {
        return this.lastPrice;
    }

    public float getOpenPrice() {
        return this.openPrice;
    }

    public float getHighPrice() {
        return this.highPrice;
    }

    public float getLowPrice() {
        return this.lowPrice;
    }

    public float getMidPrice() {
        return this.instrument.round((this.getHighPrice() + this.getLowPrice()) / 2.0f);
    }

    public double getTotalVolume() {
        return this.totalVolume;
    }

    public long getFirstTime() {
        return this.firstTick == null ? this.getStartTime() : this.firstTick.getTime();
    }

    public long getLastTime() {
        return this.lastTick == null ? this.getEndTime() : this.lastTick.getTime();
    }

    public Tick getLastTick() {
        return this.lastTick;
    }

    public Tick getFirstTick() {
        return this.firstTick;
    }

    @Override
    public abstract void onTick(Tick var1);
}

