/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.order_mgmt;

import bo.a;
import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.Enums$ExecutionType;
import com.motivewave.platform.sdk.common.Enums$OrderAction;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.Order;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.service.bs;

public class Execution {
    private String accountId;
    private String id;
    private Instrument instrument;
    private Object referenceId;
    private long time;
    private Enums$OrderAction action;
    private float quantity;
    private float entryPrice;
    private float avgPrice;
    private Enums$ExecutionType type;
    private double pnl;
    private float pips;
    private double commission;
    private float position;
    private int bar = 0;
    private float maxPriceReached;
    private float minPriceReached;

    public Execution(OrderContext orderContext, Order order, boolean bl) {
        this.accountId = order.getAccountId();
        this.id = order.getOrderId();
        this.instrument = order.getInstrument();
        this.time = order.getLastFillTime();
        this.action = order.isBuy() ? Enums$OrderAction.BUY : Enums$OrderAction.SELL;
        this.entryPrice = this.avgPrice = order.getAvgFillPrice();
        this.quantity = order.getFilledAsFloat();
        if (bl) {
            this.commission = this.instrument.calcCommission(this.quantity);
        }
        this.pnl = 0.0;
        this.pips = 0.0f;
        this.bar = ((a)orderContext).a();
        this.maxPriceReached = ((a)orderContext).a();
        this.minPriceReached = ((a)orderContext).b();
        float f2 = orderContext.getPositionAsFloat();
        if (f2 > 0.0f && order.isBuy()) {
            this.type = Enums$ExecutionType.ENTRY;
            this.position = f2 + this.quantity;
        } else if (f2 < 0.0f && order.isSell()) {
            this.type = Enums$ExecutionType.ENTRY;
            this.position = f2 - this.quantity;
        } else if (f2 == 0.0f) {
            this.type = Enums$ExecutionType.ENTRY;
            this.position = order.isBuy() ? this.quantity : -1.0f * this.quantity;
        } else {
            float f3 = Math.abs(order.getFilledAsFloat());
            this.entryPrice = orderContext.getAvgEntryPrice();
            if (f3 <= Math.abs(f2)) {
                this.type = Enums$ExecutionType.EXIT;
                this.pnl = orderContext.calcPnl(this.entryPrice, this.avgPrice, order.isBuy() ? -1.0f * f3 : f3);
            } else {
                this.type = Enums$ExecutionType.SAR;
                this.pnl = orderContext.calcPnl(this.entryPrice, this.avgPrice, f2);
            }
            this.pips = (this.avgPrice - this.entryPrice) / (float)this.instrument.getPointSize();
            if (order.isBuy()) {
                this.pips *= -1.0f;
                this.position = f2 + f3;
            } else {
                this.position = f2 - f3;
            }
        }
    }

    public Execution(String string, String string2, Instrument instrument, Object object, long l2, Enums$OrderAction enums$OrderAction, float f2, float f3, float f4, Enums$ExecutionType enums$ExecutionType, float f5, float f6, float f7, float f8, int n, float f9, float f10) {
        this.accountId = string;
        this.id = string2;
        this.instrument = instrument;
        this.referenceId = object;
        this.time = l2;
        this.action = enums$OrderAction;
        this.quantity = f2;
        this.avgPrice = f3;
        this.entryPrice = f4;
        this.type = enums$ExecutionType;
        this.pnl = f5;
        this.pips = f5;
        this.commission = f7;
        this.position = f8;
        this.bar = n;
        this.maxPriceReached = f9;
        this.minPriceReached = f10;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getId() {
        return this.id;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public Object getReferenceId() {
        return this.referenceId;
    }

    public long getTime() {
        return this.time;
    }

    public Enums$OrderAction getAction() {
        return this.action;
    }

    public int getQuantity() {
        return (int)this.quantity;
    }

    public float getQuantityAsFloat() {
        return this.quantity;
    }

    public float getAvgPrice() {
        return this.avgPrice;
    }

    public float getEntryPrice() {
        return this.entryPrice;
    }

    public Enums$ExecutionType getType() {
        return this.type;
    }

    public double getPnl() {
        return this.pnl;
    }

    public double getCommission() {
        return this.commission;
    }

    public double getNetPnl() {
        return this.getPnl() - this.getCommission();
    }

    public float getPips() {
        return this.pips;
    }

    public int getPosition() {
        return (int)this.position;
    }

    public float getPositionAsFloat() {
        return this.position;
    }

    public int getBar() {
        return this.bar;
    }

    public float getMaxPriceReached() {
        return this.maxPriceReached;
    }

    public float getMinPriceReached() {
        return this.minPriceReached;
    }

    public String toString() {
        return "Execution: " + h.l((long)this.time) + " " + this.instrument.getSymbol() + " " + String.valueOf((Object)this.action) + " qty: " + this.quantity + " price: " + this.instrument.format(this.avgPrice) + " type: " + String.valueOf((Object)this.type) + " pnl: " + h.a((double)this.pnl, (String)bs.b());
    }
}

