/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.m;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.themes.ChartTheme;
import com.motivewave.platform.sdk.common.Enums$TextAlign;
import com.motivewave.platform.sdk.common.Enums$TextOutline;
import com.motivewave.platform.sdk.common.TextStyle;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.draw.Text$TextLine;
import com.motivewave.platform.sdk.draw.Text$TextModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Text
implements Cloneable {
    private Image image;
    private Text$TextModel model = new Text$TextModel();
    private Font displayFont = null;
    private Rectangle2D bounds = null;
    private Point2D handle = null;
    private boolean visible = true;
    private List textLines = null;
    private Insets insets = null;
    private int lastWidth = -1;
    private int textWidth = -1;
    private int textHeight = -1;
    private int maxWidth = -1;
    private int maxLines = -1;
    private Shape outline = null;
    private double angle = 0.0;
    private boolean highlighted = false;

    public Text() {
        this.setFont(o.x().deriveFont(10));
        this.model.setShowOutline(false);
        this.model.setShowBorder(false);
    }

    public Text(String string) {
        this.setFont(o.x().deriveFont(10));
        this.model.setShowOutline(false);
        this.model.setShowBorder(false);
        this.model.setText(string);
        int n = Util.isEmpty(string) ? 0 : (int)UIUtil.a((String)string, (Font)this.model.getFont());
        this.layout(n);
        this.compact();
    }

    public Text(String string, TextStyle textStyle) {
        this.setFont(textStyle.getFont() == null ? o.x().deriveFont(10) : textStyle.getFont());
        this.model.setForeground(textStyle.getColor());
        this.model.setBackground(textStyle.getBgColor());
        this.model.setShowOutline(false);
        this.model.setShowBorder(false);
        this.model.setText(string);
        double d = textStyle.strWidth(string);
        this.layout((int)d);
        this.compact();
    }

    public Text(String string, Font font) {
        this(string, font, null, false);
    }

    public Text(String string, Font font, Insets insets, boolean bl) {
        this.setText(string);
        this.setFont(font);
        this.model.setShowOutline(bl);
        this.model.setShowBorder(bl);
        this.insets = insets;
        int n = (int)UIUtil.a((String)string, (Font)font);
        if (insets != null) {
            n += insets.left + insets.right;
        }
        this.layout(n);
        this.compact();
    }

    public void destroy() {
        this.model = null;
        this.textLines = null;
        this.outline = null;
        this.bounds = null;
        this.displayFont = null;
    }

    public void draw(Graphics2D graphics2D) {
        Object object;
        Rectangle2D rectangle2D = this.bounds;
        ArrayList arrayList = this.textLines;
        Text$TextModel text$TextModel = this.model;
        if (rectangle2D == null || arrayList == null || text$TextModel == null || !this.visible) {
            return;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getX() + rectangle2D.getWidth();
        double d4 = rectangle2D.getY();
        if (this.angle != 0.0) {
            graphics2D = (Graphics2D)graphics2D.create();
            object = new AffineTransform();
            ((AffineTransform)object).setToTranslation(rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
            graphics2D.transform((AffineTransform)object);
            ((AffineTransform)object).setToRotation(this.angle);
            graphics2D.transform((AffineTransform)object);
        }
        object = this.getOutline();
        if (text$TextModel.isShowOutline() && object != null) {
            if (text$TextModel.getBGColor1() != null && text$TextModel.getBGColor2() != null) {
                graphics2D.setPaint(new GradientPaint((int)this.getX(), (int)this.getY(), text$TextModel.getBGColor1(), (int)this.getMaxX(), (int)this.getMaxY(), text$TextModel.getBGColor2()));
            } else if (text$TextModel.getBackground() != null) {
                graphics2D.setColor(text$TextModel.getBackground());
            } else {
                graphics2D.setColor(ChartTheme.getTheme().TEXT_BACKGROUND);
            }
            graphics2D.fill((Shape)object);
            if (text$TextModel.isShowBorder()) {
                graphics2D.setColor(text$TextModel.getBorderColor() == null ? ChartTheme.getTheme().TEXT_BORDER : text$TextModel.getBorderColor());
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(Text.highlight(text$TextModel.getBorderStroke(), this.highlighted));
                graphics2D.draw((Shape)object);
                graphics2D.setStroke(stroke);
            }
        }
        double d5 = rectangle2D.getHeight();
        if (this.insets != null) {
            d += (double)this.insets.left;
            d2 += (double)this.insets.left;
            d3 -= (double)this.insets.right;
            d4 += (double)this.insets.top;
            d5 -= (double)(this.insets.top + this.insets.bottom);
        }
        if (this.image != null) {
            graphics2D.drawImage(this.image, (int)d, (int)(d4 + (d5 - (double)this.image.getHeight(null)) / 2.0), null);
            d2 += (double)(this.image.getWidth(null) + 2);
        }
        if (text$TextModel.getForeground() == null) {
            graphics2D.setColor(ChartTheme.getTheme().TEXT_FOREGROUND);
        } else {
            graphics2D.setColor(text$TextModel.getForeground());
        }
        Font font = this.getDisplayFont();
        if (this.highlighted && !font.isBold()) {
            font = font.deriveFont(font.getStyle() | 1);
        }
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (Util.isEmpty(arrayList)) {
            return;
        }
        if (arrayList.size() == 1) {
            double d6 = d2;
            String string = ((Text$TextLine)arrayList.get(0)).getText();
            if (text$TextModel.getHAlign() == Enums$TextAlign.FULL) {
                double d7 = d3 - d2;
                this.drawJustified(graphics2D, string, Util.toInt(d6), Util.toInt(d4 + 1.0), (int)d7);
                return;
            }
            if (text$TextModel.getHAlign() == Enums$TextAlign.RIGHT) {
                d6 = d3 - UIUtil.a((String)string, (Font)font);
            } else if (text$TextModel.getHAlign() == Enums$TextAlign.HCENTER) {
                double d8 = d3 - d2;
                d6 += (d8 - UIUtil.a((String)string, (Font)font)) / 2.0;
            }
            if (this.angle != 0.0) {
                graphics2D.drawString(string, 0, 2);
            } else {
                graphics2D.drawString(string, Util.toInt(d6), Util.toInt(d4 + (double)fontMetrics.getAscent()) + 1);
            }
        } else {
            arrayList = new ArrayList(arrayList);
            if (this.maxLines > 0) {
                while (arrayList.size() > this.maxLines) {
                    arrayList.removeLast();
                }
            }
            d4 += (double)fontMetrics.getAscent();
            for (Text$TextLine text$TextLine : arrayList) {
                double d9;
                TextLayout textLayout = text$TextLine.getLayout();
                if (textLayout == null) continue;
                double d10 = textLayout.getVisibleAdvance();
                double d11 = d2;
                if (text$TextModel.getHAlign() == Enums$TextAlign.FULL) {
                    d9 = d3 - d2;
                    this.drawJustified(graphics2D, text$TextLine.getText(), Util.toInt(d11), Util.toInt(d4 + 1.0), (int)d9);
                    d4 += (double)fontMetrics.getHeight();
                    continue;
                }
                if (text$TextModel.getHAlign() == Enums$TextAlign.RIGHT) {
                    d11 = d3 - d10;
                } else if (text$TextModel.getHAlign() == Enums$TextAlign.HCENTER) {
                    d9 = d3 - d2;
                    d11 += (d9 - d10) / 2.0;
                }
                if (this.angle != 0.0) {
                    graphics2D.drawString(text$TextLine.getText(), 0, 0);
                } else {
                    graphics2D.drawString(text$TextLine.getText(), Util.toInt(d11), Util.toInt(d4 + 1.0));
                }
                d4 += (double)fontMetrics.getHeight();
            }
        }
    }

    private void drawJustified(Graphics2D graphics2D, String string, int n, int n2, int n3) {
        int n4;
        Font font = graphics2D.getFont();
        String[] stringArray = string.split(" ");
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (stringArray.length == 1) {
            graphics2D.drawString(string, n, n2);
            return;
        }
        int n5 = 0;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n5 = (int)((double)n5 + UIUtil.a((String)stringArray[n4], (Font)font));
        }
        n4 = n3 - n5;
        if (n4 <= 0) {
            graphics2D.drawString(string, n, n2);
            return;
        }
        double d = n4 / (stringArray.length - 1);
        for (String string2 : stringArray) {
            int n6 = (int)UIUtil.a((String)string2, (Font)font);
            graphics2D.drawString(string2, n, n2);
            n = (int)((double)n + ((double)n6 + d));
        }
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
    }

    public String getText() {
        return this.model.getText();
    }

    public void setText(String string) {
        this.model.setText(string);
        this.textLines = null;
        this.lastWidth = -1;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.model.setFont(font);
        this.textLines = null;
        this.lastWidth = -1;
    }

    public Font getFont() {
        return this.model.getFont();
    }

    public void setBorderColor(Color color) {
        this.model.setBorderColor(color);
    }

    public Color getBorderColor() {
        return this.model.getBorderColor();
    }

    public void setBorderStroke(BasicStroke basicStroke) {
        this.model.setBorderStroke(basicStroke);
    }

    public void setShowOutline(boolean bl) {
        this.model.setShowOutline(bl);
    }

    public boolean isShowOutline() {
        return this.model.isShowOutline();
    }

    public void setShowBorder(boolean bl) {
        this.model.setShowBorder(bl);
    }

    public boolean isShowBorder() {
        return this.model.isShowBorder();
    }

    public void setBackground(Color color) {
        this.model.setBackground(color);
    }

    public Color getBackground() {
        return this.model.getBackground();
    }

    public void setBGColor1(Color color) {
        this.model.setBGColor1(color);
    }

    public Color getBGColor1() {
        return this.model.getBGColor1();
    }

    public void setBGColor2(Color color) {
        this.model.setBGColor2(color);
    }

    public Color getBGColor2() {
        return this.model.getBGColor2();
    }

    public void setTextColor(Color color) {
        this.model.setForeground(color);
    }

    public Color getTextColor() {
        return this.model.getForeground();
    }

    public void setHAlign(Enums$TextAlign enums$TextAlign) {
        this.model.setHAlign(enums$TextAlign);
    }

    public void setVAlign(Enums$TextAlign enums$TextAlign) {
        this.model.setVAlign(enums$TextAlign);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.insets = new Insets(n, n2, n3, n4);
        this.textLines = null;
        this.lastWidth = -1;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setImage(Image image) {
        this.image = image;
        this.updateBounds();
    }

    public Image getImage() {
        return this.image;
    }

    public List getLines() {
        if (this.textLines == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Text$TextLine text$TextLine : this.textLines) {
            arrayList.add(text$TextLine.getText());
        }
        return arrayList;
    }

    public void setDisplayFont(Font font) {
        this.displayFont = font;
    }

    public Font getDisplayFont() {
        if (this.displayFont != null) {
            return this.displayFont;
        }
        Text$TextModel text$TextModel = this.model;
        if (text$TextModel == null) {
            return o.x().deriveFont(10);
        }
        return text$TextModel.getFont();
    }

    public Rectangle2D adjustFont(Font font) {
        if (this.getDisplayFont().equals(font)) {
            return this.bounds;
        }
        int n = 0;
        int n2 = 0;
        this.displayFont = font;
        FontMetrics fontMetrics = Text.getFontMetrics(font);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        if (this.textLines == null) {
            this.layout(200);
        }
        for (Text$TextLine text$TextLine : this.textLines) {
            int n3 = (int)UIUtil.a((String)text$TextLine.getText(), (Font)font);
            if (n3 > n) {
                n = n3;
            }
            n2 += fontMetrics.getHeight();
            text$TextLine.setLayout(new TextLayout(text$TextLine.getText(), font, fontRenderContext));
        }
        this.textWidth = n;
        this.textHeight = n2;
        this.lastWidth = this.textWidth;
        this.updateBounds();
        return this.bounds;
    }

    public void layout() {
        if (Util.isEmpty(this.model.getText())) {
            this.updateBounds();
            return;
        }
        if (this.textWidth == this.lastWidth) {
            return;
        }
        this.layout(this.textWidth, this.getDisplayFont());
        this.lastWidth = this.textWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void layout(int n) {
        this.textWidth = this.maxWidth = n;
        this.layout();
    }

    public void compact() {
        if (Util.isEmpty(this.model.getText()) || this.textLines == null) {
            this.updateBounds();
            return;
        }
        FontMetrics fontMetrics = Text.getFontMetrics(this.getDisplayFont());
        double d = 0.0;
        double d2 = 0.0;
        for (Text$TextLine text$TextLine : this.textLines) {
            int n = (int)UIUtil.a((String)text$TextLine.getText(), (Font)this.getDisplayFont());
            if ((double)n > d) {
                d = n;
            }
            d2 += (double)fontMetrics.getHeight();
        }
        this.updateBounds();
    }

    private void updateBounds() {
        int n = this.textWidth;
        int n2 = this.textHeight;
        if (this.bounds == null) {
            this.bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        if (this.insets != null) {
            n += this.insets.left + this.insets.right;
            n2 += this.insets.top + this.insets.bottom;
        }
        if (this.image != null) {
            n += this.image.getWidth(null) + 2;
            n2 = Math.max(n2, this.image.getHeight(null) + this.insets.top + this.insets.bottom);
        }
        this.bounds.setRect(this.bounds.getX(), this.bounds.getY(), n, n2);
        this.outline = null;
    }

    private void updateOutline() {
        Enums$TextOutline enums$TextOutline = this.model.getOutline();
        Rectangle2D rectangle2D = this.bounds;
        if (enums$TextOutline == null || rectangle2D == null) {
            this.outline = null;
            return;
        }
        switch (enums$TextOutline) {
            case CIRCLE: {
                int n = Math.max((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()) + 1;
                double d = rectangle2D.getCenterX();
                double d2 = rectangle2D.getCenterY();
                double d3 = d - (double)n / 2.0;
                double d4 = d2 - (double)n / 2.0;
                this.outline = new Ellipse2D.Double(d3, d4, n, n);
                break;
            }
            case ROUNDED: {
                this.outline = new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), 8.0, 8.0);
                break;
            }
            case RECTANGLE: {
                this.outline = (Shape)rectangle2D.clone();
                break;
            }
            case BALLOON: {
                this.outline = m.a((Point2D)this.handle, (Rectangle2D)rectangle2D, (boolean)false);
                break;
            }
            case BALLOON_ROUNDED: {
                this.outline = m.a((Point2D)this.handle, (Rectangle2D)rectangle2D, (boolean)true);
                break;
            }
            default: {
                this.outline = null;
            }
        }
    }

    public void layout(int n, Font font) {
        int n2;
        if (n <= 0) {
            return;
        }
        String string = this.getText();
        this.textLines = new ArrayList();
        if (Util.isEmpty(string)) {
            this.updateBounds();
            return;
        }
        FontMetrics fontMetrics = Text.getFontMetrics(font);
        if (string.indexOf(10) < 0 && string.indexOf(13) < 0 && (n2 = (int)UIUtil.a((String)string, (Font)font)) <= n) {
            if (this.textLines == null) {
                this.textLines = new ArrayList();
            }
            this.textLines.add(new Text$TextLine(string, null, n2));
            this.textWidth = n2;
            this.textHeight = fontMetrics.getHeight();
            this.updateBounds();
            return;
        }
        String[] stringArray = string.split("\r\n|\r|\n");
        int n3 = 0;
        double d = 0.0;
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        for (String string2 : stringArray) {
            if (this.maxLines > 0 && this.textLines.size() >= this.maxLines) break;
            if (Util.isEmpty(string2)) {
                this.textLines.add(new Text$TextLine(" ", new TextLayout(" ", font, fontRenderContext), 0));
                n3 += fontMetrics.getHeight();
                continue;
            }
            AttributedString attributedString = new AttributedString(string2);
            attributedString.addAttribute(TextAttribute.FONT, font);
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
            lineBreakMeasurer.setPosition(attributedCharacterIterator.getBeginIndex());
            int n4 = attributedCharacterIterator.getEndIndex();
            int n5 = 0;
            while (lineBreakMeasurer.getPosition() < n4 && (this.maxLines <= 0 || this.textLines.size() < this.maxLines) && n5++ <= 1000) {
                int n6 = lineBreakMeasurer.getPosition();
                TextLayout textLayout = lineBreakMeasurer.nextLayout(n);
                String string3 = string2.substring(n6, lineBreakMeasurer.getPosition());
                n3 += fontMetrics.getHeight();
                int n7 = (int)UIUtil.a((String)string3, (Font)font);
                if ((double)n7 > d) {
                    d = n7;
                }
                this.textLines.add(new Text$TextLine(string3, textLayout, n7));
            }
        }
        this.textWidth = (int)Math.ceil(d);
        this.textHeight = (int)Math.ceil(n3);
        this.updateBounds();
    }

    public boolean contains(double d, double d2) {
        if (this.bounds == null) {
            return false;
        }
        return this.bounds.contains(d, d2);
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.updateOutline();
        }
        return this.outline;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.bounds = new Rectangle2D.Double(d, d2, d3, d4);
        this.textWidth = (int)Math.ceil(d3);
        if (this.insets != null) {
            this.textWidth -= this.insets.left + this.insets.right;
        }
    }

    public Stroke getBorderStroke() {
        return this.model.getBorderStroke();
    }

    public void setBorderStroke(Stroke stroke) {
        this.model.setBorderStroke((BasicStroke)stroke);
    }

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public void setLocation(double d, double d2) {
        this.bounds.setRect(d, d2, this.bounds.getWidth(), this.bounds.getHeight());
        this.outline = null;
    }

    public void setCenter(Point2D point2D) {
        this.setCenter(point2D.getX(), point2D.getY());
    }

    public void setCenter(double d, double d2) {
        this.setLocation(d - this.bounds.getWidth() / 2.0, d2 - this.bounds.getHeight() / 2.0);
    }

    public void setHandle(Point2D point2D) {
        this.handle = point2D;
    }

    public Point2D getHandle() {
        return this.getHandle();
    }

    public double getY() {
        return this.bounds.getY();
    }

    public double getX() {
        return this.bounds.getX();
    }

    public double getHeight() {
        return this.bounds.getHeight();
    }

    public double getWidth() {
        return this.bounds.getWidth();
    }

    public double getMaxY() {
        return this.bounds.getMaxY();
    }

    public double getMaxX() {
        return this.bounds.getMaxX();
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.bounds.getCenterX(), this.bounds.getCenterY());
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.bounds.getX(), this.bounds.getY());
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setOutline(Enums$TextOutline enums$TextOutline) {
        this.model.setOutline(enums$TextOutline);
        this.updateBounds();
    }

    public Text clone() {
        try {
            Text text = (Text)super.clone();
            text.model = this.model.clone();
            if (this.textLines != null) {
                text.textLines = new ArrayList(this.textLines);
            }
            if (this.insets != null) {
                text.insets = (Insets)this.insets.clone();
            }
            text.bounds = (Rectangle2D)this.bounds.clone();
            text.textWidth = this.textWidth;
            text.textHeight = this.textHeight;
            text.image = this.image;
            return text;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static Stroke highlight(Stroke stroke) {
        return Text.highlight(stroke, true);
    }

    static Stroke highlight(Stroke stroke, boolean bl) {
        if (!bl) {
            return stroke;
        }
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        return new BasicStroke(basicStroke.getLineWidth() + 1.0f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
    }

    static FontMetrics getFontMetrics(Font font) {
        return UIUtil.a((Font)font);
    }
}

