/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.Enums$Position;
import com.motivewave.platform.sdk.common.Enums$StackPolicy;
import com.motivewave.platform.sdk.draw.Figure;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SinglePointFigure
extends Figure {
    private Coordinate location;
    private Enums$Position position = Enums$Position.CENTER;
    private Enums$StackPolicy stackPolicy = null;
    private Point2D graphLocation;
    private int offsetPixels = 0;

    @Override
    public boolean contains(double d, double d2, DrawContext drawContext) {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D == null) {
            return false;
        }
        if (this.getGraphLocation() != null) {
            Point2D point2D = this.getGraphLocation();
            if (point2D == null) {
                return false;
            }
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX() + point2D.getX(), rectangle2D.getY() + point2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            return rectangle2D.contains(d, d2);
        }
        return rectangle2D.contains(d, d2);
    }

    @Override
    public boolean isVisible(DrawContext drawContext) {
        if (this.location == null) {
            return false;
        }
        DataSeries dataSeries = drawContext.getDataContext().getDataSeries();
        long l2 = this.location.getTime();
        if (l2 < dataSeries.getVisibleStartTime()) {
            return false;
        }
        if (dataSeries.isLatestData()) {
            return true;
        }
        return l2 <= dataSeries.getVisibleEndTime();
    }

    public Coordinate getLocation() {
        return this.location;
    }

    public void setLocation(Coordinate coordinate) {
        this.location = coordinate;
    }

    public void setLocation(long l2, double d) {
        this.location = new Coordinate(l2, d);
    }

    public long getTime() {
        return this.location == null ? 0L : this.location.getTime();
    }

    public double getValue() {
        return this.location == null ? 0.0 : this.location.getValue();
    }

    public Enums$Position getPosition() {
        return this.position;
    }

    public void setPosition(Enums$Position enums$Position) {
        this.position = enums$Position;
    }

    public void setStackPolicy(Enums$StackPolicy enums$StackPolicy) {
        this.stackPolicy = enums$StackPolicy;
    }

    public Enums$StackPolicy getStackPolicy() {
        return this.stackPolicy;
    }

    public void setGraphLocation(Point2D point2D) {
        if (this.offsetPixels != 0) {
            switch (this.position) {
                case BOTTOM: {
                    point2D = new Point2D.Double(point2D.getX(), point2D.getY() + (double)this.offsetPixels);
                    break;
                }
                case TOP: {
                    point2D = new Point2D.Double(point2D.getX(), point2D.getY() - (double)this.offsetPixels);
                    break;
                }
                case LEFT: {
                    point2D = new Point2D.Double(point2D.getX() + (double)this.offsetPixels, point2D.getY());
                    break;
                }
                case RIGHT: {
                    point2D = new Point2D.Double(point2D.getX() - (double)this.offsetPixels, point2D.getY());
                    break;
                }
                case CENTER: {
                    break;
                }
            }
        }
        this.graphLocation = point2D;
    }

    public Point2D getGraphLocation() {
        return this.graphLocation;
    }

    public void setOffsetPixels(int n) {
        this.offsetPixels = n;
    }

    public int getOffsetPixels() {
        return this.offsetPixels;
    }
}

