/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.common.p;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.ui.util.FXGraphics2D;
import com.motivewave.platform.common.themes.Colors;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.Enums$ResizeType;
import com.motivewave.platform.sdk.draw.Figure;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ResizePoint
extends Figure {
    private Color fillColor;
    private Color outlineColor;
    private Point2D graphLocation;
    private Coordinate location;
    private Enums$ResizeType type;
    private boolean snapToLocation = false;
    private boolean absolute = false;

    public ResizePoint(Enums$ResizeType enums$ResizeType) {
        this(enums$ResizeType, false);
    }

    public ResizePoint(Enums$ResizeType enums$ResizeType, boolean bl) {
        this.type = enums$ResizeType;
        this.absolute = bl;
        this.outlineColor = p.GRAY;
    }

    @Override
    public void layout(DrawContext drawContext) {
        Point2D point2D;
        if (this.isAbsolute() && this.location != null) {
            this.graphLocation = drawContext.translate(this.location);
        }
        if ((point2D = this.graphLocation) == null) {
            return;
        }
        this.setBounds(new Rectangle((int)point2D.getX() - 8, (int)point2D.getY() - 8, 16, 16));
    }

    @Override
    public boolean contains(double d, double d2, DrawContext drawContext) {
        Rectangle2D rectangle2D = this.getBounds();
        return rectangle2D == null ? false : rectangle2D.contains(d, d2);
    }

    public Enums$ResizeType getType() {
        return this.type;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setGraphLocation(Point2D point2D) {
        this.graphLocation = point2D;
    }

    public Point2D getGraphLocation() {
        return this.graphLocation;
    }

    public boolean isSnapToLocation() {
        return this.snapToLocation;
    }

    public void setSnapToLocation(boolean bl) {
        this.snapToLocation = bl;
    }

    public Coordinate getLocation() {
        return this.location;
    }

    public void setLocation(Coordinate coordinate) {
        this.location = coordinate;
    }

    public void setLocation(long l2, double d) {
        this.location = new Coordinate(l2, d);
    }

    public long getTime() {
        return this.location == null ? 0L : this.location.getTime();
    }

    public double getValue() {
        return this.location == null ? 0.0 : this.location.getValue();
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public void draw(Graphics2D graphics2D, DrawContext drawContext) {
        Point2D point2D = this.graphLocation;
        if (point2D == null) {
            return;
        }
        boolean bl = drawContext.getDefaults().isDarkTheme();
        Color color = this.fillColor;
        if (this.type != null && color == null) {
            switch (this.type) {
                case HORIZONTAL: 
                case VERTICAL: {
                    color = bl ? Colors.yellow : Colors.dark_yellow;
                    break;
                }
                case ALL: {
                    color = Colors.resizeBlue((boolean)bl);
                }
            }
        }
        if (color == null) {
            color = Colors.resizeBlue((boolean)bl);
        }
        double d = this.getBounds().getWidth();
        double d2 = d * 0.6;
        double d3 = point2D.getX() - d / 2.0;
        double d4 = point2D.getY() - d / 2.0;
        FXGraphics2D fXGraphics2D = (FXGraphics2D)graphics2D;
        fXGraphics2D.setColor(UIUtil.a((Color)color, (int)80));
        fXGraphics2D.e(d3, d4, d, d);
        fXGraphics2D.setColor(UIUtil.a((Color)color, (int)200));
        fXGraphics2D.e(d3 + (d - d2) / 2.0, d4 + (d - d2) / 2.0, d2, d2);
    }
}

