/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.platform.common.an;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.draw.Figure;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Polygon
extends Figure {
    private List points;
    private java.awt.Polygon polygon;
    private Color lineColor = null;
    private Color fillColor = null;
    private Stroke stroke = an.SOLID_LINE;
    private boolean showOutline = true;
    private boolean showFill = true;
    private long startTime;
    private long endTime;

    public Polygon(Coordinate coordinate, Coordinate coordinate2, Coordinate ... coordinateArray) {
        this.points = new ArrayList();
        this.points.add(coordinate);
        this.points.add(coordinate2);
        for (Coordinate coordinate3 : coordinateArray) {
            this.points.add(coordinate3);
        }
        this.startTime = coordinate.getTime();
        this.endTime = coordinate.getTime();
        for (Coordinate coordinate4 : this.points) {
            if (coordinate4.getTime() < this.startTime) {
                this.startTime = coordinate4.getTime();
            }
            if (coordinate4.getTime() <= this.endTime) continue;
            this.endTime = coordinate4.getTime();
        }
    }

    public void setShowOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean isShowOutline() {
        return this.showOutline;
    }

    public void setShowFill(boolean bl) {
        this.showFill = bl;
    }

    public boolean isShowFill() {
        return this.showFill;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public boolean isVisible(DrawContext drawContext) {
        long l2 = this.endTime;
        DataSeries dataSeries = drawContext.getDataContext().getDataSeries();
        if (l2 < dataSeries.getVisibleStartTime()) {
            return false;
        }
        if (dataSeries.isLatestData()) {
            return true;
        }
        long l3 = this.startTime;
        return l3 <= dataSeries.getVisibleEndTime();
    }

    @Override
    public boolean contains(double d, double d2, DrawContext drawContext) {
        if (this.polygon == null) {
            return false;
        }
        return this.polygon.contains(d, d2);
    }

    @Override
    public void layout(DrawContext drawContext) {
        java.awt.Polygon polygon = new java.awt.Polygon();
        for (Coordinate coordinate : this.points) {
            Point2D point2D = drawContext.translate(coordinate.getTime(), coordinate.getValue());
            polygon.addPoint((int)point2D.getX(), (int)point2D.getY());
        }
        this.polygon = polygon;
    }

    @Override
    public void draw(Graphics2D graphics2D, DrawContext drawContext) {
        java.awt.Polygon polygon = this.polygon;
        if (polygon == null) {
            return;
        }
        if (this.fillColor != null && this.showFill) {
            graphics2D.setColor(this.fillColor);
            graphics2D.fill(polygon);
        }
        if (this.stroke != null && this.showOutline) {
            Color color = this.lineColor == null ? drawContext.getDefaults().getLineColor() : this.lineColor;
            graphics2D.setColor(color);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(polygon);
        }
    }
}

