/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.common.h;
import com.motivewave.platform.common.o;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.Enums$MarkerType;
import com.motivewave.platform.sdk.common.Enums$Position;
import com.motivewave.platform.sdk.common.Enums$Size;
import com.motivewave.platform.sdk.common.Enums$TextOutline;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.draw.SinglePointFigure;
import com.motivewave.platform.sdk.draw.Text;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class Marker
extends SinglePointFigure {
    private Color fillColor;
    private Color outlineColor;
    private boolean fillColorSet = false;
    private boolean outlineColorSet = false;
    private Enums$Size size = Enums$Size.SMALL;
    private Enums$MarkerType type;
    private Shape outline;
    private Text label;
    private Text text;
    private Enums$Position textPosition = Enums$Position.BOTTOM;
    private static Stroke LINE_NORMAL = new BasicStroke(1.0f);
    private static Stroke LINE_SELECTED = new BasicStroke(2.0f);
    private static Stroke THICK_LINE = new BasicStroke(3.0f);
    private static Stroke MED_LINE = new BasicStroke(2.0f);

    public Marker(Coordinate coordinate, Enums$MarkerType enums$MarkerType) {
        this(coordinate, enums$MarkerType, Enums$Size.SMALL, Enums$Position.CENTER, null, null);
        this.fillColorSet = false;
        this.outlineColorSet = false;
    }

    public Marker(Coordinate coordinate, Enums$Position enums$Position, MarkerInfo markerInfo) {
        this(coordinate, markerInfo == null ? Enums$MarkerType.TRIANGLE : markerInfo.getType(), markerInfo == null ? Enums$Size.SMALL : markerInfo.getSize(), enums$Position, markerInfo == null ? null : markerInfo.getFillColor(), markerInfo == null ? null : markerInfo.getOutlineColor());
    }

    public Marker(Coordinate coordinate, Enums$Position enums$Position, MarkerInfo markerInfo, String string) {
        this(coordinate, markerInfo == null ? Enums$MarkerType.TRIANGLE : markerInfo.getType(), markerInfo == null ? Enums$Size.SMALL : markerInfo.getSize(), enums$Position, markerInfo == null ? null : markerInfo.getFillColor(), markerInfo == null ? null : markerInfo.getOutlineColor());
        this.setPopupMessage(string);
    }

    public Marker(Coordinate coordinate, Enums$MarkerType enums$MarkerType, Enums$Size enums$Size, Enums$Position enums$Position, Color color, Color color2) {
        this.setLocation(coordinate);
        this.setPosition(enums$Position);
        this.type = enums$MarkerType;
        this.size = enums$Size;
        this.outlineColor = color2;
        this.fillColor = color;
        this.fillColorSet = true;
        this.outlineColorSet = true;
    }

    public Enums$MarkerType getType() {
        return this.type;
    }

    public void setType(Enums$MarkerType enums$MarkerType) {
        this.type = enums$MarkerType;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
        this.outlineColorSet = true;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.fillColorSet = true;
    }

    public Enums$Size getSize() {
        return this.size;
    }

    public void setSize(Enums$Size enums$Size) {
        if (enums$Size == this.size) {
            return;
        }
        this.size = enums$Size;
        this.outline = null;
    }

    @Override
    public void setPosition(Enums$Position enums$Position) {
        if (this.getPosition() == enums$Position) {
            return;
        }
        super.setPosition(enums$Position);
        this.outline = null;
    }

    public void setTextValue(String string) {
        if (this.text == null) {
            this.text = new Text(string);
            this.text.setInsets(2, 2, 2, 2);
            this.text.layout(200);
        } else {
            this.text.setText(string);
            this.text.layout(200);
        }
    }

    public Text getText() {
        if (this.text == null) {
            this.text = new Text();
        }
        return this.text;
    }

    public Enums$Position getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(Enums$Position enums$Position) {
        this.textPosition = enums$Position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D graphics2D, DrawContext drawContext) {
        if (drawContext == null) {
            return;
        }
        Defaults defaults = drawContext.getDefaults();
        if (defaults == null) {
            return;
        }
        Color color = defaults.getTextColor();
        if (!this.fillColorSet && this.fillColor == null) {
            this.fillColor = defaults.getLineColor();
        }
        if (!this.outlineColorSet && this.outlineColor == null) {
            this.outlineColor = defaults.getLineColor();
        }
        int n = 0;
        int n2 = 0;
        if (this.getGraphLocation() != null) {
            n = (int)Math.round(this.getGraphLocation().getX());
            n2 = (int)Math.round(this.getGraphLocation().getY());
        }
        graphics2D.translate(n, n2);
        try {
            Shape shape;
            boolean bl;
            if (this.label != null) {
                boolean bl2 = bl = this.label.getTextColor() != null;
                if (!bl) {
                    this.label.setTextColor(color);
                }
                this.label.draw(graphics2D);
                if (!bl) {
                    this.label.setTextColor(null);
                }
            }
            if (this.text != null && !h.g((String)this.text.getText())) {
                boolean bl3 = bl = this.text.getTextColor() != null;
                if (!bl) {
                    this.text.setTextColor(color);
                }
                this.text.draw(graphics2D);
                if (!bl) {
                    this.text.setTextColor(null);
                }
            }
            if ((shape = this.outline) != null) {
                if (this.type == Enums$MarkerType.LINE_ARROW) {
                    graphics2D.setColor(this.fillColor);
                    switch (this.size) {
                        case VERY_SMALL: {
                            graphics2D.setStroke(drawContext.isSelected() ? LINE_SELECTED : LINE_NORMAL);
                            break;
                        }
                        case SMALL: 
                        case MEDIUM: {
                            graphics2D.setStroke(MED_LINE);
                            break;
                        }
                        case LARGE: 
                        case VERY_LARGE: {
                            graphics2D.setStroke(THICK_LINE);
                            break;
                        }
                    }
                    graphics2D.draw(shape);
                } else {
                    if (this.fillColor != null) {
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fill(shape);
                    }
                    if (this.outlineColor != null) {
                        graphics2D.setStroke(drawContext.isSelected() ? LINE_SELECTED : LINE_NORMAL);
                        graphics2D.setColor(this.outlineColor);
                        graphics2D.draw(shape);
                    }
                }
            }
        }
        finally {
            graphics2D.translate(-n, -n2);
        }
    }

    @Override
    public void layout(DrawContext drawContext) {
        Shape shape;
        if (!this.fillColorSet && this.fillColor == null) {
            this.fillColor = drawContext.getDefaults().getLineColor();
        }
        if (!this.outlineColorSet && this.outlineColor == null) {
            this.outlineColor = drawContext.getDefaults().getLineColor();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        switch (this.size) {
            case VERY_SMALL: {
                n3 = 3;
                break;
            }
            case SMALL: {
                n3 = 4;
                break;
            }
            case MEDIUM: {
                n3 = 6;
                break;
            }
            case LARGE: {
                n3 = 8;
                break;
            }
            case VERY_LARGE: {
                n3 = 10;
                break;
            }
        }
        if (this.type != Enums$MarkerType.PRICE_LABEL && !this.type.isLabel()) {
            this.label = null;
        }
        n3 -= 3;
        switch (this.getPosition()) {
            case TOP: {
                n2 -= n3;
                break;
            }
            case BOTTOM: {
                n2 += n3;
                break;
            }
            case LEFT: {
                n -= n3;
                break;
            }
            case RIGHT: {
                n += n3;
                break;
            }
        }
        if (this.type.isLabel()) {
            this.updateLabel(n, n2);
        } else {
            switch (this.type) {
                case PRICE_LABEL: {
                    this.updatePriceLabel(n, n2, drawContext.getDataContext().getInstrument().format(this.getValue()));
                    break;
                }
                case TRIANGLE: {
                    if (this.outline != null) break;
                    this.createTriangle(n, n2);
                    break;
                }
                case ARROW: {
                    if (this.outline != null) break;
                    this.createArrow(n, n2);
                    break;
                }
                case LINE_ARROW: {
                    if (this.outline != null) break;
                    this.createLineArrow(n, n2);
                    break;
                }
                case CIRCLE: {
                    if (this.outline != null) break;
                    if (this.size == Enums$Size.VERY_SMALL || this.size == Enums$Size.SMALL) {
                        ++n3;
                    }
                    this.outline = new Ellipse2D.Double(n - n3, n2 - n3, n3 * 2, n3 * 2);
                    break;
                }
                case SQUARE: {
                    if (this.outline != null) break;
                    this.outline = new Rectangle(n - n3, n2 - n3, n3 * 2, n3 * 2);
                    break;
                }
                case DIAMOND: {
                    if (this.outline != null) break;
                    shape = new Path2D.Double();
                    ((Path2D.Double)shape).moveTo(n - n3, n2);
                    ((Path2D.Double)shape).lineTo(n, n2 - n3);
                    ((Path2D.Double)shape).lineTo(n + n3, n2);
                    ((Path2D.Double)shape).lineTo(n, n2 + n3);
                    ((Path2D)shape).closePath();
                    this.outline = shape;
                    break;
                }
                case OCTOGON: {
                    if (this.outline != null) break;
                    shape = new Path2D.Double();
                    ((Path2D.Double)shape).moveTo(n - n3 / 2, n2 + n3);
                    ((Path2D.Double)shape).lineTo(n - n3, n2 + n3 / 2);
                    ((Path2D.Double)shape).lineTo(n - n3, n2 - n3 / 2);
                    ((Path2D.Double)shape).lineTo(n - n3 / 2, n2 - n3);
                    ((Path2D.Double)shape).lineTo(n + n3 / 2, n2 - n3);
                    ((Path2D.Double)shape).lineTo(n + n3, n2 - n3 / 2);
                    ((Path2D.Double)shape).lineTo(n + n3, n2 + n3 / 2);
                    ((Path2D.Double)shape).lineTo(n + n3 / 2, n2 + n3);
                    ((Path2D)shape).closePath();
                    this.outline = shape;
                    break;
                }
            }
            if (this.outline != null && this.text != null && !h.g((String)this.text.getText())) {
                this.text.layout(500);
                shape = this.outline.getBounds();
                double d = this.text.getWidth();
                double d2 = this.text.getHeight();
                double d3 = ((RectangularShape)shape).getCenterX() - d / 2.0;
                double d4 = ((RectangularShape)shape).getCenterY() - d2 / 2.0;
                switch (this.getTextPosition()) {
                    case TOP: {
                        d4 = (double)((Rectangle)shape).y - d2 - 1.0;
                        break;
                    }
                    case BOTTOM: {
                        d4 = ((RectangularShape)shape).getMaxY() + 1.0;
                        break;
                    }
                    case LEFT: {
                        d3 = (double)((Rectangle)shape).x - d - 1.0;
                        break;
                    }
                    case RIGHT: {
                        d3 = ((RectangularShape)shape).getMaxX() + 1.0;
                        break;
                    }
                }
                this.text.setLocation(d3, d4);
            }
        }
        shape = this.outline.getBounds();
        if (this.label != null) {
            Rectangle2D rectangle2D = this.label.getBounds();
            shape = new Rectangle((int)rectangle2D.getX() - 3, (int)rectangle2D.getY(), (int)rectangle2D.getWidth() + 6, (int)rectangle2D.getHeight());
        }
        shape = new Rectangle(((Rectangle)shape).x - 2, ((Rectangle)shape).y - 2, ((Rectangle)shape).width + 4, ((Rectangle)shape).height + 4);
        if (this.text != null && !h.g((String)this.text.getText())) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D.union((Rectangle2D)shape, this.text.getBounds(), double_);
            this.setBounds(double_);
        } else {
            this.setBounds((Rectangle2D)shape);
        }
    }

    private void updatePriceLabel(int n, int n2, String string) {
        float f2 = 10.0f;
        switch (this.size) {
            case VERY_SMALL: {
                f2 = 8.0f;
                break;
            }
            case SMALL: {
                f2 = 10.0f;
                break;
            }
            case MEDIUM: {
                f2 = 12.0f;
                break;
            }
            case LARGE: {
                f2 = 16.0f;
                break;
            }
            case VERY_LARGE: {
                f2 = 20.0f;
                break;
            }
        }
        if (this.label == null) {
            this.label = new Text(string, o.x().deriveFont(f2), new Insets(1, 3, 1, 3), true);
        } else {
            this.label.setText(string);
            this.label.setOutline(Enums$TextOutline.RECTANGLE);
            this.label.setFont(o.x().deriveFont(f2));
            this.label.layout(200);
            this.label.compact();
        }
        this.label.setBackground(this.fillColor);
        this.label.setTextColor(this.outlineColor);
        this.label.setBorderColor(this.outlineColor);
        this.label.setBorderStroke(this.getStroke());
        Rectangle2D rectangle2D = this.label.getBounds();
        this.label.setLocation((double)n - rectangle2D.getWidth() / 2.0, (double)n2 - rectangle2D.getHeight() / 2.0);
        this.outline = new Line2D.Double((double)n - rectangle2D.getWidth() / 2.0 - 3.0, n2, (double)n + rectangle2D.getWidth() / 2.0 + 3.0, n2);
    }

    private void updateLabel(int n, int n2) {
        float f2 = 10.0f;
        switch (this.size) {
            case VERY_SMALL: {
                f2 = 9.0f;
                break;
            }
            case SMALL: {
                f2 = 12.0f;
                break;
            }
            case MEDIUM: {
                f2 = 15.0f;
                break;
            }
            case LARGE: {
                f2 = 18.0f;
                break;
            }
            case VERY_LARGE: {
                f2 = 24.0f;
                break;
            }
        }
        if (this.label == null) {
            this.label = new Text(this.type.toString(), o.y().deriveFont(f2), new Insets(1, 3, 1, 3), true);
        } else {
            this.label.setText(this.type.toString());
            this.label.setOutline(Enums$TextOutline.CIRCLE);
            this.label.setFont(o.y().deriveFont(f2));
        }
        switch (this.type) {
            case TWO: 
            case THREE: 
            case FIVE: 
            case SIX: 
            case SEVEN: 
            case NINE: 
            case ZERO: 
            case EIGHT: {
                this.label.setInsets(2, 4, 1, 3);
                break;
            }
            case B: 
            case C: 
            case E: {
                this.label.setInsets(2, 3, 1, 3);
                break;
            }
            case D: 
            case X: {
                this.label.setInsets(2, 4, 1, 3);
                break;
            }
            case W: {
                this.label.setInsets(3, 3, 1, 3);
                break;
            }
            case Y: 
            case Z: {
                this.label.setInsets(2, 3, 1, 3);
            }
        }
        this.label.layout(200);
        this.label.compact();
        this.label.setBackground(this.fillColor);
        this.label.setTextColor(this.outlineColor);
        this.label.setBorderColor(this.outlineColor);
        this.label.setBorderStroke(this.getStroke());
        Rectangle2D rectangle2D = this.label.getBounds();
        this.label.setLocation((double)n - rectangle2D.getWidth() / 2.0, (double)n2 - rectangle2D.getHeight() / 2.0);
        this.outline = this.label.getBounds();
    }

    private void createTriangle(int n, int n2) {
        int n3 = 5;
        switch (this.size) {
            case VERY_SMALL: {
                n3 = 2;
                break;
            }
            case SMALL: {
                n3 = 3;
                break;
            }
            case MEDIUM: {
                n3 = 4;
                break;
            }
            case LARGE: {
                n3 = 6;
                break;
            }
            case VERY_LARGE: {
                n3 = 8;
                break;
            }
        }
        Path2D.Double double_ = new Path2D.Double();
        int n4 = n3 * 2;
        switch (this.getPosition()) {
            case TOP: {
                double_.moveTo(n - n4, (n2 -= n3 + 2) - n3);
                double_.lineTo(n, n2 + n3 + 1);
                double_.lineTo(n + n4, n2 - n3);
                break;
            }
            case LEFT: {
                double_.moveTo((n -= n3 + 2) - n3, n2 - n4);
                double_.lineTo(n + n3 + 1, n2);
                double_.lineTo(n - n3, n2 + n4);
                break;
            }
            case RIGHT: {
                double_.moveTo((n += n3 + 2) + n3, n2 - n4);
                double_.lineTo(n - n3 - 1, n2);
                double_.lineTo(n + n3, n2 + n4);
                break;
            }
            default: {
                double_.moveTo(n - n4, (n2 += n3 + 2) + n3);
                double_.lineTo(n, n2 - (n3 + 1));
                double_.lineTo(n + n4, n2 + n3);
            }
        }
        double_.closePath();
        this.outline = double_;
    }

    private void createArrow(int n, int n2) {
        int n3 = 5;
        int n4 = 2;
        int n5 = 6;
        switch (this.size) {
            case VERY_SMALL: {
                n3 = 5;
                n4 = 2;
                n5 = 6;
                break;
            }
            case SMALL: {
                n3 = 6;
                n4 = 3;
                n5 = 8;
                break;
            }
            case MEDIUM: {
                n3 = 7;
                n4 = 3;
                n5 = 10;
                break;
            }
            case LARGE: {
                n3 = 10;
                n4 = 4;
                n5 = 14;
                break;
            }
            case VERY_LARGE: {
                n3 = 14;
                n4 = 6;
                n5 = 20;
                break;
            }
        }
        Path2D.Double double_ = new Path2D.Double();
        switch (this.getPosition()) {
            case TOP: {
                double_.moveTo(n - n4, (n2 -= n5 + 2) - n5);
                double_.lineTo(n + n4, n2 - n5);
                double_.lineTo(n + n4, n2 + n5 - n3);
                double_.lineTo(n + n3, n2 + n5 - n3);
                double_.lineTo(n, n2 + n5);
                double_.lineTo(n - n3, n2 + n5 - n3);
                double_.lineTo(n - n4, n2 + n5 - n3);
                break;
            }
            case LEFT: {
                double_.moveTo((n -= n5 + 2) - n5, n2 - n4);
                double_.lineTo(n - n5, n2 + n4);
                double_.lineTo(n + n5 - n3, n2 + n4);
                double_.lineTo(n + n5 - n3, n2 + n3);
                double_.lineTo(n + n5, n2);
                double_.lineTo(n + n5 - n3, n2 - n3);
                double_.lineTo(n + n5 - n3, n2 - n4);
                break;
            }
            case RIGHT: {
                double_.moveTo((n += n5 + 2) + n5, n2 - n4);
                double_.lineTo(n + n5, n2 + n4);
                double_.lineTo(n - n5 + n3, n2 + n4);
                double_.lineTo(n - n5 + n3, n2 + n3);
                double_.lineTo(n - n5, n2);
                double_.lineTo(n - n5 + n3, n2 - n3);
                double_.lineTo(n - n5 + n3, n2 - n4);
                break;
            }
            default: {
                double_.moveTo(n - n4, (n2 += n5 + 2) + n5);
                double_.lineTo(n + n4, n2 + n5);
                double_.lineTo(n + n4, n2 - n5 + n3);
                double_.lineTo(n + n3, n2 - n5 + n3);
                double_.lineTo(n, n2 - n5);
                double_.lineTo(n - n3, n2 - n5 + n3);
                double_.lineTo(n - n4, n2 - n5 + n3);
            }
        }
        double_.closePath();
        this.outline = double_;
    }

    private void createLineArrow(int n, int n2) {
        int n3 = 4;
        int n4 = 4;
        switch (this.size) {
            case VERY_SMALL: {
                n3 = 3;
                n4 = 4;
                break;
            }
            case SMALL: {
                n3 = 4;
                n4 = 5;
                break;
            }
            case MEDIUM: {
                n3 = 6;
                n4 = 6;
                break;
            }
            case LARGE: {
                n3 = 7;
                n4 = 8;
                break;
            }
            case VERY_LARGE: {
                n3 = 8;
                n4 = 10;
                break;
            }
        }
        Path2D.Double double_ = new Path2D.Double();
        switch (this.getPosition()) {
            case TOP: {
                double_.moveTo(n, (n2 -= n4 + 2) - n4);
                double_.lineTo(n, n2 + n4 - 1);
                double_.moveTo(n + n3, n2 + n4 - n3);
                double_.lineTo(n, n2 + n4);
                double_.lineTo(n - n3, n2 + n4 - n3);
                break;
            }
            case LEFT: {
                double_.moveTo((n -= n4 + 2) - n4, n2);
                double_.lineTo(n + n4 - n3 + 1, n2);
                double_.moveTo(n + n4 - n3, n2 + n3);
                double_.lineTo(n + n4, n2);
                double_.lineTo(n + n4 - n3, n2 - n3);
                break;
            }
            case RIGHT: {
                double_.moveTo((n += n4 + 2) + n4, n2);
                double_.lineTo(n - n4 + n3 - 1, n2);
                double_.moveTo(n - n4 + n3, n2 + n3);
                double_.lineTo(n - n4, n2);
                double_.lineTo(n - n4 + n3, n2 - n3);
                break;
            }
            default: {
                double_.moveTo(n, (n2 += n4 + 2) + n4);
                double_.lineTo(n, n2 - n4 + 1);
                double_.moveTo(n + n3, n2 - n4 + n3);
                double_.lineTo(n, n2 - n4);
                double_.lineTo(n - n3, n2 - n4 + n3);
            }
        }
        this.outline = double_;
    }

    protected Stroke getStroke() {
        return null;
    }

    public String toString() {
        return "Marker: " + String.valueOf(this.type) + " size: " + String.valueOf(this.size) + " (" + h.l((long)this.getTime()) + "," + this.getValue() + ")";
    }

    public boolean equals(Object object) {
        String string;
        String string2;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)object;
        if (this.getType() != marker.getType()) {
            return false;
        }
        if (this.getPosition() != marker.getPosition()) {
            return false;
        }
        if (this.getSize() != marker.getSize()) {
            return false;
        }
        if (!h.a((Object)this.getLocation(), (Object)marker.getLocation())) {
            return false;
        }
        if (this.getStackPolicy() != marker.getStackPolicy()) {
            return false;
        }
        if (this.getOffsetPixels() != marker.getOffsetPixels()) {
            return false;
        }
        if (this.getTextPosition() != marker.getTextPosition()) {
            return false;
        }
        if (!h.a((Object)this.getFillColor(), (Object)marker.getFillColor())) {
            return false;
        }
        if (!h.a((Object)this.getOutlineColor(), (Object)marker.getOutlineColor())) {
            return false;
        }
        String string3 = this.text == null ? null : this.text.getText();
        String string4 = string2 = marker.text == null ? null : marker.text.getText();
        if (!h.a((Object)string3, (Object)string2)) {
            return false;
        }
        String string5 = this.label == null ? null : this.label.getText();
        String string6 = string = marker.label == null ? null : marker.label.getText();
        return h.a((Object)string5, (Object)string);
    }
}

