/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import cf.ds;
import com.motivewave.common.util.m;
import com.motivewave.platform.common.an;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.Enums$TextOutline;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Text;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Line
extends Figure {
    private long startTime;
    private long endTime;
    private double startValue;
    private double endValue;
    private int extendLeft = 0;
    private int extendRight = 0;
    private boolean extendRightBounds = false;
    private boolean extendLeftBounds = false;
    private boolean needsLayout = true;
    private Line2D line;
    private Color color = null;
    private Color colorAbove = null;
    private Color colorBelow = null;
    private Stroke stroke = an.SOLID_LINE;
    private Text text;
    private double valueAbove;
    private double valueBelow;
    private Paint paint;

    public Line(Coordinate coordinate, Coordinate coordinate2) {
        this(coordinate, coordinate2, null);
    }

    public Line(Coordinate coordinate, Coordinate coordinate2, PathInfo pathInfo) {
        if (coordinate.getTime() > coordinate2.getTime()) {
            Coordinate coordinate3 = coordinate;
            coordinate = coordinate2;
            coordinate2 = coordinate3;
        }
        this.startTime = coordinate.getTime();
        this.startValue = coordinate.getValue();
        this.endTime = coordinate2.getTime();
        this.endValue = coordinate2.getValue();
        if (pathInfo != null) {
            this.setColor(pathInfo.getColor());
            this.setStroke(pathInfo.getStroke());
        }
    }

    public Line(long l2, double d, long l3, double d2) {
        this(l2, d, l3, d2, null);
    }

    public Line(long l2, double d, long l3, double d2, PathInfo pathInfo) {
        if (l2 > l3) {
            long l4 = l2;
            double d3 = d;
            l2 = l3;
            d = d2;
            l3 = l4;
            d2 = d3;
        }
        this.startTime = l2;
        this.startValue = d;
        this.endTime = l3;
        this.endValue = d2;
        if (pathInfo != null) {
            this.setColor(pathInfo.getColor());
            this.setStroke(pathInfo.getStroke());
        }
    }

    public void setStart(long l2, double d) {
        this.startTime = l2;
        this.startValue = d;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setEnd(long l2, double d) {
        this.endTime = l2;
        this.endValue = d;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public double getEndValue() {
        return this.endValue;
    }

    public Text getText() {
        return this.text;
    }

    public void setText(String string, Font font) {
        if (Util.isEmpty(string)) {
            this.text = null;
            return;
        }
        if (this.text == null) {
            this.text = new Text(string, font);
            if (this.color != null) {
                this.text.setTextColor(this.color);
            }
            this.text.setShowBorder(true);
            this.text.setShowOutline(true);
            this.text.setOutline(Enums$TextOutline.ROUNDED);
            this.text.setInsets(1, 3, 1, 3);
            this.text.layout();
        } else {
            this.text.setText(string);
            this.text.setFont(font);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setExtendLeft(int n) {
        this.extendLeft = n;
    }

    public int getExtendLeft() {
        return this.extendLeft;
    }

    public void setExtendRight(int n) {
        this.extendRight = n;
    }

    public int getExtendRight() {
        return this.extendRight;
    }

    public void setExtendRightBounds(boolean bl) {
        this.extendRightBounds = bl;
    }

    public boolean isExtendRightBounds() {
        return this.extendRightBounds;
    }

    public void setExtendLeftBounds(boolean bl) {
        this.extendLeftBounds = bl;
    }

    public boolean isExtendLeftBounds() {
        return this.extendLeftBounds;
    }

    public void setColorAbove(double d, Color color) {
        this.colorAbove = color;
        this.valueAbove = d;
    }

    public void setColorBelow(double d, Color color) {
        this.colorBelow = color;
        this.valueBelow = d;
    }

    @Override
    public boolean isVisible(DrawContext drawContext) {
        if (drawContext == null || drawContext.getDataContext() == null) {
            return false;
        }
        DataSeries dataSeries = drawContext.getDataContext().getDataSeries();
        if (dataSeries == null) {
            return false;
        }
        long l2 = this.endTime;
        if (this.extendRight > 0) {
            int n = dataSeries.findIndex(l2);
            if (n < 0) {
                n = dataSeries.size() - 1;
            }
            l2 = dataSeries.getEndTime(n + this.extendRight);
        }
        if (!this.extendRightBounds && l2 < dataSeries.getVisibleStartTime()) {
            return false;
        }
        if (dataSeries.isLatestData()) {
            return true;
        }
        long l3 = this.startTime;
        if (this.extendLeft > 0) {
            int n = dataSeries.findIndex(l3);
            if (n < 0) {
                n = 0;
            }
            l3 = dataSeries.getStartTime(n - this.extendLeft);
        }
        return this.extendLeftBounds || l3 <= dataSeries.getVisibleEndTime();
    }

    @Override
    public boolean contains(double d, double d2, DrawContext drawContext) {
        if (this.line != null && m.a((double)d, (double)d2, (Line2D)this.line) < 6.0) {
            return true;
        }
        return this.text != null && this.text.contains(d, d2);
    }

    @Override
    public void layout(DrawContext drawContext) {
        Color color;
        double d;
        Point2D point2D = drawContext.translate(this.startTime, this.startValue);
        Point2D point2D2 = drawContext.translate(this.endTime, this.endValue);
        Rectangle rectangle = drawContext.getBounds();
        if (rectangle == null) {
            return;
        }
        Point2D point2D3 = point2D;
        Point2D point2D4 = point2D2;
        double d2 = m.a((Point2D)point2D3, (Point2D)point2D4);
        double d3 = point2D3.getY() - d2 * point2D3.getX();
        if (this.extendLeftBounds) {
            d = rectangle.x;
            point2D3 = new Point2D.Double(d, d2 * d + d3);
        } else if (this.extendLeft > 0) {
            d = point2D3.getX() - (double)(this.extendLeft * drawContext.getBarWidth());
            point2D3 = new Point2D.Double(d, d2 * d + d3);
        }
        if (this.extendRightBounds) {
            d = rectangle.x + rectangle.width;
            point2D4 = new Point2D.Double(d, d2 * d + d3);
        } else if (this.extendRight > 0) {
            d = point2D4.getX() + (double)(this.extendRight * drawContext.getBarWidth());
            point2D4 = new Point2D.Double(d, d2 * d + d3);
        }
        this.line = Util.clipLine(point2D3, point2D4, drawContext.getBounds());
        if (this.text != null) {
            Point2D point2D5 = Util.midpoint(point2D, point2D2);
            this.text.setCenter(point2D5);
        }
        if (this.line != null) {
            this.setBounds(this.line.getBounds2D());
        }
        if ((color = this.color) == null) {
            color = drawContext.getDefaults().getLineColor();
        }
        if (this.colorAbove == null && this.colorBelow == null) {
            this.paint = color;
        } else {
            ds ds2 = new ds();
            float f2 = 0.0f;
            if (this.colorAbove != null) {
                f2 = drawContext.translateValue(this.valueAbove);
                ds2.a(this.colorAbove, f2);
            }
            if (this.colorBelow != null) {
                f2 = drawContext.translateValue(this.valueBelow);
                ds2.a(color, f2);
                ds2.a(this.colorBelow, Math.max(f2 + 5.0f, (float)rectangle.getMaxY()));
            } else {
                ds2.a(color, Math.max(f2 + 5.0f, (float)rectangle.getMaxY()));
            }
            this.paint = ds2.a();
        }
        this.needsLayout = false;
    }

    @Override
    public void draw(Graphics2D graphics2D, DrawContext drawContext) {
        if (this.needsLayout) {
            this.layout(drawContext);
        }
        Color color = this.color == null ? drawContext.getDefaults().getLineColor() : this.color;
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        graphics2D.setPaint(this.paint);
        if (this.line != null) {
            graphics2D.draw(this.line);
        }
        if (this.text != null) {
            this.text.draw(graphics2D);
        }
    }
}

