/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.Enums$StackPolicy;
import com.motivewave.platform.sdk.common.Enums$TextOutline;
import com.motivewave.platform.sdk.draw.SinglePointFigure;
import com.motivewave.platform.sdk.draw.Text;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Label
extends SinglePointFigure {
    private Text text;
    private int offset = 8;
    private Point2D loc;
    private Color lineColor;
    private Stroke lineStroke;
    private boolean showLine = true;
    private boolean needsLayout = true;

    public Label(String string) {
        this.text = new Text(string);
    }

    public Label(Coordinate coordinate, String string) {
        this.text = new Text(string);
        this.setLocation(coordinate);
    }

    public Label(Coordinate coordinate, Enums$StackPolicy enums$StackPolicy, String string) {
        this.text = new Text(string);
        this.setLocation(coordinate);
        this.setStackPolicy(enums$StackPolicy);
    }

    public Label(String string, Font font, Color color, Color color2) {
        this.text = new Text(string, font);
        this.text.setBackground(color2);
        this.text.setTextColor(color);
        this.text.setBorderColor(color);
        this.text.setShowBorder(true);
        this.text.setShowOutline(true);
        this.text.setOutline(Enums$TextOutline.ROUNDED);
        this.text.setInsets(1, 3, 1, 3);
        this.text.layout();
        this.lineColor = color;
    }

    public Text getText() {
        return this.text;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setShowLine(boolean bl) {
        this.showLine = bl;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setLineStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    @Override
    public void layout(DrawContext drawContext) {
        this.loc = new Point2D.Double(0.0, 0.0);
        this.text.setHandle(this.loc);
        switch (this.getPosition()) {
            case LEFT: {
                this.text.setLocation(this.loc.getX() - this.text.getWidth() - (double)this.offset, this.loc.getY() - this.text.getHeight() / 2.0);
                break;
            }
            case RIGHT: {
                this.text.setLocation(this.loc.getX() + (double)this.offset, this.loc.getY() - this.text.getHeight() / 2.0);
                break;
            }
            case TOP: {
                this.text.setLocation(this.loc.getX() - this.text.getWidth() / 2.0, this.loc.getY() - this.text.getHeight() - (double)this.offset);
                break;
            }
            case TOP_LEFT: {
                this.text.setLocation(this.loc.getX() - this.text.getWidth(), this.loc.getY() - this.text.getHeight() - (double)this.offset);
                break;
            }
            case TOP_RIGHT: {
                this.text.setLocation(this.loc.getX() + (double)this.offset, this.loc.getY() - this.text.getHeight() - (double)this.offset);
                break;
            }
            case BOTTOM: {
                this.text.setLocation(this.loc.getX() - this.text.getWidth() / 2.0, this.loc.getY() + (double)this.offset);
                break;
            }
            case BOTTOM_LEFT: {
                this.text.setLocation(this.loc.getX() - this.text.getWidth(), this.loc.getY() + (double)this.offset);
                break;
            }
            case BOTTOM_RIGHT: {
                this.text.setLocation(this.loc.getX() + (double)this.offset, this.loc.getY() + (double)this.offset);
                break;
            }
            case CENTER: {
                this.text.setLocation(this.loc.getX() - this.text.getWidth() / 2.0, this.loc.getY() - this.text.getHeight() / 2.0);
                break;
            }
        }
        Rectangle2D rectangle2D = (Rectangle2D)this.text.getBounds().clone();
        rectangle2D.add(this.loc);
        this.setBounds(rectangle2D);
        if (this.getGraphLocation() == null) {
            this.setGraphLocation(drawContext.translate(this.getTime(), this.getValue()));
        }
        this.needsLayout = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D graphics2D, DrawContext drawContext) {
        if (this.needsLayout) {
            this.layout(drawContext);
        }
        if (this.loc == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.getGraphLocation() != null) {
            n = (int)Math.round(this.getGraphLocation().getX());
            n2 = (int)Math.round(this.getGraphLocation().getY());
        }
        graphics2D.translate(n, n2);
        try {
            if (this.isShowLine()) {
                graphics2D.setColor(this.lineColor);
                if (this.lineStroke != null) {
                    graphics2D.setStroke(this.lineStroke);
                } else {
                    graphics2D.setStroke(this.text.getBorderStroke());
                }
                switch (this.getPosition()) {
                    case LEFT: {
                        graphics2D.drawLine((int)this.text.getMaxX(), (int)this.loc.getY(), (int)this.loc.getX(), (int)this.loc.getY());
                        break;
                    }
                    case RIGHT: {
                        graphics2D.drawLine((int)this.loc.getX(), (int)this.loc.getY(), (int)this.text.getX(), (int)this.loc.getY());
                        break;
                    }
                    case TOP: {
                        graphics2D.drawLine((int)this.loc.getX(), (int)this.loc.getY(), (int)this.loc.getX(), (int)this.text.getMaxY());
                        break;
                    }
                    case TOP_LEFT: {
                        graphics2D.drawLine((int)this.text.getMaxX(), (int)this.loc.getY(), (int)this.loc.getX(), (int)this.text.getMaxY());
                        break;
                    }
                    case TOP_RIGHT: {
                        graphics2D.drawLine((int)this.loc.getX(), (int)this.loc.getY(), (int)this.text.getX(), (int)this.text.getMaxY());
                        break;
                    }
                    case BOTTOM: {
                        graphics2D.drawLine((int)this.loc.getX(), (int)this.loc.getY(), (int)this.loc.getX(), (int)this.text.getY());
                        break;
                    }
                    case BOTTOM_LEFT: {
                        graphics2D.drawLine((int)this.text.getMaxX(), (int)this.loc.getY(), (int)this.loc.getX(), (int)this.text.getY());
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        graphics2D.drawLine((int)this.loc.getX(), (int)this.loc.getY(), (int)this.text.getX(), (int)this.text.getY());
                        break;
                    }
                }
            }
            this.text.draw(graphics2D);
        }
        finally {
            graphics2D.translate(-n, -n2);
        }
    }
}

