/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.draw.ColorRange$ColorRegion;
import com.motivewave.platform.sdk.draw.Figure;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ColorRange
extends Figure {
    private long time;
    private List colorRegions = new ArrayList();
    private Color backgroundColor;

    public ColorRange(long l2) {
        this.time = l2;
    }

    @Override
    public void layout(DrawContext drawContext) {
        double d;
        if (Util.isEmpty(this.colorRegions)) {
            this.setBounds(null);
            return;
        }
        double d2 = (double)drawContext.translateTime(this.time) - (double)drawContext.getBarWidth() / 2.0;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        for (ColorRange$ColorRegion colorRange$ColorRegion : this.colorRegions) {
            if (colorRange$ColorRegion.bottom < d3) {
                d3 = colorRange$ColorRegion.bottom;
            }
            if (colorRange$ColorRegion.top > d4) {
                d4 = colorRange$ColorRegion.top;
            }
            d = drawContext.translateValue(colorRange$ColorRegion.top);
            double d5 = drawContext.translateValue(colorRange$ColorRegion.bottom);
            colorRange$ColorRegion.area = new Rectangle2D.Double(d2, d, drawContext.getBarWidth(), d5 - d);
        }
        double d6 = drawContext.translateValue(d4);
        d = drawContext.translateValue(d3);
        this.setBounds(new Rectangle2D.Double(d2, d6, drawContext.getBarWidth(), d - d6));
    }

    @Override
    public void draw(Graphics2D graphics2D, DrawContext drawContext) {
        if (this.getBounds() == null) {
            return;
        }
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
            graphics2D.fill(this.getBounds());
        }
        for (ColorRange$ColorRegion colorRange$ColorRegion : this.colorRegions) {
            if (colorRange$ColorRegion.color == null || colorRange$ColorRegion.area == null) continue;
            graphics2D.setColor(colorRange$ColorRegion.color);
            graphics2D.fill(colorRange$ColorRegion.area);
        }
    }

    public void addRegion(Color color, double d, double d2) {
        this.colorRegions.add(new ColorRange$ColorRegion(color, d, d2));
    }

    public void clearRegions() {
        this.colorRegions.clear();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public long getTime() {
        return this.time;
    }
}

