/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.draw;

import com.motivewave.platform.common.an;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.DrawContext;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.draw.Figure;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class Box
extends Figure {
    private long startTime;
    private double startValue;
    private long endTime;
    private double endValue;
    private Rectangle rectangle;
    private Color lineColor = null;
    private Color fillColor = null;
    private Stroke stroke = an.SOLID_LINE;

    public Box(Coordinate coordinate, Coordinate coordinate2) {
        this(coordinate, coordinate2, null);
    }

    public Box(Coordinate coordinate, Coordinate coordinate2, PathInfo pathInfo) {
        if (coordinate.getTime() > coordinate2.getTime()) {
            Coordinate coordinate3 = coordinate;
            coordinate = coordinate2;
            coordinate2 = coordinate3;
        }
        this.startTime = coordinate.getTime();
        this.startValue = coordinate.getValue();
        this.endTime = coordinate2.getTime();
        this.endValue = coordinate2.getValue();
        if (pathInfo != null) {
            if (pathInfo.isEnabled()) {
                this.setLineColor(pathInfo.getColor());
                this.setStroke(pathInfo.getStroke());
            } else {
                this.setLineColor(null);
                this.setStroke(null);
            }
        }
    }

    public Box(long l2, double d, long l3, double d2) {
        this(l2, d, l3, d2, null);
    }

    public Box(long l2, double d, long l3, double d2, PathInfo pathInfo) {
        if (l2 > l3) {
            long l4 = l2;
            double d3 = d;
            l2 = l3;
            d = d2;
            l3 = l4;
            d2 = d3;
        }
        this.startTime = l2;
        this.startValue = d;
        this.endTime = l3;
        this.endValue = d2;
        if (pathInfo != null) {
            if (pathInfo.isEnabled()) {
                this.setLineColor(pathInfo.getColor());
                this.setStroke(pathInfo.getStroke());
            } else {
                this.setLineColor(null);
                this.setStroke(null);
            }
        }
    }

    public void setStart(long l2, double d) {
        this.startTime = l2;
        this.startValue = d;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setEnd(long l2, double d) {
        this.endTime = l2;
        this.endValue = d;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public double getEndValue() {
        return this.endValue;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public boolean isVisible(DrawContext drawContext) {
        long l2 = this.endTime;
        DataSeries dataSeries = drawContext.getDataContext().getDataSeries();
        if (l2 < dataSeries.getVisibleStartTime()) {
            return false;
        }
        if (dataSeries.isLatestData()) {
            return true;
        }
        long l3 = this.startTime;
        return l3 <= dataSeries.getVisibleEndTime();
    }

    @Override
    public boolean contains(double d, double d2, DrawContext drawContext) {
        if (this.rectangle == null) {
            return false;
        }
        return this.rectangle.contains(d, d2);
    }

    @Override
    public void layout(DrawContext drawContext) {
        Point2D point2D = drawContext.translate(this.startTime, this.startValue);
        Point2D point2D2 = drawContext.translate(this.endTime, this.endValue);
        int n = (int)(point2D.getX() < point2D2.getX() ? point2D.getX() : point2D2.getX());
        int n2 = (int)(point2D.getY() < point2D2.getY() ? point2D.getY() : point2D2.getY());
        int n3 = (int)Math.round(Math.abs(point2D.getX() - point2D2.getX()));
        int n4 = (int)Math.round(Math.abs(point2D.getY() - point2D2.getY()));
        this.rectangle = new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void draw(Graphics2D graphics2D, DrawContext drawContext) {
        Rectangle rectangle = this.rectangle;
        if (rectangle == null) {
            return;
        }
        if (this.fillColor != null) {
            graphics2D.setColor(this.fillColor);
            graphics2D.fill(rectangle);
        }
        if (this.stroke != null) {
            Color color = this.lineColor == null ? drawContext.getDefaults().getLineColor() : this.lineColor;
            graphics2D.setColor(color);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(rectangle);
        }
    }
}

