/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common.desc;

import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.SettingsBase;
import com.motivewave.platform.sdk.common.desc.IconFactory;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class SliderDescriptor
extends SettingDescriptor {
    private int min;
    private int max;
    private boolean autoMinMax = false;

    public SliderDescriptor(String string, String string2, int n) {
        this(string, string2, n, 0, 0, null);
        this.autoMinMax = true;
    }

    public SliderDescriptor(String string, String string2, int n, int n2, int n3) {
        this(string, string2, n, n2, n3, false, null);
    }

    public SliderDescriptor(String string, String string2, int n, int n2, int n3, boolean bl) {
        this(string, string2, n, n2, n3, bl, null);
    }

    public SliderDescriptor(String string, String string2, int n, IconFactory iconFactory) {
        this(string, string2, n, 0, 0, iconFactory);
        this.autoMinMax = true;
    }

    public SliderDescriptor(String string, String string2, int n, int n2, int n3, IconFactory iconFactory) {
        this(string, string2, n, n2, n3, false, iconFactory);
    }

    public SliderDescriptor(String string, String string2, int n, int n2, int n3, boolean bl, IconFactory iconFactory) {
        super(string, string2, n);
        this.min = n2;
        this.max = n3;
        this.autoMinMax = bl;
        this.setIconFactory(iconFactory);
    }

    @Override
    public Integer getDefaultValue() {
        return (Integer)super.getDefaultValue();
    }

    public boolean isAutoMinMax() {
        return this.autoMinMax;
    }

    public void setAutoMinMax(boolean bl) {
        this.autoMinMax = bl;
    }

    private Node createInputFX(SettingsBase settingsBase, boolean bl, int n) {
        Integer n2 = settingsBase.getInteger(this.getId());
        if (n2 == null) {
            n2 = this.getDefaultValue();
        }
        int n3 = this.min;
        int n4 = this.max;
        if (this.min == 0 && this.max == 0) {
            n3 = 0;
            n4 = 100;
        }
        Slider slider = new Slider((double)n3, (double)n4, (double)n2.intValue());
        slider.setBlockIncrement(1.0);
        slider.setMajorTickUnit(1.0);
        slider.setMinorTickCount(0);
        slider.setShowTickLabels(false);
        slider.setSnapToTicks(true);
        slider.setMinWidth((double)n);
        slider.setPrefWidth((double)n);
        Label label = new Label("" + h.b((double)slider.getValue()));
        label.getStyleClass().add((Object)"label-normal");
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        this.adjust(slider, n2, true);
        slider.valueProperty().addListener((observableValue, number, number2) -> {
            int n = h.b((double)slider.getValue());
            label.setText("" + n);
            settingsBase.setValue(this.getId(), n);
        });
        if (this.autoMinMax) {
            slider.setOnMouseReleased(mouseEvent -> this.adjust(slider, (int)slider.getValue(), false));
        }
        if (bl) {
            slider.setDisable(true);
        }
        HBox hBox = new HBox(0.0, new Node[]{slider, label});
        hBox.setAlignment(Pos.CENTER_LEFT);
        return hBox;
    }

    @Override
    public Node createControl(SettingsBase settingsBase, boolean bl) {
        return this.createInputFX(settingsBase, bl || this.isReadOnly(), 175);
    }

    @Override
    public Node createTBInput(SettingsBase settingsBase) {
        Node node;
        Node node2 = this.createInputFX(settingsBase, false, 100);
        IconFactory iconFactory = this.getIconFactory();
        Node node3 = node = iconFactory == null ? null : iconFactory.create();
        if (node == null) {
            return node2;
        }
        HBox hBox = new HBox(3.0, new Node[]{node, node2});
        hBox.setAlignment(Pos.CENTER_LEFT);
        return hBox;
    }

    private void adjust(Slider slider, int n, boolean bl) {
        if (!this.autoMinMax) {
            return;
        }
        if (!bl) {
            double d = slider.getMax() - slider.getMin();
            double d2 = ((double)n - slider.getMin()) / d;
            if (d2 > 0.1 && d2 < 0.9) {
                return;
            }
        }
        int n2 = this.min;
        int n3 = this.max;
        boolean bl2 = this.min != 0 || this.max != 0;
        int n4 = 1;
        if (n < 1000) {
            n4 = 1;
        } else if (n < 10000) {
            n4 = 10;
        } else if (n < 100000) {
            n4 = 100;
        } else if (n < 1000000) {
            n4 = 1000;
        } else if (n < 10000000) {
            n4 = 10000;
        }
        n2 = n - 100 * n4;
        if (!bl2) {
            if (n2 < n4) {
                n2 = n4;
            }
        } else if (n2 < this.min) {
            n2 = this.min;
        }
        n3 = n2 + 200 * n4;
        if (bl2 && n3 > this.max) {
            n3 = this.max;
        }
        slider.setMin((double)n2);
        slider.setMax((double)n3);
        slider.setBlockIncrement((double)n4);
        slider.setMajorTickUnit((double)n4);
        slider.setValue((double)n);
    }

    @Override
    public Object fromJson(Object object) {
        if (object == null) {
            return this.getDefaultValue();
        }
        if (object instanceof Integer) {
            return object;
        }
        return h.a((Object)object);
    }
}

