/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common.desc;

import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.SettingsBase;
import com.motivewave.platform.sdk.common.desc.IconFactory;
import com.motivewave.platform.sdk.common.desc.PercentSliderDescriptor$1;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class PercentSliderDescriptor
extends SettingDescriptor {
    private double minValue = 0.0;
    private int prefWidth = 150;

    public PercentSliderDescriptor(String string, String string2, double d) {
        this(string, string2, 0.0, d, null);
    }

    public PercentSliderDescriptor(String string, String string2, double d, double d2) {
        this(string, string2, d, d2, null);
    }

    public PercentSliderDescriptor(String string, String string2, double d, IconFactory iconFactory) {
        this(string, string2, 0.0, d, iconFactory);
    }

    public PercentSliderDescriptor(String string, String string2, double d, double d2, IconFactory iconFactory) {
        super(string, string2, d2);
        this.setIconFactory(iconFactory);
        this.minValue = d;
    }

    @Override
    public Double getDefaultValue() {
        return (Double)super.getDefaultValue();
    }

    private Node createInputFX(SettingsBase settingsBase, boolean bl, int n) {
        Double d = settingsBase.getDouble(this.getId());
        if (d == null) {
            d = this.getDefaultValue();
        }
        Slider slider = new Slider((double)((int)(this.minValue * 100.0)), 100.0, (double)((int)(d * 100.0)));
        slider.setMinWidth((double)n);
        slider.setPrefWidth((double)n);
        Label label = new Label(h.b((double)slider.getValue()) + "%");
        label.getStyleClass().add((Object)"label-normal");
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        slider.valueProperty().addListener((observableValue, number, number2) -> {
            label.setText(h.b((double)slider.getValue()) + "%");
            settingsBase.setDouble(this.getId(), slider.getValue() / 100.0);
        });
        HBox.setMargin((Node)slider, (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
        if (bl) {
            slider.setDisable(true);
        }
        HBox hBox = new HBox(0.0, new Node[]{slider, new PercentSliderDescriptor$1(this).a(8), label});
        hBox.setAlignment(Pos.CENTER_LEFT);
        return hBox;
    }

    @Override
    public Node createControl(SettingsBase settingsBase, boolean bl) {
        return this.createInputFX(settingsBase, bl || this.isReadOnly(), this.prefWidth);
    }

    @Override
    public Node createTBInput(SettingsBase settingsBase) {
        Node node;
        Node node2 = this.createInputFX(settingsBase, false, 100);
        IconFactory iconFactory = this.getIconFactory();
        Node node3 = node = iconFactory == null ? null : iconFactory.create();
        if (node == null) {
            return node2;
        }
        HBox hBox = new HBox(3.0, new Node[]{node, node2});
        hBox.setAlignment(Pos.CENTER_LEFT);
        return hBox;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public PercentSliderDescriptor setPrefWidth(int n) {
        this.prefWidth = n;
        return this;
    }

    @Override
    public Object fromJson(Object object) {
        if (object == null) {
            return this.getDefaultValue();
        }
        if (object instanceof Double) {
            return object;
        }
        return h.a((Object)object);
    }
}

