/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common.desc;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.sdk.common.SettingsBase;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import javafx.scene.Node;
import javafx.scene.control.Spinner;
import javafx.scene.layout.GridPane;

public class IntegerDescriptor
extends SettingDescriptor {
    private int minValue;
    private int maxValue;
    private int step;

    public IntegerDescriptor(String string, String string2, int n, int n2, int n3, int n4) {
        super(string, string2, n);
        this.minValue = n2;
        this.maxValue = n3;
        this.step = n4;
        if (n2 > n3) {
            int n5 = n3;
            n3 = n2;
            n2 = n5;
        }
        if (n < n2) {
            this.setDefaultValue(n2);
        } else if (n > n3) {
            this.setDefaultValue(n3);
        }
    }

    @Override
    public Integer getDefaultValue() {
        return h.a((Integer)((Integer)super.getDefaultValue()));
    }

    @Override
    public Node createControl(SettingsBase settingsBase, boolean bl) {
        Integer n = settingsBase.getInteger(this.getId());
        if (n == null) {
            n = this.getDefaultValue();
        }
        Spinner spinner = UIUtil.a((int)n, (int)this.getMinValue(), (int)this.getMaxValue(), (int)this.getStep());
        spinner.valueProperty().addListener(observable -> settingsBase.setValue(this.getId(), h.a((Object)spinner.getValue())));
        spinner.setPrefWidth(80.0);
        GridPane.setFillWidth((Node)spinner, (Boolean)false);
        if (bl || this.isReadOnly()) {
            spinner.setDisable(true);
        }
        return spinner;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getStep() {
        return this.step;
    }

    @Override
    public Object fromJson(Object object) {
        if (object == null) {
            return this.getDefaultValue();
        }
        if (object instanceof Integer) {
            return object;
        }
        return h.a((Object)object);
    }
}

