/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import bo.ap;
import bo.o;
import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.TradingHours;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Enums$MAMethod;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.StringResolver;
import com.motivewave.platform.ui.draw.graph.q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class Util {
    public static final int SECONDS_IN_MINUTE = 60;
    public static final int SECONDS_IN_HOUR = 3600;
    public static final int SECONDS_IN_DAY = 86400;
    public static final int SECONDS_IN_WEEK = 604800;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_MONTH = 2678400000L;
    public static final long MILLIS_IN_WEEK = 604800000L;
    public static final long MILLIS_IN_YEAR = 31557600000L;
    static StringResolver strings = StringResolver.getInstance("com.motivewave.platform.sdk.common.nls.strings");
    static final int INSIDE = 0;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final int BOTTOM = 4;
    static final int TOP = 8;
    private static Calendar cCal = Calendar.getInstance();
    private static Calendar cESTCal = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"));
    private static Calendar cGMTCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    @SafeVarargs
    public static List list(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            arrayList.add(object);
        }
        return arrayList;
    }

    public static Object first(List list) {
        if (Util.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static Object last(List list) {
        if (Util.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static int findNearest(List list, long l2) {
        return ab.a((List)list, (long)l2);
    }

    public static List tokenize(String string, char c) {
        return h.a((String)string, (char)c, (boolean)false);
    }

    public static void schedule(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        bh.h.a((boolean)true).execute(runnable);
    }

    public static Color awtColor(int n, int n2, int n3) {
        return UIUtil.a((int)n, (int)n2, (int)n3);
    }

    public static Color awtColor(int n, int n2, int n3, int n4) {
        return UIUtil.c((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static Color adjustColor(Color color, double d) {
        int n;
        int n2;
        if (d == 0.0) {
            return color;
        }
        int n3 = Math.max((int)((double)color.getRed() + (double)color.getRed() * d), 0);
        if (n3 > 255) {
            n3 = 255;
        }
        if ((n2 = Math.max((int)((double)color.getBlue() + (double)color.getBlue() * d), 0)) > 255) {
            n2 = 255;
        }
        if ((n = Math.max((int)((double)color.getGreen() + (double)color.getGreen() * d), 0)) > 255) {
            n = 255;
        }
        return UIUtil.b((int)n3, (int)n, (int)n2, (int)color.getAlpha());
    }

    public static FontMetrics getFontMetrics(Font font) {
        return UIUtil.a((Font)font);
    }

    public static long getStartOfBar(long l2, long l3, Instrument instrument, BarSize barSize, boolean bl) {
        if (barSize == null || barSize.isIntraday() || !barSize.isFixedSize() || instrument == null) {
            return l2;
        }
        long l4 = (l2 + l3) / 2L;
        if (barSize.getIntervalMinutes() == 43200) {
            return instrument.getStartOfMonth(l4, bl);
        }
        if (barSize.getIntervalMinutes() == 10080) {
            return instrument.getStartOfWeek(l4, bl);
        }
        if (barSize.getIntervalMinutes() == 1440) {
            return instrument.getStartOfDay(l4, bl);
        }
        MWInstrument mWInstrument = ((Ticker)instrument).getInstrument();
        return ab.a((MWInstrument)mWInstrument, (TradingHours)mWInstrument.getTradingHours(), (BarSize)barSize, (long)l4, (boolean)bl).a;
    }

    public static long getStartOfNextDay(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfDay(l2, bl);
        if (l3 > l2) {
            return l3;
        }
        l2 = l3 + 86400000L;
        long l4 = instrument.getStartOfDay(l2, bl);
        while (l4 <= l3) {
            l4 = instrument.getStartOfDay(l2 += 86400000L, bl);
        }
        return l4;
    }

    public static long getStartOfNextWeek(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfWeek(l2, bl);
        l2 = l3 + 604800000L;
        long l4 = instrument.getStartOfWeek(l2, bl);
        while (l4 <= l3) {
            l4 = instrument.getStartOfWeek(l2 += 86400000L, bl);
        }
        return l4;
    }

    public static long getStartOfNextMonth(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfMonth(l2, bl);
        if (l3 < l2 - 2246400000L) {
            l3 = instrument.getStartOfMonth(l2 + 86400000L, bl);
        }
        l2 = l3 + 1209600000L;
        long l4 = instrument.getStartOfMonth(l2, bl);
        while (l4 <= l3) {
            l4 = instrument.getStartOfMonth(l2 += 1209600000L, bl);
        }
        return l4;
    }

    public static long getStartOfNextYear(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfYear(l2, bl);
        if (l3 < l2 - 2246400000L) {
            l3 = instrument.getStartOfYear(l2 + 86400000L, bl);
        }
        l2 = l3 + 1209600000L;
        long l4 = instrument.getStartOfYear(l2, bl);
        while (l4 <= l3) {
            l4 = instrument.getStartOfYear(l2 += 1209600000L, bl);
        }
        return l4;
    }

    public static long getStartOfPrevDay(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfDay(l2, bl);
        l2 = l3 - 86400000L;
        long l4 = instrument.getStartOfDay(l2, bl);
        while (l4 >= l3) {
            l4 = instrument.getStartOfDay(l2 -= 86400000L, bl);
        }
        return l4;
    }

    public static long getStartOfPrevMonth(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfMonth(l2, bl);
        if (l3 < l2 - 2246400000L) {
            return l3;
        }
        l2 = l3 - 1209600000L;
        long l4 = instrument.getStartOfMonth(l2, bl);
        while (l4 >= l3) {
            l4 = instrument.getStartOfMonth(l2 -= 1209600000L, bl);
        }
        return l4;
    }

    public static long getStartOfPrevYear(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfYear(l2, bl);
        if (l3 < l2 - 1209600000L) {
            return l3;
        }
        l2 = l3 - 1209600000L;
        long l4 = instrument.getStartOfYear(l2, bl);
        while (l4 >= l3) {
            l4 = instrument.getStartOfYear(l2 -= 1209600000L, bl);
        }
        return l4;
    }

    public static long getStartOfPrevWeek(long l2, Instrument instrument, boolean bl) {
        long l3 = instrument.getStartOfWeek(l2, bl);
        l2 = l3 - 604800000L;
        long l4 = instrument.getStartOfWeek(l2, bl);
        while (l4 >= l3) {
            l4 = instrument.getStartOfWeek(l2 -= 86400000L, bl);
        }
        return l4;
    }

    public static long getEndOfBar(long l2, long l3, Instrument instrument, BarSize barSize, boolean bl) {
        if (barSize == null || barSize.isIntraday() || !barSize.isFixedSize()) {
            return l3;
        }
        long l4 = (l2 + l3) / 2L;
        if (barSize.getIntervalMinutes() == 43200) {
            return instrument.getEndOfMonth(l4, bl);
        }
        if (barSize.getIntervalMinutes() == 10080) {
            return instrument.getEndOfWeek(l4, bl);
        }
        if (barSize.getIntervalMinutes() == 1440) {
            return instrument.getEndOfDay(l4, bl);
        }
        MWInstrument mWInstrument = ((Ticker)instrument).getInstrument();
        return ab.a((MWInstrument)mWInstrument, (TradingHours)mWInstrument.getTradingHours(), (BarSize)barSize, (long)l4, (boolean)bl).b;
    }

    public static int strWidth(String string, Font font) {
        if (Util.isEmpty(string)) {
            return 0;
        }
        return (int)UIUtil.a((String)string, (Font)font);
    }

    public static File getExtensionsDirectory() {
        return ap.a();
    }

    public static double round(double d, int n) {
        long l2 = (long)Math.pow(10.0, n);
        long l3 = Math.round(d *= (double)l2);
        return (double)l3 / (double)l2;
    }

    public static double round(double d, double d2) {
        long l2 = Math.round(d / d2);
        return (double)l2 * d2;
    }

    public static float round(float f2, int n) {
        long l2 = (long)Math.pow(10.0, n);
        long l3 = Math.round(f2 *= (float)l2);
        return (float)l3 / (float)l2;
    }

    public static float round(float f2, float f3) {
        long l2 = Math.round(f2 / f3);
        return (float)l2 * f3;
    }

    public static Path2D createDownTriangle(int n, int n2, int n3) {
        Path2D.Double double_ = new Path2D.Double();
        int n4 = n3 * 2;
        ((Path2D)double_).moveTo(n - n4, n2 - n3);
        ((Path2D)double_).lineTo(n, n2 + n3 + 1);
        ((Path2D)double_).lineTo(n + n4, n2 - n3);
        double_.closePath();
        return double_;
    }

    public static Path2D createUpTriangle(int n, int n2, int n3) {
        Path2D.Double double_ = new Path2D.Double();
        int n4 = n3 * 2;
        ((Path2D)double_).moveTo(n - n4, n2 + n3);
        ((Path2D)double_).lineTo(n, n2 - (n3 + 1));
        ((Path2D)double_).lineTo(n + n4, n2 + n3);
        double_.closePath();
        return double_;
    }

    public static Point2D intersection(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        return Util.intersection(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static Point2D intersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d2 - d6) * (d7 - d5) - (d - d5) * (d8 - d6);
        double d10 = (d3 - d) * (d8 - d6) - (d4 - d2) * (d7 - d5);
        if (d10 == 0.0) {
            return null;
        }
        double d11 = d9 / d10;
        d9 = (d2 - d6) * (d3 - d) - (d - d5) * (d4 - d2);
        double d12 = d9 / d10;
        if (d11 < 0.0 || d11 > 1.0 || d12 < 0.0 || d12 > 1.0) {
            return null;
        }
        return new Point2D.Double(d + d11 * (d3 - d), d2 + d11 * (d4 - d2));
    }

    public static Point2D intersection(Line2D line2D, Line2D line2D2) {
        return Util.intersection(line2D.getP1(), line2D.getP2(), line2D2.getP1(), line2D2.getP2());
    }

    public static Line2D clipLine(Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        if (point2D.getX() > point2D2.getX()) {
            Point2D point2D3 = point2D;
            point2D = point2D2;
            point2D2 = point2D3;
        }
        return Util.cohenSutherlandLineClip(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), rectangle2D);
    }

    public static Line2D clipLine(double d, double d2, double d3, double d4, Rectangle2D rectangle2D) {
        return Util.clipLine(new Point2D.Double(d, d2), new Point2D.Double(d3, d4), rectangle2D);
    }

    public static Line2D clipLine(Line2D line2D, Rectangle2D rectangle2D) {
        return Util.clipLine(line2D.getP1(), line2D.getP2(), rectangle2D);
    }

    public static double[] rotate(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int k = 0; k < dArray2.length; k += 2) {
            double d2 = dArray[k];
            double d3 = dArray[k + 1];
            dArray2[k] = d2 * Math.cos(d) - d3 * Math.sin(d);
            dArray2[k + 1] = d2 * Math.sin(d) + d3 * Math.cos(d);
        }
        return dArray2;
    }

    public static Point2D midpoint(Line2D line2D) {
        return new Point2D.Double((line2D.getX1() + line2D.getX2()) / 2.0, (line2D.getY1() + line2D.getY2()) / 2.0);
    }

    public static Point2D midpoint(Point2D point2D, Point2D point2D2) {
        return new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
    }

    public static Point2D rotate(Point2D point2D, Point2D point2D2, double d) {
        double d2 = point2D.getX() - point2D2.getX();
        double d3 = point2D.getY() - point2D2.getY();
        double d4 = d2 * Math.cos(d) - d3 * Math.sin(d);
        double d5 = d2 * Math.sin(d) + d3 * Math.cos(d);
        return new Point2D.Double(d4 + point2D2.getX(), d5 + point2D2.getY());
    }

    public static Point2D rotate(double d, double d2, double d3, double d4, double d5) {
        double d6 = d - d3;
        double d7 = d2 - d4;
        double d8 = d6 * Math.cos(d5) - d7 * Math.sin(d5);
        double d9 = d6 * Math.sin(d5) + d7 * Math.cos(d5);
        return new Point2D.Double(d8 + d3, d9 + d4);
    }

    public static double slope(Line2D line2D) {
        return (line2D.getY2() - line2D.getY1()) / (line2D.getX2() - line2D.getX1());
    }

    public static double slope(Point2D point2D, Point2D point2D2) {
        return (point2D2.getY() - point2D.getY()) / (point2D2.getX() - point2D.getX());
    }

    public static double slope(double d, double d2, double d3, double d4) {
        return (d4 - d2) / (d3 - d);
    }

    public static double radiansToDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double degreesToRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    public static double calculateAngle(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.acos(d5 / Math.sqrt(d5 * d5 + d6 * d6));
        if (d6 < 0.0) {
            d7 = -d7;
        }
        return d7;
    }

    public static double calculateAngle(Point2D point2D, Point2D point2D2) {
        return Util.calculateAngle(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public static double calculateAngle(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d = Util.calculateAngle(point2D, point2D2);
        double d2 = Util.calculateAngle(point2D, point2D3);
        return Math.abs(d - d2);
    }

    public static double distanceFromLine(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = Math.min(d3, d5);
        if (d8 == (d7 = Math.max(d3, d5))) {
            double d9 = Math.min(d4, d6);
            double d10 = Math.max(d4, d6);
            if (d2 < d9) {
                return Util.distance(d, d2, d8, d9);
            }
            if (d2 > d10) {
                return Util.distance(d, d2, d8, d10);
            }
            return Math.abs(d - d8);
        }
        if (d < d8) {
            double d11 = d4;
            if (d5 < d3) {
                d11 = d6;
            }
            return Util.distance(d, d2, d8, d11);
        }
        if (d > d7) {
            double d12 = d4;
            if (d5 > d3) {
                d12 = d6;
            }
            return Util.distance(d, d2, d7, d12);
        }
        if (d5 == d3) {
            return Math.abs(d - d3);
        }
        if (d6 == d4) {
            return Math.abs(d2 - d4);
        }
        double d13 = (d6 - d4) / (d5 - d3);
        double d14 = d4 - d13 * d3;
        return Math.abs((-d13 * d + d2 - d14) / Math.sqrt(-d13 * -d13 + 1.0));
    }

    public static double distanceFromLine(double d, double d2, Line2D line2D) {
        return Util.distanceFromLine(d, d2, line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public static double distance(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Util.norm(d5, d6);
    }

    public static double distance(Point2D point2D, Point2D point2D2) {
        double d = point2D.getX() - point2D2.getX();
        double d2 = point2D.getY() - point2D2.getY();
        return Util.norm(d, d2);
    }

    public static double distance(Point2D point2D, int n, int n2) {
        double d = point2D.getX() - (double)n;
        double d2 = point2D.getY() - (double)n2;
        return Util.norm(d, d2);
    }

    public static double norm(double d, double d2) {
        return Math.sqrt(Util.dot(d, d2, d, d2));
    }

    public static double dot(double d, double d2, double d3, double d4) {
        return d * d3 + d2 * d4;
    }

    public static final boolean compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object2 == null) {
            return false;
        }
        if (object == object2) {
            return true;
        }
        return object.equals(object2);
    }

    public static final boolean in(String string, String ... stringArray) {
        return Util.in((Object)string, (Object[])stringArray);
    }

    public static final boolean in(Object object, Object ... objectArray) {
        if (objectArray == null) {
            return false;
        }
        for (int k = 0; k < objectArray.length; ++k) {
            if (!Util.compare(object, objectArray[k])) continue;
            return true;
        }
        return false;
    }

    public static final boolean in(int n, int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int k = 0; k < nArray.length; ++k) {
            if (n != nArray[k]) continue;
            return true;
        }
        return false;
    }

    public static final boolean in(double d, double[] dArray) {
        if (dArray == null) {
            return false;
        }
        for (int k = 0; k < dArray.length; ++k) {
            if (d != dArray[k]) continue;
            return true;
        }
        return false;
    }

    public static final boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof String) {
            return object.toString().trim().length() == 0;
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Enumeration) {
            return !((Enumeration)object).hasMoreElements();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).length == 0;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length == 0;
        }
        if (object instanceof char[]) {
            return ((char[])object).length == 0;
        }
        if (object instanceof short[]) {
            return ((short[])object).length == 0;
        }
        if (object instanceof int[]) {
            return ((int[])object).length == 0;
        }
        if (object instanceof long[]) {
            return ((long[])object).length == 0;
        }
        if (object instanceof float[]) {
            return ((float[])object).length == 0;
        }
        if (object instanceof double[]) {
            return ((double[])object).length == 0;
        }
        return false;
    }

    public static final Color getAlphaFill(Color color) {
        return Util.getAlphaFill(color, 70);
    }

    public static final Color getAlphaFill(Color color, int n) {
        if (color == null) {
            return color;
        }
        return UIUtil.c((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)n);
    }

    public static final Color fromHex(String string) {
        return UIUtil.b((String)string);
    }

    public static Color fixForeground(Color color, Color color2) {
        return UIUtil.a((Color)color, (Color)color2);
    }

    public static Color fixBackground(Color color, Color color2) {
        return UIUtil.b((Color)color2, (Color)color);
    }

    public static final Stroke getStroke(PathInfo pathInfo, boolean bl) {
        if (!bl) {
            return pathInfo.getStroke();
        }
        float[] fArray = pathInfo.getDash();
        if (fArray != null) {
            if (fArray.length > 0) {
                boolean bl2 = true;
                for (float f2 : fArray) {
                    if (f2 == 0.0f) continue;
                    bl2 = false;
                }
                if (bl2) {
                    fArray = null;
                }
            } else {
                fArray = null;
            }
        }
        return new BasicStroke(pathInfo.getStrokeWidth() + 1.0f, 1, 0, 1.0f, fArray, 0.0f);
    }

    public static double min(double ... dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int k = 1; k < dArray.length; ++k) {
            if (!(dArray[k] < d)) continue;
            d = dArray[k];
        }
        return d;
    }

    public static float minFloat(float ... fArray) {
        if (fArray.length == 0) {
            return 0.0f;
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f2 = fArray[0];
        for (int k = 1; k < fArray.length; ++k) {
            if (!(fArray[k] < f2)) continue;
            f2 = fArray[k];
        }
        return f2;
    }

    public static int minInt(int ... nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int k = 1; k < nArray.length; ++k) {
            if (nArray[k] >= n) continue;
            n = nArray[k];
        }
        return n;
    }

    public static long minLong(long ... lArray) {
        if (lArray.length == 0) {
            return 0L;
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l2 = lArray[0];
        for (int k = 1; k < lArray.length; ++k) {
            if (lArray[k] >= l2) continue;
            l2 = lArray[k];
        }
        return l2;
    }

    public static double max(double ... dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int k = 1; k < dArray.length; ++k) {
            if (!(dArray[k] > d)) continue;
            d = dArray[k];
        }
        return d;
    }

    public static float maxFloat(float ... fArray) {
        if (fArray.length == 0) {
            return 0.0f;
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f2 = fArray[0];
        for (int k = 1; k < fArray.length; ++k) {
            if (!(fArray[k] > f2)) continue;
            f2 = fArray[k];
        }
        return f2;
    }

    public static int maxInt(int ... nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int k = 1; k < nArray.length; ++k) {
            if (nArray[k] <= n) continue;
            n = nArray[k];
        }
        return n;
    }

    public static Double maxDouble(Double ... doubleArray) {
        if (doubleArray.length == 0) {
            return null;
        }
        if (doubleArray.length == 1) {
            return doubleArray[0];
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < doubleArray.length; ++k) {
            if (doubleArray[k] == null || !(doubleArray[k] > d)) continue;
            d = doubleArray[k];
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return d;
    }

    public static Double minDouble(Double ... doubleArray) {
        if (doubleArray.length == 0) {
            return null;
        }
        if (doubleArray.length == 1) {
            return doubleArray[0];
        }
        double d = Double.POSITIVE_INFINITY;
        for (int k = 0; k < doubleArray.length; ++k) {
            if (doubleArray[k] == null || !(doubleArray[k] < d)) continue;
            d = doubleArray[k];
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return d;
    }

    public static long maxLong(long ... lArray) {
        if (lArray.length == 0) {
            return 0L;
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l2 = lArray[0];
        for (int k = 1; k < lArray.length; ++k) {
            if (lArray[k] <= l2) continue;
            l2 = lArray[k];
        }
        return l2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    private static int computeOutCode(double d, double d2, Rectangle2D rectangle2D) {
        int n = 0;
        if (d < rectangle2D.getMinX()) {
            n |= 1;
        } else if (d > rectangle2D.getMaxX()) {
            n |= 2;
        }
        if (d2 < rectangle2D.getMinY()) {
            n |= 4;
        } else if (d2 > rectangle2D.getMaxY()) {
            n |= 8;
        }
        return n;
    }

    private static Line2D cohenSutherlandLineClip(double d, double d2, double d3, double d4, Rectangle2D rectangle2D) {
        int n = Util.computeOutCode(d, d2, rectangle2D);
        int n2 = Util.computeOutCode(d3, d4, rectangle2D);
        boolean bl = false;
        double d5 = rectangle2D.getMinX();
        double d6 = rectangle2D.getMaxX();
        double d7 = rectangle2D.getMinY();
        double d8 = rectangle2D.getMaxY();
        while (true) {
            int n3;
            if ((n | n2) == 0) {
                bl = true;
                break;
            }
            if ((n & n2) > 0) break;
            double d9 = 0.0;
            double d10 = 0.0;
            int n4 = n3 = n > 0 ? n : n2;
            if ((n3 & 8) > 0) {
                d9 = d + (d3 - d) * (d8 - d2) / (d4 - d2);
                d10 = d8;
            } else if ((n3 & 4) > 0) {
                d9 = d + (d3 - d) * (d7 - d2) / (d4 - d2);
                d10 = d7;
            } else if ((n3 & 2) > 0) {
                d10 = d2 + (d4 - d2) * (d6 - d) / (d3 - d);
                d9 = d6;
            } else if ((n3 & 1) > 0) {
                d10 = d2 + (d4 - d2) * (d5 - d) / (d3 - d);
                d9 = d5;
            }
            if (n3 == n) {
                d = d9;
                d2 = d10;
                n = Util.computeOutCode(d, d2, rectangle2D);
                continue;
            }
            d3 = d9;
            d4 = d10;
            n2 = Util.computeOutCode(d3, d4, rectangle2D);
        }
        if (bl) {
            return new Line2D.Double(d, d2, d3, d4);
        }
        return null;
    }

    public static final int toInt(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        String string = object.toString().trim();
        if (string.equals("")) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static final double toDouble(Object object) {
        return Util.toDouble(object, 0.0);
    }

    public static final double toDouble(Object object, double d) {
        if (object == null) {
            return d;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        String string = object.toString().trim();
        if (string.equals("")) {
            return 0.0;
        }
        return Double.valueOf(string);
    }

    public static final double toDouble(String string) {
        if (string == null || string == "") {
            return 0.0;
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return 0.0;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    public static long getMidnight(long l2) {
        return Util.getMidnight(cCal, l2);
    }

    public static long getMidnight(long l2, TimeZone timeZone) {
        return Util.getMidnight(h.a((TimeZone)timeZone), l2);
    }

    public static long getMidnightEST(long l2) {
        return Util.getMidnight(cESTCal, l2);
    }

    public static long getMidnightGMT(long l2) {
        return Util.getMidnight(cGMTCal, l2);
    }

    public static long getMidnight(Calendar calendar, long l2) {
        return h.a((Calendar)calendar, (long)l2);
    }

    public static long getNextDayMidnight(long l2) {
        return h.M((long)l2);
    }

    public static long getNextDayMidnight(long l2, TimeZone timeZone) {
        return h.w((long)l2, (TimeZone)timeZone);
    }

    public static String formatMMDDYYYY(long l2) {
        return h.h((long)l2);
    }

    public static String formatMMDDYYYY(long l2, TimeZone timeZone) {
        return h.c((long)l2, (TimeZone)timeZone);
    }

    public static String formatMMDDYYYYHHMM(long l2) {
        return h.d((long)l2);
    }

    public static String formatMMDDYYYYHHMM(long l2, TimeZone timeZone) {
        return h.a((long)l2, (TimeZone)timeZone);
    }

    public static String formatMMDDYYYYHHMMSS(long l2) {
        return h.g((long)l2);
    }

    public static String formatYYYYMMMDDHHSSMMM(long l2) {
        return h.o((long)l2);
    }

    public static String formatYYYYMMMDDHHSSMMM(long l2, TimeZone timeZone) {
        return h.g((long)l2, (TimeZone)timeZone);
    }

    public static long roundHour(long l2) {
        return h.b((long)l2);
    }

    public static long roundMinutes(long l2, int n) {
        return h.c((long)l2, (int)n);
    }

    public static Iterable reverse(List list) {
        return h.a((List)list);
    }

    public static String formatVol(double d, boolean bl) {
        if (bl) {
            return Util.formatMK(d);
        }
        return Util.formatDoubleShort(d, 5);
    }

    public static String formatMK(long l2) {
        return ab.c((long)l2);
    }

    public static String formatMK(double d) {
        return ab.c((long)((long)d));
    }

    public static final String formatDouble(double d, int n) {
        return h.c((double)d, (int)n);
    }

    public static final String formatFloat(float f2, int n) {
        return h.b((float)f2, (int)n);
    }

    public static final String formatDoubleShort(double d, int n) {
        return h.d((double)d, (int)n);
    }

    public static void calcLatestMA(DataContext dataContext, Enums$MAMethod enums$MAMethod, Object object, int n, int n2, Object object2, boolean bl) {
        int n3 = dataContext.getDataSeries().size() - 1;
        Util.calcMAAt(n3, dataContext, enums$MAMethod, object, n, n2, object2);
        if (n2 < 0 && bl) {
            for (int k = n3 + 1; k <= n3 - n2; ++k) {
                Util.calcMAAt(k, dataContext, enums$MAMethod, object, n, n2, object2);
            }
        }
    }

    public static void calcSeriesMA(DataContext dataContext, Enums$MAMethod enums$MAMethod, Object object, int n, int n2, Object object2, boolean bl, boolean bl2) {
        q q2;
        o o2 = (o)dataContext.getDataSeries();
        int n3 = 0;
        int n4 = o2.size() - 1;
        if (n3 <= n) {
            n3 = n - 1;
        }
        if (n2 < 0 && bl) {
            n4 -= n2;
        }
        q q3 = q2 = object instanceof q ? (q)object : null;
        if (q2 != null && q2.b()) {
            return;
        }
        for (int k = n3; k <= n4; ++k) {
            Double d;
            if (q2 != null && q2.b()) {
                return;
            }
            if (o2.isDestroyed()) {
                return;
            }
            if (k + n2 < 0 || o2.isComplete(k + n2, object2) || !bl2 && !o2.isBarComplete(k) || (d = o2.ma(enums$MAMethod, k, n, object)) == null) continue;
            o2.setDouble(k + n2, object2, d);
            o2.setComplete(k + n2, object2, k >= 0 && k < o2.size() - 1);
        }
    }

    public static void calcSeriesMA(DataContext dataContext, Enums$MAMethod enums$MAMethod, Object object, int n, int n2, Object object2, boolean bl) {
        Util.calcSeriesMA(dataContext, enums$MAMethod, object, n, n2, object2, bl, true);
    }

    public static void calcMAAt(int n, DataContext dataContext, Enums$MAMethod enums$MAMethod, Object object, int n2, int n3, Object object2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        if (dataSeries.isComplete(n + n3, object2)) {
            return;
        }
        Double d = dataSeries.ma(enums$MAMethod, n, n2, object);
        if (d == null) {
            return;
        }
        dataSeries.setDouble(n + n3, object2, d);
        dataSeries.setComplete(n + n3, object2, n >= 0 && n < dataSeries.size() - 1);
    }

    public static String formatMK(float f2) {
        return h.a((float)f2);
    }

    public static double roundDouble(double d, int n) {
        if (d == 0.0 || Double.isNaN(d) || d == Double.MAX_VALUE || d == Double.MIN_VALUE) {
            return d;
        }
        if (n == 0) {
            return Math.round(d);
        }
        long l2 = (long)Math.pow(10.0, n);
        long l3 = Math.round(d *= (double)l2);
        return (double)l3 / (double)l2;
    }

    public static double[] leastSquares(List list) {
        return h.a((List)list);
    }

    public static final String replaceAll(String string, String[] stringArray, String[] stringArray2) {
        if (string == null) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n2 = string.indexOf(stringArray[n4]);
            if ((n2 == -1 || n != -1) && (n2 <= -1 || n2 >= n)) continue;
            n = n2;
            n3 = n4;
        }
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.5));
        int n5 = 0;
        while (n >= n5) {
            stringBuilder.append(string.substring(n5, string.indexOf(stringArray[n3], n5)));
            stringBuilder.append(stringArray2[n3]);
            n5 = string.indexOf(stringArray[n3], n5) + stringArray[n3].length();
            n = 0;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                n2 = string.indexOf(stringArray[n4], n5);
                if (n2 == -1 || n != 0 && n2 >= n) continue;
                n = n2;
                n3 = n4;
            }
        }
        stringBuilder.append(string.substring(n5));
        return stringBuilder.toString();
    }

    public static final String replaceAll(String string, String[] stringArray, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n2 = string.indexOf(stringArray[n4]);
            if ((n2 == -1 || n != -1) && (n2 <= -1 || n2 >= n)) continue;
            n = n2;
            n3 = n4;
        }
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.5));
        int n5 = 0;
        while (n >= n5) {
            stringBuilder.append(string.substring(n5, string.indexOf(stringArray[n3], n5)));
            String string2 = "null";
            if (objectArray[n3] != null) {
                string2 = objectArray[n3].toString();
            }
            stringBuilder.append(string2);
            n5 = string.indexOf(stringArray[n3], n5) + stringArray[n3].length();
            n = 0;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                n2 = string.indexOf(stringArray[n4], n5);
                if (n2 == -1 || n != 0 && n2 >= n) continue;
                n = n2;
                n3 = n4;
            }
        }
        stringBuilder.append(string.substring(n5));
        return stringBuilder.toString();
    }

    public static final void replaceAll(Writer writer, String string, String[] stringArray, Object[] objectArray) {
        if (string == null) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n2 = string.indexOf(stringArray[n4]);
            if ((n2 == -1 || n != -1) && (n2 <= -1 || n2 >= n)) continue;
            n = n2;
            n3 = n4;
        }
        if (n == -1) {
            writer.write(string);
            return;
        }
        int n5 = 0;
        while (n >= n5) {
            writer.write(string.substring(n5, string.indexOf(stringArray[n3], n5)));
            if (objectArray[n3] == null) {
                writer.write("null");
            } else {
                writer.write(objectArray[n3].toString());
            }
            n5 = string.indexOf(stringArray[n3], n5) + stringArray[n3].length();
            n = 0;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                n2 = string.indexOf(stringArray[n4], n5);
                if (n2 == -1 || n != 0 && n2 >= n) continue;
                n = n2;
                n3 = n4;
            }
        }
        writer.write(string.substring(n5));
    }

    public static final String replace(String string, String[] stringArray, String[] stringArray2) {
        if (string == null) {
            return null;
        }
        int n = 0;
        if ((n = Util.findClosestPattern(string, stringArray, n)) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.5));
        int n2 = 0;
        int n3 = stringArray[n].length();
        while (n != -1) {
            stringBuffer.append(string.substring(n2, string.indexOf(stringArray[n])));
            stringBuffer.append(stringArray2[n]);
            n2 = string.indexOf(stringArray[n]) + n3;
            n = Util.findClosestPattern(string, stringArray, n);
        }
        stringBuffer.append(string.substring(n2));
        return string;
    }

    private static final int findClosestPattern(String string, String[] stringArray, int n) {
        for (int k = n; k < stringArray.length; ++k) {
            int n2 = string.indexOf(stringArray[k]);
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }
}

