/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.a;
import com.motivewave.platform.sdk.common.BaseInfo;
import java.awt.Color;
import java.awt.Stroke;
import java.util.List;

public class TimeFrame
extends BaseInfo {
    private int startTime;
    private int endTime;
    private Color startColor;
    private float[] startDash = new float[]{3.0f, 3.0f};
    private float startWidth = 1.0f;
    private boolean showStart = true;
    private Color endColor;
    private float[] endDash = new float[]{3.0f, 3.0f};
    private float endWidth = 1.0f;
    private boolean showEnd = true;
    private Color fillColor;
    private boolean showFill = true;
    private Stroke startStroke = null;
    private Stroke endStroke = null;

    public TimeFrame() {
        this(0, 0, false);
    }

    public TimeFrame(int n, int n2, boolean bl) {
        super(bl);
        this.startTime = n;
        this.endTime = n2;
        this.updateKey();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int n) {
        this.startTime = n;
        this.updateKey();
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int n) {
        this.endTime = n;
        this.updateKey();
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color color) {
        this.startColor = color;
        this.updateKey();
    }

    public float[] getStartDash() {
        return this.startDash;
    }

    public void setStartDash(float[] fArray) {
        this.startDash = fArray;
        this.startStroke = null;
        this.updateKey();
    }

    public float getStartWidth() {
        return this.startWidth;
    }

    public void setStartWidth(float f2) {
        this.startWidth = f2;
        this.startStroke = null;
        this.updateKey();
    }

    public boolean isShowStart() {
        return this.showStart;
    }

    public void setShowStart(boolean bl) {
        this.showStart = bl;
        this.updateKey();
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color color) {
        this.endColor = color;
        this.updateKey();
    }

    public float[] getEndDash() {
        return this.endDash;
    }

    public void setEndDash(float[] fArray) {
        this.endDash = fArray;
        this.endStroke = null;
        this.updateKey();
    }

    public float getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(float f2) {
        this.endWidth = f2;
        this.endStroke = null;
        this.updateKey();
    }

    public boolean isShowEnd() {
        return this.showEnd;
    }

    public void setShowEnd(boolean bl) {
        this.showEnd = bl;
        this.updateKey();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.updateKey();
    }

    public boolean isShowFill() {
        return this.showFill;
    }

    public void setShowFill(boolean bl) {
        this.showFill = bl;
        this.updateKey();
    }

    public Stroke getStartStroke() {
        if (this.startStroke == null) {
            this.startStroke = UIUtil.a((float)this.startWidth, (float[])this.startDash);
        }
        return this.startStroke;
    }

    public Stroke getEndStroke() {
        if (this.endStroke == null) {
            this.endStroke = UIUtil.a((float)this.endWidth, (float[])this.endDash);
        }
        return this.endStroke;
    }

    public void copyFrom(TimeFrame timeFrame) {
        this.startTime = timeFrame.startTime;
        this.endTime = timeFrame.endTime;
        this.setEnabled(timeFrame.isEnabled());
        this.startColor = timeFrame.startColor;
        this.startDash = timeFrame.startDash;
        this.startWidth = timeFrame.startWidth;
        this.showStart = timeFrame.showStart;
        this.endColor = timeFrame.endColor;
        this.endDash = timeFrame.endDash;
        this.endWidth = timeFrame.endWidth;
        this.showEnd = timeFrame.showEnd;
        this.fillColor = timeFrame.fillColor;
        this.showFill = timeFrame.showFill;
        this.startStroke = null;
        this.endStroke = null;
    }

    @Override
    public String toString() {
        return h.q((long)this.startTime) + " - " + h.q((long)this.endTime);
    }

    @Override
    protected void updateKey() {
        this.setKey(this.startTime + "|" + UIUtil.c((Color)this.startColor) + "|" + h.a((float[])this.startDash) + "|" + this.startWidth + "|" + this.showStart + "|" + this.endTime + "|" + UIUtil.c((Color)this.endColor) + "|" + h.a((float[])this.endDash) + "|" + this.endWidth + "|" + this.showEnd + "|" + UIUtil.c((Color)this.fillColor) + "|" + this.showFill + "|" + this.isEnabled());
    }

    @Override
    public TimeFrame clone() {
        try {
            return (TimeFrame)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object toJson(BaseInfo baseInfo) {
        TimeFrame timeFrame = null;
        if (baseInfo != null) {
            timeFrame = (TimeFrame)baseInfo;
        }
        if (this.equals(timeFrame)) {
            return null;
        }
        if (!this.isEnabled() && timeFrame != null && this.startTime == timeFrame.startTime && h.a((float[])this.startDash, (float[])timeFrame.startDash) && h.a((Object)this.startColor, (Object)timeFrame.startColor) && this.startWidth == timeFrame.startWidth && this.showStart == timeFrame.showStart && this.endTime == timeFrame.endTime && h.a((float[])this.endDash, (float[])timeFrame.endDash) && h.a((Object)this.endColor, (Object)timeFrame.endColor) && this.endWidth == timeFrame.endWidth && this.showEnd == timeFrame.showEnd && h.a((Object)this.fillColor, (Object)timeFrame.fillColor) && this.showFill == timeFrame.showFill) {
            return "N";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isEnabled()) {
            stringBuffer.append("N,");
        }
        if (timeFrame == null || this.startTime != timeFrame.startTime) {
            stringBuffer.append(this.startTime);
        }
        stringBuffer.append(",");
        if (timeFrame == null || this.startWidth != timeFrame.startWidth) {
            stringBuffer.append(h.d((double)this.startWidth, (int)4));
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((Object)this.startColor, (Object)timeFrame.startColor)) {
            stringBuffer.append(UIUtil.c((Color)this.startColor));
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((float[])this.startDash, (float[])timeFrame.startDash)) {
            stringBuffer.append(h.b((float[])this.startDash));
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((Object)this.showStart, (Object)timeFrame.showStart)) {
            stringBuffer.append(this.showStart ? "Y" : "N");
        }
        stringBuffer.append(",");
        if (timeFrame == null || this.endTime != timeFrame.endTime) {
            stringBuffer.append(this.endTime);
        }
        stringBuffer.append(",");
        if (timeFrame == null || this.endWidth != timeFrame.endWidth) {
            stringBuffer.append(h.d((double)this.endWidth, (int)4));
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((Object)this.endColor, (Object)timeFrame.endColor)) {
            stringBuffer.append(UIUtil.c((Color)this.endColor));
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((float[])this.endDash, (float[])timeFrame.endDash)) {
            stringBuffer.append(h.b((float[])this.endDash));
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((Object)this.showEnd, (Object)timeFrame.showEnd)) {
            stringBuffer.append(this.showEnd ? "Y" : "N");
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((Object)this.fillColor, (Object)timeFrame.fillColor)) {
            stringBuffer.append(UIUtil.c((Color)this.fillColor));
        }
        stringBuffer.append(",");
        if (timeFrame == null || !h.a((Object)this.showFill, (Object)timeFrame.showFill)) {
            stringBuffer.append(this.showFill ? "Y" : "N");
        }
        h.a((StringBuffer)stringBuffer, (char)',');
        return stringBuffer.toString();
    }

    public static TimeFrame fromJson(Object object, TimeFrame timeFrame) {
        Color color;
        boolean bl;
        float[] fArray;
        Color color2;
        float f2;
        int n;
        boolean bl2;
        float[] fArray2;
        Color color3;
        float f3;
        int n2;
        boolean bl3;
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        if (string.equals("") && timeFrame != null) {
            return timeFrame;
        }
        if (h.a((Object)string, (Object)"N") && timeFrame != null) {
            TimeFrame timeFrame2 = new TimeFrame(timeFrame.startTime, timeFrame.endTime, timeFrame.isEnabled());
            timeFrame2.setStartWidth(timeFrame.getStartWidth());
            timeFrame2.setStartColor(timeFrame.getStartColor());
            timeFrame2.setStartDash(timeFrame.getStartDash());
            timeFrame2.setShowStart(timeFrame.showStart);
            timeFrame2.setEndWidth(timeFrame.getEndWidth());
            timeFrame2.setEndColor(timeFrame.getEndColor());
            timeFrame2.setEndDash(timeFrame.getEndDash());
            timeFrame2.setShowEnd(timeFrame.showEnd);
            timeFrame2.setShowFill(timeFrame.showFill);
            timeFrame2.setFillColor(timeFrame.fillColor);
            return timeFrame2;
        }
        boolean bl4 = bl3 = !string.startsWith("N,");
        if (!bl3) {
            string = string.substring(2);
        }
        List list = a.a((String)string);
        int n3 = 0;
        int n4 = list.size() <= n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? 0 : timeFrame.startTime) : (n2 = h.b((String)((String)list.get(n3))));
        float f4 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? 1.0f : timeFrame.startWidth) : (f3 = h.b((String)((String)list.get(n3))));
        Color color4 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? null : timeFrame.startColor) : (color3 = UIUtil.a((String)((String)list.get(n3))));
        if (list.size() <= ++n3 || h.a(list.get(n3), (Object)"")) {
            if (timeFrame == null) {
                float[] fArray3 = new float[2];
                fArray3[0] = 3.0f;
                v5 = fArray3;
                fArray3[1] = 3.0f;
            } else {
                v5 = timeFrame.startDash;
            }
        } else {
            v5 = fArray2 = h.b((String)((String)list.get(n3)));
        }
        boolean bl5 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? true : timeFrame.showStart) : (bl2 = h.c(list.get(n3)));
        int n5 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? 0 : timeFrame.endTime) : (n = h.b((String)((String)list.get(n3))));
        float f5 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? 1.0f : timeFrame.endWidth) : (f2 = h.b((String)((String)list.get(n3))));
        Color color5 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? null : timeFrame.endColor) : (color2 = UIUtil.a((String)((String)list.get(n3))));
        if (list.size() <= ++n3 || h.a(list.get(n3), (Object)"")) {
            if (timeFrame == null) {
                float[] fArray4 = new float[2];
                fArray4[0] = 3.0f;
                v11 = fArray4;
                fArray4[1] = 3.0f;
            } else {
                v11 = timeFrame.endDash;
            }
        } else {
            v11 = fArray = h.b((String)((String)list.get(n3)));
        }
        boolean bl6 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? true : timeFrame.showEnd) : (bl = h.c(list.get(n3)));
        Color color6 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? null : timeFrame.fillColor) : (color = UIUtil.a((String)((String)list.get(n3))));
        boolean bl7 = list.size() <= ++n3 || h.a(list.get(n3), (Object)"") ? (timeFrame == null ? true : timeFrame.showFill) : h.c(list.get(n3));
        ++n3;
        TimeFrame timeFrame3 = new TimeFrame(n2, n, bl3);
        timeFrame3.setStartWidth(f3);
        timeFrame3.setStartColor(color3);
        timeFrame3.setStartDash(fArray2);
        timeFrame3.setShowStart(bl2);
        timeFrame3.setEndWidth(f2);
        timeFrame3.setEndColor(color2);
        timeFrame3.setEndDash(fArray);
        timeFrame3.setShowEnd(bl);
        timeFrame3.setShowFill(bl7);
        timeFrame3.setFillColor(color);
        return timeFrame3;
    }
}

